/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.api;

import com.icthh.xm.commons.config.client.api.ConfigService;
import com.icthh.xm.commons.config.client.api.ConfigurationChangedListener;
import com.icthh.xm.commons.config.domain.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigService
implements ConfigService {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigService.class);
    private final List<ConfigurationChangedListener> configurationListeners = new ArrayList<ConfigurationChangedListener>();

    @Override
    public void addConfigurationChangedListener(ConfigurationChangedListener configurationListener) {
        this.configurationListeners.add(configurationListener);
    }

    @Override
    public void updateConfigurations(String commit, Collection<String> paths) {
        Map<String, Configuration> configurationsMap = this.getConfigurationMap(commit, paths);
        paths.forEach(path -> this.notifyUpdated(this.getNonNullConfiguration(configurationsMap, (String)path)));
        this.configurationListeners.forEach(it -> it.refreshFinished(paths));
    }

    protected void notifyUpdated(Configuration configuration) {
        log.debug("Notify configuration changed [{}]", (Object)(configuration != null ? configuration.getPath() : null));
        if (configuration == null) {
            return;
        }
        this.configurationListeners.forEach(configurationListener -> configurationListener.onConfigurationChanged(configuration));
    }

    private Configuration getNonNullConfiguration(Map<String, Configuration> configurationsMap, String path) {
        return Optional.ofNullable(configurationsMap.get(path)).orElseGet(() -> new Configuration(path, null));
    }
}

