/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.client.feign.config;

import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.lang.reflect.Type;
import java.net.URI;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequestEntityConverter;
import org.springframework.util.MultiValueMap;

public class TenantAwareGrantRequestEntityConverter
implements Converter<OAuth2ClientCredentialsGrantRequest, RequestEntity<?>> {
    private static final String TENANT_HEADER_NAME = "X-Tenant";
    private final TenantContextHolder tenantContextHolder;
    private final OAuth2ClientCredentialsGrantRequestEntityConverter defaultConverter;

    public RequestEntity<?> convert(OAuth2ClientCredentialsGrantRequest authorizationGrantRequest) {
        RequestEntity entity = this.defaultConverter.convert((AbstractOAuth2AuthorizationGrantRequest)authorizationGrantRequest);
        if (entity != null) {
            HttpHeaders entityHeaders = HttpHeaders.writableHttpHeaders((HttpHeaders)entity.getHeaders());
            entityHeaders.add(TENANT_HEADER_NAME, this.tenantContextHolder.getTenantKey());
            HttpMethod method = entity.getMethod();
            Type type = entity.getType();
            Object body = entity.getBody();
            URI url = entity.getUrl();
            return new RequestEntity(body, (MultiValueMap)entityHeaders, method, url, type);
        }
        return null;
    }

    public TenantAwareGrantRequestEntityConverter(TenantContextHolder tenantContextHolder, OAuth2ClientCredentialsGrantRequestEntityConverter defaultConverter) {
        this.tenantContextHolder = tenantContextHolder;
        this.defaultConverter = defaultConverter;
    }
}

