/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.cache.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.cache.config.XmTenantLepCacheConfig;
import com.icthh.xm.commons.cache.service.InitCachesEvent;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.AntPathMatcher;

public class XmCacheConfigurer
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XmCacheConfigurer.class);
    private static final String TENANT_NAME = "tenant";
    private final String configPath;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final ObjectMapper ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public XmCacheConfigurer(@Value(value="${spring.application.name}") String appName, ApplicationEventPublisher applicationEventPublisher) {
        this.configPath = "/config/tenants/{tenant}/" + appName + "/cache.yml";
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void onRefresh(String updatedKey, String config) {
        if (this.isListeningConfiguration(updatedKey)) {
            this.refreshCaches(updatedKey, config);
        }
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(this.configPath, updatedKey);
    }

    private void refreshCaches(String updatedKey, String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            return;
        }
        String tenantKey = this.extractTenant(updatedKey);
        List<XmTenantLepCacheConfig.XmCacheConfiguration> items = this.readConfig(updatedKey, config);
        InitCachesEvent event = new InitCachesEvent(this, tenantKey, items);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }

    protected List<XmTenantLepCacheConfig.XmCacheConfiguration> readConfig(String updatedKey, String config) {
        List cfg = List.of();
        try {
            cfg = (List)this.ymlMapper.readValue(config, (TypeReference)new TypeReference<List<XmTenantLepCacheConfig.XmCacheConfiguration>>(){});
        }
        catch (Exception e) {
            log.error("Error reading event publisher config from path: {}", (Object)updatedKey, (Object)e);
        }
        return cfg;
    }

    protected String extractTenant(String updatedKey) {
        return (String)this.matcher.extractUriTemplateVariables(this.configPath, updatedKey).get(TENANT_NAME);
    }
}

