package org.security.base64

/**
 *
 * base64加解密方法，考虑到包含文件流的加解密，输入全部使用byte数组，base64后返回字符串，解密统一返回byte数组
 * @author lulu <a href="mailto:wangll1@asp.citic.com">Contact me.</a>
 * @version 1.0s
 * @since 2018/10/14 2:44 PM
 */
object Base64{

    init {
        System.loadLibrary("base64")
    }

    /**
     * base64加密
     * @param data 需要加密的数据（byte数组类型）
     * @return base64后的字符串
     */
    external fun base64Encode(data:ByteArray):String

    /**
     * base64加密
     * @param data 需要解密的数据（ByteArray类型）
     * @return base64解密后的字节数组（ByteArray）
     */
    external fun base64Decode(data:ByteArray):ByteArray








}