/*
 * Decompiled with CFR 0.152.
 */
package com.iceteck.silicompressorr;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import androidx.exifinterface.media.ExifInterface;
import com.iceteck.silicompressorr.videocompression.MediaController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SiliCompressor {
    private static final String LOG_TAG = SiliCompressor.class.getSimpleName();
    public static String videoCompressionPath;
    private static final String IMAGE_DESTINATION = "Silicompressor/images";
    static volatile SiliCompressor singleton;
    private static Context mContext;
    private static final String FILE_PROVIDER_AUTHORITY = ".iceteck.silicompressor.provider";

    public SiliCompressor(Context context) {
        mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SiliCompressor with(Context context) {
        if (singleton != null) return singleton;
        Class<SiliCompressor> clazz = SiliCompressor.class;
        synchronized (SiliCompressor.class) {
            if (singleton != null) return singleton;
            singleton = new Builder(context).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private static boolean deleteImageFile(String imageUri) {
        Uri uri = Uri.parse((String)imageUri);
        int cnt = mContext.getContentResolver().delete(uri, null, null);
        return cnt > 0;
    }

    public String compress(String uriString, File destination) {
        return this.compressImage(uriString, destination);
    }

    protected static String getAuthorities(@NonNull Context context) {
        return context.getPackageName() + FILE_PROVIDER_AUTHORITY;
    }

    public Bitmap getCompressBitmap(String imagePath) throws IOException {
        return this.getCompressBitmap(imagePath, false);
    }

    public String compress(String uriString, File destination, boolean deleteSourceImage) {
        String compressedImagePath = this.compressImage(uriString, destination);
        if (deleteSourceImage) {
            boolean isdeleted = SiliCompressor.deleteImageFile(uriString);
            Log.d((String)LOG_TAG, (String)(isdeleted ? "Source image file deleted" : "Error: Source image file not deleted."));
        }
        return compressedImagePath;
    }

    public Bitmap getCompressBitmap(String imageUri, boolean deleteSourceImage) throws IOException {
        String compressedImageUriString = this.compressImage(imageUri, new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), IMAGE_DESTINATION));
        Bitmap bitmap = null;
        bitmap = Build.VERSION.SDK_INT >= 29 ? MediaStore.Images.Media.getBitmap((ContentResolver)mContext.getContentResolver(), (Uri)Uri.parse((String)compressedImageUriString)) : MediaStore.Images.Media.getBitmap((ContentResolver)mContext.getContentResolver(), (Uri)Uri.fromFile((File)new File(compressedImageUriString)));
        if (deleteSourceImage) {
            boolean isdeleted = SiliCompressor.deleteImageFile(imageUri);
            Log.d((String)LOG_TAG, (String)(isdeleted ? "Source image file deleted" : "Error: Source image file not deleted."));
        }
        return bitmap;
    }

    public String compressVideo(String videoFilePath, String destinationDir) throws URISyntaxException {
        return this.compressVideo(videoFilePath, destinationDir, 0, 0, 0);
    }

    public String compressVideo(Uri videoContentUri, String destinationDir) throws URISyntaxException {
        return this.compressVideo(videoContentUri, destinationDir, 0, 0, 0);
    }

    public String compressVideo(String videoFilePath, String destinationDir, int outWidth, int outHeight, int bitrate) throws URISyntaxException {
        boolean isconverted = MediaController.getInstance(mContext).convertVideo(videoFilePath, new File(destinationDir), outWidth, outHeight, bitrate);
        if (isconverted) {
            Log.v((String)LOG_TAG, (String)"Video Conversion Complete");
        } else {
            Log.v((String)LOG_TAG, (String)"Video conversion in progress");
        }
        return MediaController.cachedFile.getPath();
    }

    public String compressVideo(Uri videoContentUri, String destinationDir, int outWidth, int outHeight, int bitrate) throws URISyntaxException {
        boolean isConverted = MediaController.getInstance(mContext).convertVideo(mContext, videoContentUri, new File(destinationDir), outWidth, outHeight, bitrate);
        if (isConverted) {
            Log.v((String)LOG_TAG, (String)"Video Conversion Complete");
        } else {
            Log.v((String)LOG_TAG, (String)"Video conversion in progress");
        }
        return MediaController.cachedFile.getPath();
    }

    private int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    private String getFilename(String filename, File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        String ext = ".jpg";
        String nameFirstPart = file.getAbsolutePath() + "/IMG_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String nameFull = nameFirstPart + ext;
        int x = 1;
        while (new File(nameFull).exists()) {
            nameFull = nameFirstPart + "_" + x + ext;
            ++x;
        }
        return nameFull;
    }

    private String compressImage(String uriString, File destDirectory) {
        try {
            Uri imageUri = Uri.parse((String)uriString);
            Bitmap scaledBitmap = null;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Bitmap bmp = BitmapFactory.decodeStream((InputStream)mContext.getContentResolver().openInputStream(imageUri), null, (BitmapFactory.Options)options);
            int actualHeight = options.outHeight;
            int actualWidth = options.outWidth;
            float maxHeight = 816.0f;
            float maxWidth = 612.0f;
            float imgRatio = actualWidth / actualHeight;
            float maxRatio = maxWidth / maxHeight;
            if ((float)actualHeight > maxHeight || (float)actualWidth > maxWidth) {
                if (imgRatio < maxRatio) {
                    imgRatio = maxHeight / (float)actualHeight;
                    actualWidth = (int)(imgRatio * (float)actualWidth);
                    actualHeight = (int)maxHeight;
                } else if (imgRatio > maxRatio) {
                    imgRatio = maxWidth / (float)actualWidth;
                    actualHeight = (int)(imgRatio * (float)actualHeight);
                    actualWidth = (int)maxWidth;
                } else {
                    actualHeight = (int)maxHeight;
                    actualWidth = (int)maxWidth;
                }
            }
            options.inSampleSize = this.calculateInSampleSize(options, actualWidth, actualHeight);
            options.inJustDecodeBounds = false;
            options.inPurgeable = true;
            options.inInputShareable = true;
            options.inTempStorage = new byte[16384];
            bmp = BitmapFactory.decodeStream((InputStream)mContext.getContentResolver().openInputStream(imageUri), null, (BitmapFactory.Options)options);
            scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            float ratioX = (float)actualWidth / (float)options.outWidth;
            float ratioY = (float)actualHeight / (float)options.outHeight;
            float middleX = (float)actualWidth / 2.0f;
            float middleY = (float)actualHeight / 2.0f;
            Matrix scaleMatrix = new Matrix();
            scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
            Canvas canvas = new Canvas(scaledBitmap);
            canvas.setMatrix(scaleMatrix);
            canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
            try {
                ExifInterface exif = new ExifInterface(mContext.getContentResolver().openInputStream(imageUri));
                int orientation = exif.getAttributeInt("Orientation", 0);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
                Matrix matrix = new Matrix();
                if (orientation == 6) {
                    matrix.postRotate(90.0f);
                    Log.d((String)"EXIF", (String)("Exif: " + orientation));
                } else if (orientation == 3) {
                    matrix.postRotate(180.0f);
                    Log.d((String)"EXIF", (String)("Exif: " + orientation));
                } else if (orientation == 8) {
                    matrix.postRotate(270.0f);
                    Log.d((String)"EXIF", (String)("Exif: " + orientation));
                }
                scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (Build.VERSION.SDK_INT >= 29) {
                String fileName = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".jpg";
                ContentValues values = new ContentValues();
                values.put("_display_name", fileName);
                values.put("mime_type", "image/jpeg");
                values.put("relative_path", "Pictures/SiliCompressor/");
                values.put("is_pending", Integer.valueOf(1));
                Uri collection = MediaStore.Images.Media.getContentUri((String)"external_primary");
                Uri resultUri = mContext.getContentResolver().insert(collection, values);
                OutputStream out = mContext.getContentResolver().openOutputStream(resultUri);
                scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, out);
                values.clear();
                values.put("is_pending", Integer.valueOf(0));
                mContext.getContentResolver().update(resultUri, values, null, null);
                return resultUri.toString();
            }
            String filename = this.getFilename(uriString, destDirectory);
            FileOutputStream out = new FileOutputStream(filename);
            scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
            return filename;
        }
        catch (FileNotFoundException | OutOfMemoryError e) {
            e.printStackTrace();
            return null;
        }
    }

    public String compress(int drawableID) {
        try {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)mContext.getApplicationContext().getResources(), (int)drawableID);
            if (null != bitmap) {
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(new Date());
                String imageFileName = "JPEG_" + timeStamp + "_";
                File storageDir = mContext.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                File image = File.createTempFile(imageFileName, ".jpg", storageDir);
                FileOutputStream out = new FileOutputStream(image);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                out.close();
                Uri copyImageUri = FileProvider.getUriForFile((Context)mContext, (String)SiliCompressor.getAuthorities(mContext), (File)image);
                String compressedImagePath = this.compressImage(copyImageUri.toString(), new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), IMAGE_DESTINATION));
                if (image.exists()) {
                    SiliCompressor.deleteImageFile(copyImageUri.toString());
                }
                return compressedImagePath;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        singleton = null;
    }

    public static class Builder {
        private final Context context;

        Builder(@NonNull Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public SiliCompressor build() {
            Context context = this.context;
            return new SiliCompressor(context);
        }
    }
}

