/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class IdRange {
    private static final String PATTERN_SEQ_NUMBER = "(\\*|\\d+)";
    private static final String PATTERN_SEQ_RANGE = "((\\*|\\d+):(\\*|\\d+))";
    private static final String PATTERN_SEQ_NUM_OR_RANGE = "((\\*|\\d+)|((\\*|\\d+):(\\*|\\d+)))";
    private static final String PATTERN_SEQ_SET = "((\\*|\\d+)|((\\*|\\d+):(\\*|\\d+)))(,(((\\*|\\d+)|((\\*|\\d+):(\\*|\\d+)))))*";
    public static final Pattern SEQUENCE = Pattern.compile("((\\*|\\d+)|((\\*|\\d+):(\\*|\\d+)))(,(((\\*|\\d+)|((\\*|\\d+):(\\*|\\d+)))))*");
    public static final long VALUE_WILDCARD = Long.MAX_VALUE;
    private final long lowVal;
    private final long highVal;

    public IdRange(long singleVal) {
        this.lowVal = singleVal;
        this.highVal = singleVal;
    }

    public IdRange(long lowVal, long highVal) {
        this.lowVal = lowVal;
        this.highVal = highVal;
    }

    public long getLowVal() {
        return this.lowVal;
    }

    public long getHighVal() {
        return this.highVal;
    }

    public boolean includes(long uid) {
        return this.lowVal <= uid && uid <= this.highVal;
    }

    public static List<IdRange> parseRangeSequence(String idRangeSequence) {
        StringTokenizer tokenizer = new StringTokenizer(idRangeSequence, ",");
        ArrayList<IdRange> ranges = new ArrayList<IdRange>();
        while (tokenizer.hasMoreTokens()) {
            ranges.add(IdRange.parseRange(tokenizer.nextToken()));
        }
        return ranges;
    }

    public static IdRange parseRange(String range) {
        int pos = range.indexOf(58);
        try {
            long highVal;
            if (pos == -1) {
                long value = IdRange.parseLong(range);
                return new IdRange(value);
            }
            long lowVal = IdRange.parseLong(range.substring(0, pos));
            if (lowVal > (highVal = IdRange.parseLong(range.substring(pos + 1)))) {
                return new IdRange(highVal, lowVal);
            }
            return new IdRange(lowVal, highVal);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid message set " + range);
        }
    }

    public static IdRange[] convertUidsToIdRangeArray(List<Long> uids) {
        if (uids == null || uids.isEmpty()) {
            return new IdRange[0];
        }
        LinkedList<Long> uidsLocal = new LinkedList<Long>(uids);
        Collections.sort(uidsLocal);
        LinkedList<IdRange> ids = new LinkedList<IdRange>();
        IdRange currentIdRange = new IdRange((Long)uidsLocal.get(0));
        for (Long uid : uidsLocal) {
            if (uid > currentIdRange.getHighVal() && uid == currentIdRange.getHighVal() + 1L) {
                currentIdRange = new IdRange(currentIdRange.getLowVal(), uid);
                continue;
            }
            ids.add(currentIdRange);
            currentIdRange = new IdRange(uid);
        }
        if (!ids.contains(currentIdRange)) {
            ids.add(currentIdRange);
        }
        return ids.toArray(new IdRange[0]);
    }

    public static String uidsToRangeString(List<Long> uids) {
        return IdRange.idRangesToString(IdRange.convertUidsToIdRangeArray(uids));
    }

    public static String idRangeToString(IdRange idRange) {
        return idRange.getHighVal() == idRange.getLowVal() ? Long.toString(idRange.getLowVal()) : idRange.getLowVal() + ":" + idRange.getHighVal();
    }

    public static String idRangesToString(IdRange[] idRanges) {
        StringBuilder sb = new StringBuilder();
        for (IdRange idRange : idRanges) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(IdRange.idRangeToString(idRange));
        }
        return sb.toString();
    }

    private static long parseLong(String value) {
        if (value.length() == 1 && value.charAt(0) == '*') {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(value);
    }

    public static boolean containsUid(IdRange[] idRanges, long uid) {
        if (null != idRanges && idRanges.length > 0) {
            for (IdRange range : idRanges) {
                if (!range.includes(uid)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.lowVal == this.highVal ? Long.toString(this.lowVal) : this.lowVal + ":" + this.highVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdRange)) {
            return false;
        }
        IdRange idRange = (IdRange)o;
        return this.lowVal == idRange.lowVal && this.highVal == idRange.highVal;
    }

    public int hashCode() {
        return Objects.hash(this.lowVal, this.highVal);
    }
}

