/*
 * Decompiled with CFR 0.152.
 */
package crashreporter.crashlytics;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.crashlytics.android.Crashlytics;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.CustomEvent;
import com.crashlytics.android.core.CrashlyticsCore;
import com.crashlytics.android.core.CrashlyticsListener;
import com.icapps.crashreporter.CrashReporter;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;

public class CrashlyticsCrashReporter
implements CrashReporter {
    private static final String TAG = CrashlyticsCrashReporter.class.getSimpleName();
    private boolean mHasCrashed = false;
    private final boolean mLogNetworkRequests;

    public CrashlyticsCrashReporter(@NonNull Context context, @NonNull Config config) {
        if (config.debugging) {
            Log.d((String)TAG, (String)"Initializing crashlytics crash reporter");
        }
        CrashlyticsListener listener = new CrashlyticsListener(){

            public void crashlyticsDidDetectCrashDuringPreviousExecution() {
                CrashlyticsCrashReporter.this.mHasCrashed = true;
            }
        };
        if (config.debugging) {
            Log.d((String)TAG, (String)"Creating core with crash session listener");
        }
        CrashlyticsCore core = new CrashlyticsCore.Builder().listener(listener).build();
        if (config.debugging) {
            Log.d((String)TAG, (String)"Creating builder");
        }
        Crashlytics.Builder builder = new Crashlytics.Builder();
        if (config.debugging) {
            Log.d((String)TAG, (String)"Setting core");
        }
        builder.core(core);
        if (config.debugging) {
            Log.d((String)TAG, (String)("Checking if we need answers: " + config.enableAnswers));
        }
        if (config.enableAnswers) {
            builder.answers(new Answers());
        }
        this.mLogNetworkRequests = config.logNetworkCalls;
        if (config.debugging) {
            Log.d((String)TAG, (String)"Init fabric");
        }
        Fabric.with((Fabric)new Fabric.Builder(context).debuggable(config.debugging).kits(new Kit[]{builder.build()}).build());
    }

    public void setUserIdentifier(@Nullable String userIdentifier) {
        Crashlytics.setUserIdentifier((String)userIdentifier);
    }

    public void leaveBreadcrumb(@Nullable String breadCrumb) {
        if (breadCrumb == null) {
            return;
        }
        Crashlytics.log((String)breadCrumb);
    }

    public void logEvent(@Nullable String event) {
        if (event == null) {
            return;
        }
        Answers answers = Answers.getInstance();
        if (answers == null) {
            return;
        }
        answers.logCustom(new CustomEvent(event));
    }

    public void logHandledException(@Nullable Throwable handledError) {
        if (handledError == null) {
            return;
        }
        Crashlytics.logException((Throwable)handledError);
    }

    public void logData(String key, @Nullable Object value) {
        Crashlytics.log((int)3, (String)key, (String)String.valueOf(value));
    }

    public boolean didCrashLastSession() {
        return this.mHasCrashed;
    }

    public void logNetworkRequest(@Nullable String method, @Nullable String url, int responseCode) {
        if (this.mLogNetworkRequests) {
            Answers answers = Answers.getInstance();
            if (answers == null) {
                return;
            }
            CustomEvent event = new CustomEvent("network");
            event.putCustomAttribute("method", method == null ? "Unknown" : method);
            event.putCustomAttribute("url", url == null ? "Unknown" : url);
            event.putCustomAttribute("response", (Number)responseCode);
            answers.logCustom(event);
        }
    }

    public static class Config {
        public boolean logNetworkCalls = false;
        public boolean enableAnswers = true;
        public boolean debugging = false;
    }
}

