/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.collective.utils.PasswordMaskUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class ReplicateTask
extends BaseCommandTask {
    private static final String className = ReplicateTask.class.getName();
    private final SSHKeyGenerator sshKeyGen;
    private final SSHKeyUtility sshKeyUtil;
    private File collectiveResourcesDir;
    private final ICollectiveRegistrationMBeanConnection registrationMBean;
    private static final Integer DEFAULT_REPLICA_PORT = 10010;
    private boolean usingDefaults;

    public ReplicateTask(String scriptName, IFileUtility fileUtility, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(scriptName, fileUtility);
        this.sshKeyGen = sshKeyGen;
        this.sshKeyUtil = sshKeyUtil;
        this.registrationMBean = registrationMBean;
        this.usingDefaults = false;
        this.reqArgs.add("--keystorePassword");
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.confirmedArgs.add("--keystorePassword");
        this.confirmedArgs.add("--serverIdentityKeystorePassword");
        this.confirmedArgs.add("--collectiveTrustKeystorePassword");
        this.confirmedArgs.add("--httpsKeystorePassword");
        this.confirmedArgs.add("--httpsTruststorePassword");
        this.flagArgs.add("--createConfigFile");
        this.flagArgs.add("--useHostCredentials");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--serverIdentityCertificateValidity");
        this.knownArgs.add("--httpsCertificateSubject");
        this.knownArgs.add("--httpsCertificateValidity");
        this.knownArgs.add("--hostName");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
        this.addHostAuthInfoArgs(false);
        this.addAutoAcceptArgument();
        this.noValueRequiredArgs.add("--setupSAF");
        this.knownArgs.addAll(this.noValueRequiredArgs);
        this.knownArgs.add("--certificateRdn");
        this.knownArgs.add("--serverIdentityKeystore");
        this.knownArgs.add("--serverIdentityKeystoreAlias");
        this.knownArgs.add("--collectiveTrustKeystore");
        this.knownArgs.add("--safKeystoreType");
        this.knownArgs.add("--safKeystoreProvider");
    }

    @Override
    public String getTaskName() {
        return "replicate";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("replicate.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("keystore.option-key.", "keystore.option-desc.") + this.buildScriptOptions("certProps.option-key.", "certProps.option-desc.") + this.buildScriptOptions("replicate.option-key.", "replicate.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("hostAuthInfo.option-key.", "hostAuthInfo.option-desc.");
        return this.getTaskHelp("replicate.desc", "replicate.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("replicate.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("replicate.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("replicate.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        this.stdout.println(this.getMessage("replicate.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            this.stdout.println(this.getMessage("replicate.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir, File collectiveSecurityDir, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("replicate.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            this.stdout.println(this.getMessage("replicate.cleanupFail", collectiveResourcesDir));
        }
        if (!this.fileUtility.recurisveDelete(collectiveSecurityDir)) {
            this.stdout.println(this.getMessage("replicate.cleanupFail", collectiveSecurityDir));
        }
        throw new TaskErrorException(message);
    }

    private Map<String, byte[]> replicate(String controllerHost, int controllerPort, String user, String password, String hostName, String userDir, String serverName, String installDir, String keystorePassword, Map<String, Object> certProps, Map<String, Object> hostAuthInfo) throws TaskErrorException {
        String methodName = "replicate";
        Trlog.enter(className, methodName, new Object[]{controllerHost, controllerPort, user, password.replaceAll(".", "*"), hostName, userDir, serverName, installDir});
        try {
            Map<String, byte[]> ret = this.registrationMBean.replicate(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
            this.stdout.println(this.getMessage("replicate.mbeanComplete", new Object[0]));
            Trlog.exit(className, methodName, "Successfully completed MBean request to the controller.");
            return ret;
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", e);
            if (e.getCause() instanceof IllegalStateException) {
                this.abortAndPerformCleanup(this.getMessage("replicate.registeredAlready", serverName), this.collectiveResourcesDir, null, methodName);
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, null, methodName);
            } else {
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, null, methodName);
            }
        }
        catch (UnknownHostException e) {
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir, null, methodName);
        }
        catch (ConnectException e) {
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir, null, methodName);
        }
        catch (IOException e) {
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, null, methodName);
        }
        catch (Exception e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), this.collectiveResourcesDir, null, methodName);
        }
        Trlog.exit(className, methodName, "return null");
        return null;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        boolean upLevelMember = true;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, false);
        String predType = "FILE";
        predType = this.customArgsFound(args);
        String configXML = "";
        boolean safKeysValid = false;
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String installDir = this.fileUtility.getInstallDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        if (!this.fileUtility.exists(serverDir)) {
            userDir = this.fileUtility.resolvePath(userDir);
            this.abort(this.getMessage("serverNotFound", serverName, userDir), methodName);
        }
        this.collectiveResourcesDir = new File(serverDir + "resources/collective");
        if (this.fileUtility.exists(this.collectiveResourcesDir) && !this.fileUtility.isDirectoryEmpty(this.collectiveResourcesDir)) {
            this.abort(this.getMessage("replicate.errorAlreadyHasResources", new Object[0]), methodName);
        }
        this.handleAutoAcceptArgument(args);
        boolean checkInDefaultsDir = true;
        if (this.isConfigFileInDropins(args, checkInDefaultsDir)) {
            this.abort(this.getMessage("create.configLocationInDefaults", new Object[0]), methodName);
        }
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        String defaultHTTPSCertificateSubject = "CN=" + hostName + ",OU=" + serverName + ",O=ibm,C=us";
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String serverIdentityKeystorePassword = this.getArgumentValue("--serverIdentityKeystorePassword", args, keystorePassword);
        Integer serverIdentityCertificateValidity = Integer.valueOf(this.getArgumentValue("--serverIdentityCertificateValidity", args, String.valueOf(1825)));
        String collectiveTrustKSPassword = this.getArgumentValue("--collectiveTrustKeystorePassword", args, keystorePassword);
        String httpsKSPassword = this.getArgumentValue("--httpsKeystorePassword", args, keystorePassword);
        String httpsCertificateSubject = this.getArgumentValue("--httpsCertificateSubject", args, defaultHTTPSCertificateSubject);
        Integer httpsCertificateValidity = Integer.valueOf(this.getArgumentValue("--httpsCertificateValidity", args, String.valueOf(1825)));
        String httpsTSPassword = this.getArgumentValue("--httpsTruststorePassword", args, keystorePassword);
        if (serverIdentityCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--serverIdentityCertificateValidity"), methodName);
        }
        if (httpsCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--httpsCertificateValidity"), methodName);
        }
        try {
            new LdapName(httpsCertificateSubject);
        }
        catch (InvalidNameException e) {
            this.abort(this.getMessage("common.invalidDN", "--httpsCertificateSubject", httpsCertificateSubject), methodName);
        }
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String key = this.getArgumentValue("--key", args, null);
        this.validateEncoding(encoding, key);
        HashMap<String, Object> hostAuthInfo = null;
        List<String> list = Arrays.asList(args);
        Boolean useHostCredentials = list.contains("--useHostCredentials");
        Boolean useCollectiveSSHKey = list.contains("--useCollectiveSSHKey");
        this.validateUseHostCredentialsOverrides(list, useHostCredentials);
        this.validateUseSSHKeyOverrides(list, useCollectiveSSHKey);
        if (useHostCredentials.booleanValue()) {
            hostAuthInfo = new HashMap<String, Boolean>();
            hostAuthInfo.put("useHostCredentials", Boolean.TRUE);
            hostAuthInfo.put("collectiveSSHKeySupported", Boolean.TRUE);
        } else {
            hostAuthInfo = this.buildHostAuthInfo(args, this.sshKeyGen, this.sshKeyUtil, this.registrationMBean, this.collectiveResourcesDir, controllerHost, controllerPort, user, password, hostName, true, true, serverName, serverDir);
        }
        Map hostAuthInfoWithMaskPassword = PasswordMaskUtil.maskPasswordsInMap(hostAuthInfo);
        Trlog.debug(className, methodName, "Resulting hostAuthInfo:\n" + hostAuthInfoWithMaskPassword);
        boolean contollerUsingCustom = this.isContollerUsingCustomKeystore(controllerHost, controllerPort, user, password, this.registrationMBean, this.collectiveResourcesDir);
        Map<String, byte[]> joinResult = null;
        File collectiveUUIDFile = new File(serverDir + "resources/collective/collective.uuid");
        File collectiveNameFile = new File(serverDir + "resources/collective/collective.name");
        if (!this.fileUtility.createParentDirectory(stdout, collectiveUUIDFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
        }
        if (!this.fileUtility.createParentDirectory(stdout, collectiveNameFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
        }
        if (predType.equals("SAF") || predType.equals("CUSTOMFILE")) {
            if (!contollerUsingCustom) {
                this.abortAndPerformCleanup(this.getMessage("custom.MemberCustomControllerDefault", new Object[0]), this.collectiveResourcesDir, null, methodName);
            }
            configXML = this.processBYO_SSLOptions(args, serverName, controllerHost, controllerPort, user, password, hostName, userDir, installDir, serverDir, hostAuthInfo, encoding, key, predType, keystorePassword, serverIdentityKeystorePassword, collectiveTrustKSPassword, contollerUsingCustom);
        } else {
            byte[] collectiveName;
            String encodedKeystorePassword;
            if (contollerUsingCustom) {
                this.abortAndPerformCleanup(this.getMessage("custom.ControllerCustomMemberDefault", new Object[0]), this.collectiveResourcesDir, null, methodName);
            }
            if ((encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", encoding, key)) == null) {
                this.abort("encodedKeystorePassword is null", methodName);
            }
            String encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", encoding, key);
            String encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--collectiveTrustKeystorePassword", encoding, key);
            String encodedHTTPSKSPassword = this.encodePassword(httpsKSPassword, "--httpsKeystorePassword", encoding, key);
            String encodedHTTPSTSPassword = this.encodePassword(httpsTSPassword, "--httpsTruststorePassword", encoding, key);
            if (encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null || encodedHTTPSKSPassword == null || encodedHTTPSTSPassword == null) {
                this.abort(null, methodName);
            }
            HashMap<String, Object> certProps = new HashMap<String, Object>();
            certProps.put("serverIdentityKeystorePassword", encodedServerIdentityKeystorePassword);
            certProps.put("serverIdentityCertificateValidity", serverIdentityCertificateValidity);
            certProps.put("collectiveTrustKeystorePassword", encodedCollectiveTrustKSPassword);
            certProps.put("httpsKeystorePassword", encodedHTTPSKSPassword);
            certProps.put("httpsCertificateSubject", httpsCertificateSubject);
            certProps.put("httpsCertificateValidity", httpsCertificateValidity);
            certProps.put("httpsTruststorePassword", encodedHTTPSTSPassword);
            certProps.put("18004member", "true");
            File serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.p12");
            File collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.p12");
            File rootKeysKeyFile = new File(serverDir + "resources/collective/rootKeys.p12");
            File httpsKSFile = new File(serverDir + "resources/security/key.p12");
            File tmpHttpsKSFile = new File(serverDir + "resources/security/key.p12" + ".tmp");
            if (httpsKSFile.exists()) {
                Trlog.debug(className, methodName, "Regenerates the certificate as the default HTTPS keystore file exists at " + httpsKSFile.getAbsolutePath());
                stdout.println(this.getMessage("common.regenerateKey", httpsKSFile.getAbsolutePath()));
            }
            File httpsTSFile = new File(serverDir + "resources/security/trust.p12");
            File tmpHttpsTSFile = new File(serverDir + "resources/security/trust.p12" + ".tmp");
            if (httpsTSFile.exists()) {
                Trlog.debug(className, methodName, "Regenerates the certificate as the default HTTPS truststore file exists at " + httpsTSFile.getAbsolutePath());
                stdout.println(this.getMessage("common.regenerateTrust", httpsTSFile.getAbsolutePath()));
            }
            if (!this.fileUtility.createParentDirectory(stdout, serverIdentityKeyFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, collectiveTrustKeyFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, rootKeysKeyFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, httpsKSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsKSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, httpsTSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsTSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, null, methodName);
            }
            stdout.println(this.getMessage("replicate.start", controllerHost, String.valueOf(controllerPort)));
            joinResult = this.replicate(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
            if (joinResult.get("18004controller") != null) {
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("serverIdentity.p12"), serverIdentityKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", serverIdentityKeyFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collectiveTrust.p12"), collectiveTrustKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", collectiveTrustKeyFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("rootKeys.p12"), rootKeysKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", rootKeysKeyFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collective.uuid"), collectiveUUIDFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeFileFail", collectiveUUIDFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
            } else {
                serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.jks");
                collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.jks");
                rootKeysKeyFile = new File(serverDir + "resources/collective/rootKeys.jks");
                httpsKSFile = new File(serverDir + "resources/security/key.jks");
                tmpHttpsKSFile = new File(serverDir + "resources/security/key.jks" + ".tmp");
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("serverIdentity.jks"), serverIdentityKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", serverIdentityKeyFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collectiveTrust.jks"), collectiveTrustKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", collectiveTrustKeyFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("rootKeys.jks"), rootKeysKeyFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", rootKeysKeyFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collective.uuid"), collectiveUUIDFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeFileFail", collectiveUUIDFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
            }
            if ((collectiveName = joinResult.get("collective.name")) == null) {
                Trlog.debug(className, methodName, "it looks that we try to replica controller with version 8.5.5.3 or below");
                try {
                    collectiveName = "defaultCollective".getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Trlog.debug(className, methodName, "Caught UnsupportedEncodingException while calling \"defaultCollective\".getBytes(\"UTF-8\")");
                }
            }
            if (joinResult.get("18004controller") != null) {
                if (collectiveName == null || !this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.p12"), tmpHttpsKSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.p12"), tmpHttpsKSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("trust.p12"), tmpHttpsTSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsTSFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
            } else {
                upLevelMember = false;
                if (collectiveName == null || !this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.jks"), tmpHttpsKSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.jks"), tmpHttpsKSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
                if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("trust.jks"), tmpHttpsTSFile)) {
                    this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsTSFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
                }
            }
            this.updateExistingSSLKeys(httpsKSFile, tmpHttpsKSFile, httpsTSFile, tmpHttpsTSFile, this.collectiveResourcesDir);
            if (joinResult.get("safKeyring") != null) {
                String safRecoveryPW = null;
                String safKeyRing = new String(joinResult.get("safKeyring"));
                String safLabel = new String(joinResult.get("safCertificateLabel"));
                String safKeystoreType = new String(joinResult.get("safKeystoreType"));
                byte[] safKeystoreProviderBytes = joinResult.get("safKeystoreProvider");
                String safKeystoreProvider = safKeystoreProviderBytes == null ? null : new String(safKeystoreProviderBytes);
                safKeysValid = this.verifySAFSSHKeys(safKeyRing, safLabel, safKeystoreType, safKeystoreProvider, safRecoveryPW, false, this.collectiveResourcesDir);
            }
            this.copySSHKeys(joinResult, serverDir);
            configXML = this.getConfigXML(args, joinResult, controllerHost, hostName, encoding, key, encodedServerIdentityKeystorePassword, encodedCollectiveTrustKSPassword, encodedHTTPSKSPassword, encodedHTTPSTSPassword, encodedKeystorePassword, serverDir, safKeysValid, upLevelMember);
        }
        Trlog.debug(className, methodName, "Successfully replicated the controller as server " + serverName);
        stdout.println();
        stdout.println(this.getMessage("replicate.success", serverName));
        this.handleConfigXML(stdout, args, serverDir, configXML);
        stdout.println(this.getMessage("replicate.configureSecurity", new Object[0]));
        Trlog.exit(className, methodName);
    }

    private void copySSHKeys(Map<String, byte[]> joinResult, String serverDir) throws TaskErrorException {
        String methodName = "copySSHKeys";
        Trlog.enter(className, methodName);
        String publicKey = null;
        File privateKeyFile = new File(serverDir + "resources/security/ssh/id_rsa");
        File publicKeyFile = new File(serverDir + "resources/security/ssh/id_rsa.pub");
        File collectiveSecurityDir = new File(serverDir + "resources/security");
        byte[] parm = joinResult.get("sshPublicKey");
        if (parm != null) {
            publicKey = new String(parm);
        }
        if (joinResult.get("sshPrivateKey") != null && publicKey != null) {
            this.stdout.println("About to copy SSH Keys to new server");
            this.usingDefaults = true;
            try {
                this.sshKeyUtil.writeKeyToFile(new String(joinResult.get("sshPrivateKey")), privateKeyFile);
                this.sshKeyUtil.writeKeyToFile(publicKey, publicKeyFile);
            }
            catch (IOException ioe) {
                this.stdout.println(this.getMessage("replicate.writeSSHKeyFail", new Object[0]));
                this.abortAndPerformCleanup(this.getMessage("replicate.writeSSHKeyFail", ioe.toString()), collectiveSecurityDir, this.collectiveResourcesDir, methodName);
            }
        } else if (joinResult.get("safKeyring") != null) {
            this.stdout.println(this.getMessage("replicate.usingSAFKeys", new Object[0]));
        } else {
            Trlog.debug(className, methodName, "Default Keys are not being used so keys will not be copied");
        }
        if (publicKey != null) {
            String homeDir = System.getProperty("user.home");
            try {
                this.sshKeyUtil.updateAuthorizedKeys(homeDir, publicKey);
            }
            catch (IOException ioe) {
                this.abortAndPerformCleanup(this.getMessage("replicate.saveAuthorizedKeys", ioe.toString()), collectiveSecurityDir, this.collectiveResourcesDir, methodName);
            }
        }
        Trlog.exit(className, methodName);
    }

    protected String insertCollectiveHostAuthInfo(Map<String, byte[]> joinResult, boolean safKeysValid, String serverDir) {
        StringBuffer chaiXml = new StringBuffer();
        String privateKeyPath = null;
        String publicKeyPath = null;
        String defaultPrivateKeyPath = null;
        String defaultPublicKeyPath = null;
        String safKeyRing = null;
        String safLabel = null;
        String safRecoveryPW = null;
        String privateKeyPassword = null;
        String safKeystoreType = null;
        String safKeystoreProvider = null;
        byte[] parm = joinResult.get("sshPrivateKeyPath");
        if (parm != null) {
            privateKeyPath = new String(parm);
        }
        if ((parm = joinResult.get("sshPublicKeyPath")) != null) {
            publicKeyPath = new String(parm);
        }
        if ((parm = joinResult.get("defaultSSHPrivateKeyPath")) != null) {
            defaultPrivateKeyPath = new String(parm);
        }
        if ((parm = joinResult.get("defaultSSHPublicKeyPath")) != null) {
            defaultPublicKeyPath = new String(parm);
        }
        if ((parm = joinResult.get("safKeyring")) != null) {
            safKeyRing = new String(parm);
        }
        if ((parm = joinResult.get("safCertificateLabel")) != null) {
            safLabel = new String(parm);
        }
        if ((parm = joinResult.get("safKeystoreType")) != null) {
            safKeystoreType = new String(parm);
        }
        if ((parm = joinResult.get("safKeystoreProvider")) != null) {
            safKeystoreProvider = new String(parm);
        }
        if ((parm = joinResult.get("sshPrivateKeyPassword")) != null) {
            privateKeyPassword = new String(parm);
        }
        chaiXml.append("    <!-- BYO collective-wide SSH Key information. -->").append(NL);
        chaiXml.append("    <collectiveHostAuthInfo");
        chaiXml.append(NL);
        if (safLabel != null && safLabel.length() > 0) {
            chaiXml.append("       safCertificateLabel=\"");
            chaiXml.append(safLabel);
            chaiXml.append("\"");
            chaiXml.append(NL);
            chaiXml.append("       safKeyRing=\"");
            chaiXml.append(safKeyRing);
            chaiXml.append("\"");
            chaiXml.append(NL);
            if (safRecoveryPW != null && safRecoveryPW.length() > 0) {
                chaiXml.append("       safKeystoreKeyRecoverPassword=\"");
                chaiXml.append(safRecoveryPW);
                chaiXml.append("\"");
                chaiXml.append(NL);
            }
            if (safKeystoreType != null) {
                chaiXml.append("       safKeystoreType=\"");
                chaiXml.append(safKeystoreType);
                chaiXml.append("\"");
                chaiXml.append(NL);
            }
            if (safKeystoreProvider != null) {
                chaiXml.append("       safKeystoreProvider=\"");
                chaiXml.append(safKeystoreProvider);
                chaiXml.append("\"");
                chaiXml.append(NL);
            }
            chaiXml.append("     />");
            chaiXml.append(NL);
        } else if (publicKeyPath != null && publicKeyPath.length() > 0) {
            if (publicKeyPath.equals(defaultPublicKeyPath)) {
                publicKeyPath = serverDir + "resources/security/ssh/id_rsa.pub";
                privateKeyPath = serverDir + "resources/security/ssh/id_rsa";
            }
            chaiXml.append("       sshPrivateKeyPath=\"");
            chaiXml.append(privateKeyPath);
            chaiXml.append("\"");
            chaiXml.append(NL);
            chaiXml.append("       sshPublicKeyPath=\"");
            chaiXml.append(publicKeyPath);
            chaiXml.append("\"");
            chaiXml.append(NL);
            if (privateKeyPassword != null && privateKeyPassword.length() > 0) {
                chaiXml.append("       sshPrivateKeyPassWord=\"");
                chaiXml.append("\"");
                chaiXml.append(NL);
            }
            chaiXml.append("     />");
            chaiXml.append(NL);
        } else {
            chaiXml = new StringBuffer();
        }
        return chaiXml.toString();
    }

    private String getConfigXML(String[] args, Map<String, byte[]> joinResult, String controllerHost, String hostName, String encoding, String key, String encodedServerIdentityKeystorePassword, String encodedCollectiveTrustKSPassword, String encodedHTTPSKSPassword, String encodedHTTPSTSPassword, String encodedKeystorePassword, String serverDir, boolean safKeysValid, boolean upLevelMember) {
        Integer defaultReplicaPort = DEFAULT_REPLICA_PORT;
        Integer replicaPort = Integer.getInteger("controller_1.replica", defaultReplicaPort);
        String xmlSnippet = null;
        xmlSnippet = upLevelMember ? "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Configuration of the collective controller replica." + NL + "         TODO: If this replica is on the same host as the original controller," + NL + "               change the replicaPort." + NL + "         TODO: If the target controller's replica port is not " + replicaPort + NL + "               (the default) change the value in replicaSet. -->" + NL + "    <collectiveController replicaPort=\"" + replicaPort + "\"" + NL + "                          replicaSet=\"" + controllerHost + ":" + replicaPort + "\"" + NL + "                          isInitialReplicaSet=\"false\" />" + NL + NL + (this.usingDefaults ? "" : this.insertCollectiveHostAuthInfo(joinResult, safKeysValid, serverDir)) + NL + "    <!-- TODO: Define the security configuration exactly as defined in the" + NL + "               target controller from which this was replicated. -->" + NL + "    <quickStartSecurity userName=\"\" userPassword=\"\" />" + NL + NL + this.insertEncodingKey(encoding, key) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.p12" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.p12" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.p12" + "\" />" + NL + NL + "    <!-- collective truststore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.p12" + "\" />" + NL + NL + "    <!-- collective root signers keystore" + NL + "         TODO: set password to the collectiveRootKeys password in the" + NL + "         original controller -->" + NL + "    <keyStore id=\"collectiveRootKeys\" password=\"" + encodedKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/rootKeys.p12" + "\" />" + NL : "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Configuration of the collective controller replica." + NL + "         TODO: If this replica is on the same host as the original controller," + NL + "               change the replicaPort." + NL + "         TODO: If the target controller's replica port is not " + replicaPort + NL + "               (the default) change the value in replicaSet. -->" + NL + "    <collectiveController replicaPort=\"" + replicaPort + "\"" + NL + "                          replicaSet=\"" + controllerHost + ":" + replicaPort + "\"" + NL + "                          isInitialReplicaSet=\"false\" />" + NL + NL + (this.usingDefaults ? "" : this.insertCollectiveHostAuthInfo(joinResult, safKeysValid, serverDir)) + NL + "    <!-- TODO: Define the security configuration exactly as defined in the" + NL + "               target controller from which this was replicated. -->" + NL + "    <quickStartSecurity userName=\"\" userPassword=\"\" />" + NL + NL + this.insertEncodingKey(encoding, key) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.jks" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.jks" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.jks" + "\" />" + NL + NL + "    <!-- collective truststore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.jks" + "\" />" + NL + NL + "    <!-- collective root signers keystore" + NL + "         TODO: set password to the collectiveRootKeys password in the" + NL + "         original controller -->" + NL + "    <keyStore id=\"collectiveRootKeys\" password=\"" + encodedKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/rootKeys.jks" + "\" />" + NL;
        return xmlSnippet;
    }

    private String getCustomConfigXML(String[] args, Map<String, byte[]> joinResult, String controllerHost, String hostName, String encoding, String key, String safCertificateRdn, String encodedServerIdentityKeystorePassword, String encodedCollectiveTrustKSPassword, String serverDir, boolean safKeysValid, String serverIdentityKS, String serverIdentityAlias, String collectiveTrustKS) {
        Integer defaultReplicaPort = DEFAULT_REPLICA_PORT;
        Integer replicaPort = Integer.getInteger("controller_1.replica", defaultReplicaPort);
        String xmlSnippet = "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Configuration of the collective controller replica." + NL + "         TODO: If this replica is on the same host as the original controller," + NL + "               change the replicaPort." + NL + "         TODO: If the target controller's replica port is not " + replicaPort + NL + "               (the default) change the value in replicaSet. -->" + NL + "    <collectiveController replicaPort=\"" + replicaPort + "\"" + NL + "                          replicaSet=\"" + controllerHost + ":" + replicaPort + "\"" + NL + "                          isInitialReplicaSet=\"false\" />" + NL + NL + (this.usingDefaults ? "" : this.insertCollectiveHostAuthInfo(joinResult, safKeysValid, serverDir)) + NL + "    <!-- TODO: Define the security configuration exactly as defined in the" + NL + "               target controller from which this was replicated. -->" + NL + "    <quickStartSecurity userName=\"\" userPassword=\"\" />" + NL + NL + this.insertEncodingKey(encoding, key) + NL + NL + this.insertCustomSSLConfigs(args, safCertificateRdn, serverIdentityKS, serverIdentityAlias, encodedServerIdentityKeystorePassword, collectiveTrustKS, encodedCollectiveTrustKSPassword);
        return xmlSnippet;
    }

    protected String processBYO_SSLOptions(String[] args, String serverName, String controllerHost, int controllerPort, String user, String password, String hostName, String userDir, String installDir, String serverDir, Map<String, Object> hostAuthInfo, String encoding, String key, String predType, String keystorePassword, String serverIdentityKeystorePassword, String collectiveTrustKSPassword, boolean contollerUsingCustom) throws TaskErrorException {
        String safCertificateRdn;
        String methodName = "processBYO_SSLOptions";
        List<String> list = Arrays.asList(args);
        Boolean setupSAF = list.contains("--setupSAF");
        String serverIdentitycustomKS = this.getArgumentValue("--serverIdentityKeystore", args, null);
        String serverIdentityAlias = this.getArgumentValue("--serverIdentityKeystoreAlias", args, null);
        String collectiveTrustcustomKS = this.getArgumentValue("--collectiveTrustKeystore", args, null);
        String safDefaultRDN = null;
        if (setupSAF.booleanValue()) {
            String SSLKeystoreName;
            String prefix = "LZController";
            serverIdentitycustomKS = SSLKeystoreName = "safkeyring:///" + prefix + ".Ring";
            collectiveTrustcustomKS = SSLKeystoreName;
            serverIdentityAlias = prefix + ".CERT";
            safDefaultRDN = "OU=LZCollective";
        }
        if ((safCertificateRdn = this.getArgumentValue("--certificateRdn", args, safDefaultRDN)) != null) {
            try {
                new Rdn(safCertificateRdn);
            }
            catch (InvalidNameException e) {
                Trlog.debug(className, methodName, "Caught InvalidNameException while getting Rdn", e);
                this.abortAndPerformCleanup(this.getMessage("common.invalidDN", "--certificateRdn", safCertificateRdn), this.collectiveResourcesDir, null, methodName);
            }
        }
        HashMap<String, Object> certProps = new HashMap<String, Object>();
        String encodedServerIdentityKeystorePassword = null;
        String encodedCollectiveTrustKSPassword = null;
        if (predType.equals("CUSTOMFILE")) {
            encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", encoding, key);
            encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--serverIdentityKeystorePassword", encoding, key);
            if (encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null) {
                this.abort(null, methodName);
            }
            this.verifyFileSSL(serverIdentitycustomKS, collectiveTrustcustomKS, serverIdentityAlias, serverIdentityKeystorePassword, collectiveTrustKSPassword, true, this.collectiveResourcesDir);
        } else {
            String safKeystoreType = this.getArgumentValue("--safKeystoreType", args, "JCERACFKS");
            String safKeystoreProvider = this.getArgumentValue("--safKeystoreProvider", args, null);
            this.verifySAFSSL(Arrays.asList(serverIdentitycustomKS, collectiveTrustcustomKS), serverIdentityAlias, safKeystoreType, safKeystoreProvider, true, this.collectiveResourcesDir);
        }
        certProps.put("CustomKeystores", "true");
        this.stdout.println(this.getMessage("replicate.start", controllerHost, String.valueOf(controllerPort)));
        Map<String, byte[]> joinResult = this.replicate(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
        File collectiveUUIDFile = new File(serverDir + "resources/collective/collective.uuid");
        if (!this.fileUtility.writeBytesToFile(this.stderr, joinResult.get("collective.uuid"), collectiveUUIDFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeFileFail", collectiveUUIDFile.getAbsolutePath()), this.collectiveResourcesDir, null, methodName);
        }
        boolean safKeysValid = false;
        if (joinResult.get("safKeyring") != null) {
            String safRecoveryPW = null;
            String safKeyRing = new String(joinResult.get("safKeyring"));
            String safLabel = new String(joinResult.get("safCertificateLabel"));
            String safKeystoreType = new String(joinResult.get("safKeystoreType"));
            byte[] safKeystoreProviderBytes = joinResult.get("safKeystoreProvider");
            String safKeystoreProvider = safKeystoreProviderBytes == null ? null : new String(safKeystoreProviderBytes);
            safKeysValid = this.verifySAFSSHKeys(safKeyRing, safLabel, safKeystoreType, safKeystoreProvider, safRecoveryPW, false, this.collectiveResourcesDir);
        }
        this.copySSHKeys(joinResult, serverDir);
        return this.getCustomConfigXML(args, joinResult, controllerHost, hostName, encoding, key, safCertificateRdn, encodedServerIdentityKeystorePassword, encodedCollectiveTrustKSPassword, serverDir, safKeysValid, serverIdentitycustomKS, serverIdentityAlias, collectiveTrustcustomKS);
    }
}

