/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.utility.IAdminMetadataManagerMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRepositoryMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import javax.management.RuntimeMBeanException;

public class RemoveTask
extends BaseCommandTask {
    private static final String className = RemoveTask.class.getName();
    private final ICollectiveRegistrationMBeanConnection registrationMBean;
    private final IAdminMetadataManagerMBeanConnection metadataManagerMBean;
    private final ICollectiveRepositoryMBeanConnection repositoryMBean;

    public RemoveTask(String scriptName, IFileUtility fileUtility, ICollectiveRegistrationMBeanConnection registrationMBean, IAdminMetadataManagerMBeanConnection metadataManagerMBean, ICollectiveRepositoryMBeanConnection repositoryMBean) {
        super(scriptName, fileUtility);
        this.registrationMBean = registrationMBean;
        this.metadataManagerMBean = metadataManagerMBean;
        this.repositoryMBean = repositoryMBean;
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add("--removeDeployVariables");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--hostName");
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "remove";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("remove.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept");
        return this.getTaskHelp("remove.desc", "remove.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("remove.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) {
        this.stderr.println(message);
    }

    private void abortAndThrowTaskErrorException(String message, String serverName, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("remove.unregisterFailed", serverName));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
    }

    private boolean removeServer(String host, int port, String user, String password, String serverName, String hostName, String userDir) throws TaskErrorException {
        String methodName = "remvoeServer";
        Trlog.enter(className, methodName, new Object[]{user, port, user, password.replaceAll(".", "*"), hostName, userDir});
        try {
            this.registrationMBean.remove(host, port, user, password, serverName, hostName, userDir);
            Trlog.exit(className, methodName, "Server " + serverName + " successfully unregistered");
            this.stdout.println(this.getMessage("remove.unregisterSuccess", serverName));
            return true;
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof IllegalStateException) {
                Trlog.exit(className, methodName, "Server " + serverName + " is not registered and it might be registered under another host name.");
                this.stdout.println(this.getMessage("remove.unregisteredAlready", serverName));
                return true;
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndThrowTaskErrorException(this.getMessage("common.connectionError", host, port, user, e.getMessage()), serverName, methodName);
        }
        catch (UnknownHostException e) {
            this.abortAndThrowTaskErrorException(this.getMessage("common.hostError", host), serverName, methodName);
        }
        catch (ConnectException e) {
            this.abortAndThrowTaskErrorException(this.getMessage("common.portError", String.valueOf(port)), serverName, methodName);
        }
        catch (IOException e) {
            this.abortAndThrowTaskErrorException(this.getMessage("common.connectionError", host, port, user, e.getMessage()), serverName, methodName);
        }
        catch (Exception e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndThrowTaskErrorException(this.getMessage("common.connectionError", host, port, user, e.getMessage()), serverName, methodName);
        }
        Trlog.exit(className, methodName, "return false");
        return false;
    }

    private boolean removeAllAdminMetadata(String host, int port, String user, String password, String resourceType, String identity) throws TaskErrorException {
        String methodName = "removeAllAdminMedatada";
        Trlog.enter(className, methodName, new Object[]{host, port, user, password.replaceAll(".", "*"), resourceType, identity});
        try {
            this.metadataManagerMBean.removeAllAdminMetadata(host, port, user, password, resourceType, identity);
            Trlog.exit(className, methodName, "Successfully completed AdminMetadataManagerMBean.removeAllAdminMetadata() request to the controller");
            this.stdout.println(this.getMessage("removeAllAdminMetadata.mbeanComplete", new Object[0]));
            return true;
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Unexpected RuntimeMBeanException while invoking the MBean: ", e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (UnknownHostException e) {
            Trlog.debug(className, methodName, "UnknownHostException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            Trlog.debug(className, methodName, "ConnectException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            Trlog.debug(className, methodName, "IOException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (Exception e) {
            Trlog.debug(className, methodName, "Unexpected Exception while invoking the MBean: ", e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        Trlog.exit(className, methodName, "return false");
        return false;
    }

    private boolean getAdminMetadata(String host, int port, String user, String password, String resourceType, String identity) throws TaskErrorException {
        String methodName = "getAdminMetadata";
        Trlog.enter(className, methodName, new Object[]{host, port, user, password.replaceAll(".", "*"), resourceType, identity});
        boolean metadataExist = false;
        try {
            Map<String, Object> metadata = this.metadataManagerMBean.getAdminMetadata(host, port, user, password, resourceType, identity);
            this.stdout.println(this.getMessage("getAdminMetadata.mbeanComplete", new Object[0]));
            if (metadata.size() > 0) {
                metadataExist = true;
                Trlog.debug(className, methodName, "Admin metadata exists");
            } else {
                Trlog.debug(className, methodName, "No admin metadata found");
            }
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Caught RuntimeMBeanException: ", e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (UnknownHostException e) {
            Trlog.debug(className, methodName, "UnknownHostException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            Trlog.debug(className, methodName, "ConnectException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            Trlog.debug(className, methodName, "IOException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (Exception e) {
            Trlog.debug(className, methodName, "Unexpected Exception while invoking the MBean: ", e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        Trlog.exit(className, methodName, metadataExist);
        return metadataExist;
    }

    private boolean releaseDeployVariables(String host, int port, String user, String password, String hostName, Map<String, Integer> deployVars) throws TaskErrorException {
        String methodName = "releaseDeployVariables";
        Trlog.enter(className, methodName, new Object[]{host, port, user, password.replaceAll(".", "*"), hostName, deployVars});
        try {
            this.repositoryMBean.releaseDeployVariables(host, port, user, password, hostName, deployVars);
            Trlog.exit(className, methodName, "Releasing all deployment variables from the collective repository.");
            this.stdout.println(this.getMessage("releaseDeployVariables.mbeanComplete", new Object[0]));
            return true;
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Caught RuntimeMBeanException: " + e.getMessage());
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (UnknownHostException e) {
            Trlog.debug(className, methodName, "UnknownHostException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            Trlog.debug(className, methodName, "ConnectException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            Trlog.debug(className, methodName, "IOException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchMethodException) {
                Trlog.debug(className, methodName, "NoSuchMethodException while invoking the MBean: ", e);
            } else {
                Trlog.debug(className, methodName, "Unexpected Exception while invoking the MBean: ", e);
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        Trlog.exit(className, methodName, "return false");
        return false;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, false);
        this.handleAutoAcceptArgument(args);
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        Trlog.debug(className, methodName, "Member info: ", new Object[]{"hostName = " + hostName, "userDir = " + userDir, "serverName = " + serverName});
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        String workareaDir = this.fileUtility.getOutputDirectory() + serverName + "/workarea/";
        boolean isDockerEnv = false;
        if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
            hostName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerHost");
            userDir = "Docker";
            serverName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerName");
            isDockerEnv = true;
            Trlog.debug(className, methodName, "Member is in Docker container", new Object[]{"hostName = " + hostName, "userDir = " + userDir, "serverName = " + serverName});
        }
        Trlog.debug(className, methodName, "Attempting to unregister the member from the collective", new Object[]{"hostName = " + hostName, "userDir = " + userDir, "serverName = " + serverName});
        stdout.println(this.getMessage("remove.attemptUnregister", hostName, userDir, serverName));
        if (!this.removeServer(controllerHost, controllerPort, user, password, serverName, hostName, userDir)) {
            Trlog.debug(className, methodName, "Server " + serverName + " could not be unregistered due to an error");
            stdout.println(this.getMessage("remove.unregisterFailed", serverName));
        }
        Trlog.debug(className, methodName, "Attempting to remove resources for the collective from the server...");
        stdout.println();
        stdout.println(this.getMessage("remove.attemptResourceDelete", new Object[0]));
        boolean serverExists = this.fileUtility.exists(serverDir);
        if (!serverExists) {
            userDir = this.fileUtility.resolvePath(userDir);
            Trlog.debug(className, methodName, "Server " + serverName + " at " + userDir + " is not found and no collective resources were removed.");
            stdout.println(this.getMessage("serverNotFound", serverName, userDir));
            stdout.println(this.getMessage("remove.noFilesRemoved", new Object[0]));
        } else {
            String resourcesDir = this.fileUtility.resolvePath(serverDir + "resources/collective");
            if (!this.fileUtility.exists(resourcesDir)) {
                Trlog.debug(className, methodName, "Directory " + resourcesDir + "does not exist.");
                stdout.println(this.getMessage("remove.noResources", new Object[0]));
            } else if (!this.fileUtility.recurisveDelete(resourcesDir)) {
                Trlog.debug(className, methodName, "Some of the files under " + resourcesDir + " could not be removed.");
                stdout.println(this.getMessage("remove.manuallyRemove", resourcesDir));
            } else {
                Trlog.debug(className, methodName, "All resources for collective membership at " + resourcesDir + " were successfully removed");
                stdout.println(this.getMessage("remove.filesSuccess", new Object[0]));
            }
            String collectiveFilePath = workareaDir + ".collective";
            if (this.fileUtility.exists(collectiveFilePath)) {
                Trlog.debug(className, methodName, "File path " + collectiveFilePath + " exists.");
                if (!this.fileUtility.delete(collectiveFilePath)) {
                    Trlog.debug(className, methodName, "The file deletion on " + collectiveFilePath + " returns false.");
                }
            }
        }
        boolean userDirExists = this.fileUtility.exists(userDir);
        if (userDirExists) {
            Trlog.debug(className, methodName, "File path " + userDir + " exists.");
            String serverIdentity = RepositoryPathUtility.buildServerTuple((String)hostName, (String)userDir, (String)serverName);
            serverIdentity = RepositoryPathUtility.encodeServerTuple((String)serverIdentity);
            Trlog.debug(className, methodName, "Start to remove all administrative metadata from the collective repository for server " + serverIdentity);
            stdout.println(this.getMessage("removeAllAdminMetadata.start", new Object[0]));
            if (this.getAdminMetadata(controllerHost, controllerPort, user, password, "server", serverIdentity) && !this.removeAllAdminMetadata(controllerHost, controllerPort, user, password, "server", serverIdentity)) {
                Trlog.debug(className, methodName, "Removal of the admin metadata with resource type server and identity " + serverIdentity + " failed");
                stdout.println(this.getMessage("remove.removeAllAdminMetadataFailed", "server", serverIdentity));
            }
        } else {
            Trlog.debug(className, methodName, "Specified userDir " + userDir + " was not found");
            stdout.println(this.getMessage("userDirNotFound", userDir));
        }
        Boolean removeDeployVariables = Arrays.asList(args).contains("--removeDeployVariables");
        if (removeDeployVariables.booleanValue()) {
            String parentDir = serverDir + "configDropins/overrides";
            String deployVariablesFilePath = parentDir + "/" + "deployVariables.xml";
            boolean deployVariablesFileExists = this.fileUtility.exists(deployVariablesFilePath);
            Trlog.debug(className, methodName, "deployVariablesFilesExists = " + deployVariablesFileExists);
            if (deployVariablesFileExists) {
                Map<String, Integer> deployVars = this.fileUtility.parseDeployVariablesXML(stderr, new File(deployVariablesFilePath));
                if (deployVars != null && deployVars.size() > 0) {
                    stdout.println(this.getMessage("releaseDeployVariables.start", new Object[0]));
                    if (this.releaseDeployVariables(controllerHost, controllerPort, user, password, hostName, deployVars)) {
                        this.fileUtility.delete(deployVariablesFilePath);
                        Trlog.debug(className, methodName, "File " + deployVariablesFilePath + "is deleted");
                    } else {
                        Trlog.debug(className, methodName, "Failed to remove the deployment variables " + deployVars + " on host name " + hostName + " from the collective repository.");
                        stdout.println(this.getMessage("remove.releaseDeployVariablesFailed", deployVars, hostName));
                    }
                } else {
                    this.fileUtility.delete(deployVariablesFilePath);
                    Trlog.debug(className, methodName, "Only delete the file " + deployVariablesFilePath + " as no deploy variables exist");
                }
            }
        }
        if (serverExists && !isDockerEnv) {
            stdout.println(this.getMessage("remove.updateXML", new Object[0]));
            stdout.println(NL + "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "        <feature>collectiveMember-1.0</feature>" + NL + "    </featureManager>" + NL + "    <collectiveMember ... />" + NL + "    <hostAuthInfo ... />" + NL + NL);
        }
        Trlog.exit(className, methodName);
    }
}

