/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.validator.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.core.util.Yaml;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.validator.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.rest.handler.validator.openapi", configurationPolicy=ConfigurationPolicy.IGNORE, service={RESTHandler.class}, property={"com.ibm.wsspi.rest.handler.context.root=/openapi/platform", "com.ibm.wsspi.rest.handler.context.root=/ibm/api/platform", "com.ibm.wsspi.rest.handler.root=/validation"})
public class ValidatorSchemaRESTHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(ValidatorSchemaRESTHandler.class, (String)"rest.validation", null);
    private ComponentContext context;
    static final long serialVersionUID = -3646489998954885601L;

    public final void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        if (!"GET".equals(request.getMethod())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Request method was " + request.getMethod() + " but the validation schema endpoint is restricted to GET requests only."), (Object[])new Object[0]);
            }
            response.setResponseHeader("Accept", "GET");
            response.sendError(405);
            return;
        }
        OpenAPI openAPI = this.getOpenAPIDocument(response);
        if (openAPI != null) {
            String formatParam;
            this.removeDisabledValidators(openAPI);
            String acceptHeader = request.getHeader("Accept");
            String format = "yaml";
            if (acceptHeader != null && acceptHeader.equals("application/json")) {
                format = "json";
            }
            if ((formatParam = request.getParameter("format")) != null && formatParam.equals("json")) {
                format = "json";
            }
            if (format.equals("json")) {
                response.setContentType("application/json");
                response.getWriter().write(Json.pretty((Object)openAPI));
            } else {
                response.setContentType("text/plain");
                response.getWriter().write(Yaml.pretty((Object)openAPI));
            }
        }
    }

    private OpenAPI getOpenAPIDocument(RESTResponse response) {
        OpenAPI openAPI = null;
        InputStream inputStream = ValidatorSchemaRESTHandler.class.getResourceAsStream("/META-INF/openapi.yaml");
        if (inputStream != null) {
            String document = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            openAPI = new OpenAPIV3Parser().readContents(document, null, null, null).getOpenAPI();
            response.setCharacterEncoding("UTF-8");
            if (openAPI == null) {
                if (OpenAPIUtils.isEventEnabled((TraceComponent)tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Error retrieving openapi.yaml for config validation. Returning error code 500.", (Object[])new Object[0]);
                }
                response.setStatus(500);
            }
        } else {
            if (OpenAPIUtils.isEventEnabled((TraceComponent)tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Null inputStream for openapi.yaml. Return 500.", (Object[])new Object[0]);
            }
            response.setStatus(500);
        }
        return openAPI;
    }

    /*
     * WARNING - void declaration
     */
    private void removeDisabledValidators(OpenAPI openAPI) {
        boolean cloudantEnabled = false;
        boolean jcaEnabled = false;
        boolean jmsEnabled = false;
        boolean jdbcEnabled = false;
        try {
            cloudantEnabled = ValidatorSchemaRESTHandler.getServiceReferences(this.context.getBundleContext(), Validator.class, "(component.name=com.ibm.ws.rest.handler.validator.cloudant.CloudantDatabaseValidator)").iterator().hasNext();
            jcaEnabled = ValidatorSchemaRESTHandler.getServiceReferences(this.context.getBundleContext(), Validator.class, "(component.name=com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator)").iterator().hasNext();
            jdbcEnabled = ValidatorSchemaRESTHandler.getServiceReferences(this.context.getBundleContext(), Validator.class, "(component.name=com.ibm.ws.rest.handler.validator.jdbc.DataSourceValidator)").iterator().hasNext();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.rest.handler.validator.openapi.ValidatorSchemaRESTHandler", (String)"142", (Object)this, (Object[])new Object[]{openAPI});
            e.printStackTrace();
        }
        if (jcaEnabled) {
            jmsEnabled = this.isJMSValidatorEnabled();
        }
        if (!cloudantEnabled) {
            openAPI.getPaths().remove((Object)"/validation/cloudantDatabase/");
            openAPI.getPaths().remove((Object)"/validation/cloudantDatabase/{uid}");
            openAPI.getComponents().getSchemas().remove("validation.cloudantDatabase.result");
        }
        if (!jcaEnabled) {
            openAPI.getPaths().remove((Object)"/validation/connectionFactory/");
            openAPI.getPaths().remove((Object)"/validation/connectionFactory/{uid}");
            openAPI.getComponents().getSchemas().remove("validation.connectionFactory.result");
        }
        if (!jmsEnabled) {
            openAPI.getPaths().remove((Object)"/validation/jmsConnectionFactory/");
            openAPI.getPaths().remove((Object)"/validation/jmsConnectionFactory/{uid}");
            openAPI.getPaths().remove((Object)"/validation/jmsQueueConnectionFactory/");
            openAPI.getPaths().remove((Object)"/validation/jmsQueueConnectionFactory/{uid}");
            openAPI.getPaths().remove((Object)"/validation/jmsTopicConnectionFactory/");
            openAPI.getPaths().remove((Object)"/validation/jmsTopicConnectionFactory/{uid}");
            openAPI.getComponents().getSchemas().remove("validation.jms.result");
        }
        if (!jdbcEnabled) {
            openAPI.getPaths().remove((Object)"/validation/dataSource/");
            openAPI.getPaths().remove((Object)"/validation/dataSource/{uid}");
            openAPI.getComponents().getSchemas().remove("validation.dataSource.result");
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static <S> Collection<ServiceReference<S>> getServiceReferences(final BundleContext bCtx, final Class<S> clazz, final String filter) throws InvalidSyntaxException {
        if (System.getSecurityManager() == null) {
            return bCtx.getServiceReferences(clazz, filter);
        }
        try {
            return (Collection)AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<ServiceReference<S>>>(){
                static final long serialVersionUID = 8243336766415500972L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Collection<ServiceReference<S>> run() throws InvalidSyntaxException {
                    return bCtx.getServiceReferences(clazz, filter);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.validator.openapi.ValidatorSchemaRESTHandler$1", 1.class, (String)"rest.validation", null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InvalidSyntaxException) {
                throw (InvalidSyntaxException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.context = null;
    }

    private boolean isJMSValidatorEnabled() {
        Class jmsClass = AccessController.doPrivileged(() -> {
            try {
                return this.getClass().getClassLoader().loadClass("javax.jms.ConnectionFactory");
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
        return jmsClass != null;
    }
}

