/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.credentials;

import com.ibm.ws.bluemix.utility.credentials.TargetInfo;
import com.ibm.ws.bluemix.utility.utils.JsonUtils;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class ConfigJson {
    private static File getCfConfigFile() {
        String cfHome = System.getenv("CF_HOME");
        if (cfHome == null) {
            cfHome = System.getProperty("user.home");
        }
        return new File(cfHome, ".cf" + File.separator + "config.json");
    }

    public static TargetInfo load() throws IOException {
        File configFile = ConfigJson.getCfConfigFile();
        if (!FileUtils.fileExists((File)configFile)) {
            return null;
        }
        return ConfigJson.load(FileUtils.getInputStream((File)configFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TargetInfo load(InputStream in) throws IOException {
        JsonObject tokenInfo;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            JsonReader jsonReader = Json.createReader((Reader)reader);
            tokenInfo = jsonReader.readObject();
        }
        catch (Throwable throwable) {
            FileUtils.tryToClose(reader);
            throw throwable;
        }
        FileUtils.tryToClose((Closeable)reader);
        TargetInfo targetInfo = new TargetInfo();
        targetInfo.setAPI(JsonUtils.getString(tokenInfo, "Target"));
        targetInfo.setAuthorizationEndpoint(JsonUtils.getString(tokenInfo, "AuthorizationEndpoint"));
        targetInfo.setRefreshToken(JsonUtils.getString(tokenInfo, "RefreshToken"));
        targetInfo.setAccessToken(JsonUtils.getString(tokenInfo, "AccessToken"));
        JsonObject orgInfo = tokenInfo.getJsonObject("OrganizationFields");
        String orgName = JsonUtils.getString(orgInfo, "Name");
        targetInfo.setOrganizationName(orgName);
        String orgGuid = JsonUtils.getString(orgInfo, "Guid");
        if (orgGuid == null) {
            orgGuid = JsonUtils.getString(orgInfo, "GUID");
        }
        targetInfo.setOrganizationGuid(orgGuid);
        JsonObject spaceInfo = tokenInfo.getJsonObject("SpaceFields");
        String spaceName = JsonUtils.getString(spaceInfo, "Name");
        targetInfo.setSpaceName(spaceName);
        String spaceGuid = JsonUtils.getString(spaceInfo, "Guid");
        if (spaceGuid == null) {
            spaceGuid = JsonUtils.getString(spaceInfo, "GUID");
        }
        targetInfo.setSpaceGuid(spaceGuid);
        return targetInfo;
    }
}

