/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseLoginAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;

public class SwitchAction
extends BaseLoginAction {
    private static final Option ORG_OPT = new Option("org", true);
    private static final Option SPACE_OPT = new Option("space", true);

    public SwitchAction() {
        this.registerOption(ORG_OPT);
        this.registerOption(SPACE_OPT);
    }

    @Override
    public String getActionName() {
        return "switch";
    }

    @Override
    public ReturnCode handleAction(Arguments args) throws Exception {
        ReturnCode rc;
        BluemixClient client = BluemixClient.getBluemixClient();
        String orgName = args.getOption(ORG_OPT);
        String spaceName = args.getOption(SPACE_OPT);
        if (orgName == null && spaceName != null) {
            rc = this.setSpace(client, spaceName);
        } else {
            rc = this.setOrganization(client, orgName);
            if (rc == ReturnCode.OK) {
                rc = this.setSpace(client, spaceName);
            }
        }
        return rc;
    }
}

