/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.api.ConfigurationServiceClient;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import java.util.List;
import java.util.Set;

public class ListServicesAction
extends BaseAction {
    private static final Option ALL_OPT = new Option("all", false, false, true);
    private static final Option CAAS_URL_OPT = new Option("caasUrl", true, false, true);

    public ListServicesAction() {
        this.registerOption(ALL_OPT);
        this.registerOption(CAAS_URL_OPT);
    }

    @Override
    public String getActionName() {
        return "listServices";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        Set<String> supportedServices;
        BluemixClient client = BluemixClient.getBluemixClient();
        if (arguments.hasOption(ALL_OPT)) {
            supportedServices = null;
        } else {
            String caasURL = arguments.getOption(CAAS_URL_OPT);
            ConfigurationServiceClient caasClient = null;
            caasClient = ConfigurationServiceClient.getConfigurationServiceClient(caasURL, client.getTargetInfo());
            supportedServices = caasClient.getSupportedServices();
        }
        List<CloudFoundryServiceInstance> services = client.getServices(supportedServices);
        this.printServices(services);
        return ReturnCode.OK;
    }

    private void printServices(List<CloudFoundryServiceInstance> services) {
        if (!services.isEmpty()) {
            String nameColumn = NLS.getOption("listServices.name", new Object[0]);
            int longestName = nameColumn.length();
            String labelColumn = NLS.getOption("listServices.label", new Object[0]);
            int longestLabel = labelColumn.length();
            String planColumn = NLS.getOption("listServices.plan", new Object[0]);
            for (CloudFoundryServiceInstance service : services) {
                String serviceLabel;
                String serviceName = service.getName();
                if (serviceName.length() > longestName) {
                    longestName = serviceName.length();
                }
                if ((serviceLabel = service.getService().getLabel()).length() <= longestLabel) continue;
                longestLabel = serviceLabel.length();
            }
            String format = "%-" + ++longestName + "s %-" + ++longestLabel + "s %s%n";
            this.stdout.format(format, nameColumn, labelColumn, planColumn);
            for (CloudFoundryServiceInstance service : services) {
                String serviceName = service.getName();
                String serviceLabel = service.getService().getLabel();
                String servicePlan = service.getPlan().getName();
                if (servicePlan == null) {
                    servicePlan = "";
                }
                this.stdout.format(format, serviceName, serviceLabel, servicePlan);
            }
        } else {
            this.stdout.println(NLS.getOption("listServices.no.instances", new Object[0]));
        }
    }
}

