/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.FeatureInstallation;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationException;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationRegistry;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BindServiceAction
extends BaseAction {
    private static final Option VARIABLES_OPT = new Option("v", true, true);
    private static final Option ACCEPT_LICENSE = new Option("acceptLicense", false);

    public BindServiceAction() {
        this.registerOption(VARIABLES_OPT);
        this.registerOption(ACCEPT_LICENSE);
        this.registerArguments("serverName", "serviceName");
    }

    @Override
    public String getActionName() {
        return "bind";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        Map<String, String> variables = arguments.getParameterOption(VARIABLES_OPT);
        String serverName = arguments.getPositionalArguments().get(0);
        String serviceName = arguments.getPositionalArguments().get(1);
        boolean acceptLicense = arguments.hasOption(ACCEPT_LICENSE);
        ServiceConfigurationRegistry registry = new ServiceConfigurationRegistry(Utils.getUserDir());
        ReturnCode rc = this.installFeatures(registry, serverName, serviceName, acceptLicense);
        if (rc == ReturnCode.OK) {
            boolean newBind = registry.bind(serviceName, serverName, variables);
            if (newBind) {
                this.stdout.println(NLS.getOption("bind.created", serviceName, serverName));
            } else {
                this.stdout.println(NLS.getOption("bind.updated", serviceName, serverName));
            }
        }
        return rc;
    }

    private ReturnCode installFeatures(ServiceConfigurationRegistry registry, String serverName, String serviceName, boolean acceptLicense) throws InstallException, ServiceConfigurationException {
        this.stdout.println(NLS.getOption("bind.feature.resolve", serviceName));
        FeatureInstallation install = new FeatureInstallation();
        InstallEventListener listener = install.getListener();
        install.addListener(listener);
        Set<String> featuresToResolve = registry.getServiceFeatures(serviceName);
        if (featuresToResolve.isEmpty()) {
            this.stdout.println(NLS.getOption("bind.feature.none", new Object[0]));
            return ReturnCode.OK;
        }
        boolean installFeatures = install.resolveFeatures(featuresToResolve);
        if (!installFeatures) {
            this.stdout.println(NLS.getOption("bind.feature.none", new Object[0]));
            return ReturnCode.OK;
        }
        this.stdout.println();
        this.stdout.println(NLS.getOption("bind.feature.install", new Object[0]));
        this.stdout.println();
        if (acceptLicense) {
            this.stdout.println(NLS.getOption("bind.license.accept", new Object[0]));
            this.stdout.println();
        } else {
            String agreement = install.getFeatureLicenseAgreement();
            this.stdout.println(agreement);
            String prompt = NLS.getOption("bind.license.prompt", "[1]", "[2]");
            if (!this.getResponse(prompt, "1", "2", null)) {
                this.stdout.println(NLS.getOption("bind.license.not.accepted", new Object[0]));
                return ReturnCode.USER_ABORT;
            }
        }
        Map<String, Collection<String>> features = install.installFeatures();
        Collection<String> featureNames = features.get("feature");
        String featureStr = this.toString(featureNames);
        this.stdout.println(NLS.getOption("bind.feature.install.success", featureStr));
        install.removeListener(listener);
        return ReturnCode.OK;
    }

    private String toString(Collection<String> featuresNames) {
        StringBuffer buffer = new StringBuffer();
        if (featuresNames != null) {
            Iterator<String> iterator = featuresNames.iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }
}

