/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.internal.ChangeHandler;
import com.ibm.ws.config.xml.internal.ConfigComparator;
import com.ibm.ws.config.xml.internal.ConfigurationInfo;
import com.ibm.ws.config.xml.internal.ConfigurationMonitor;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import io.openliberty.checkpoint.spi.CheckpointHook;
import java.lang.constant.Constable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigRefresher {
    static final TraceComponent tc = Tr.register(ConfigRefresher.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ChangeHandler changeHandler;
    private final ServerXMLConfiguration serverXMLConfig;
    private final ConfigurationMonitor configurationMonitor;
    private final ServiceTracker<RuntimeUpdateManager, RuntimeUpdateManager> runtimeUpdateManagerTracker;
    private final ServiceTracker<Executor, Executor> executorTracker;
    private final ServiceTracker<MetaTypeRegistry, MetaTypeRegistry> metatypeTracker;
    private long configStartTime = 0L;
    private Collection<Future<?>> futuresForChanges = null;
    private final ChangesEndedHook changesEndedHook;
    private final ServiceRegistration<CheckpointHook> checkpointHookRegistration;
    static final long serialVersionUID = -6226728885140215939L;

    ConfigRefresher(BundleContext bundleContext, ChangeHandler changeHandler, ServerXMLConfiguration serverXMLConfig, ConfigVariableRegistry variableRegistry) {
        this.changeHandler = changeHandler;
        this.serverXMLConfig = serverXMLConfig;
        this.configurationMonitor = new ConfigurationMonitor(bundleContext, serverXMLConfig, this, variableRegistry);
        this.runtimeUpdateManagerTracker = new ServiceTracker(bundleContext, RuntimeUpdateManager.class.getName(), null);
        this.runtimeUpdateManagerTracker.open();
        this.executorTracker = new ServiceTracker(bundleContext, ExecutorService.class.getName(), null);
        this.executorTracker.open();
        this.metatypeTracker = new ServiceTracker(bundleContext, MetaTypeRegistry.class.getName(), null);
        this.metatypeTracker.open();
        this.changesEndedHook = new ChangesEndedHook();
        Hashtable<String, Constable> hookProps = new Hashtable<String, Constable>();
        hookProps.put("service.ranking", Integer.valueOf(-2147473648));
        hookProps.put("io.openliberty.checkpoint.hook.multi.threaded", Boolean.TRUE);
        this.checkpointHookRegistration = bundleContext.registerService(CheckpointHook.class, (Object)this.changesEndedHook, hookProps);
    }

    void start() {
        this.configurationMonitor.registerService();
    }

    void stop() {
        this.configurationMonitor.stopConfigurationMonitoring();
        this.runtimeUpdateManagerTracker.close();
        if (this.checkpointHookRegistration != null) {
            this.checkpointHookRegistration.unregister();
        }
    }

    public void refreshConfiguration() {
        this.doRefresh(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private synchronized void doRefresh(Map<String, ConfigComparator.DeltaType> variableDelta) {
        if (FrameworkState.isStopping()) {
            return;
        }
        this.configStartTime = System.nanoTime();
        RuntimeUpdateManager runtimeUpdateManager = (RuntimeUpdateManager)this.runtimeUpdateManagerTracker.getService();
        RuntimeUpdateNotification configUpdatesDelivered = runtimeUpdateManager.createNotification("ConfigUpdatesDelivered");
        this.futuresForChanges = null;
        try {
            Tr.audit((TraceComponent)tc, (String)"info.config.refresh.start", (Object[])new Object[0]);
            ServerConfiguration newConfiguration = this.serverXMLConfig.loadNewConfiguration();
            if (newConfiguration == null) {
                return;
            }
            ConfigComparator.ComparatorResult result = this.compareConfigurations(this.serverXMLConfig.getConfiguration(), newConfiguration, variableDelta);
            if (result == null) {
                return;
            }
            Collection<ConfigurationInfo> configurations = null;
            if (!result.hasDelta()) {
                Tr.audit((TraceComponent)tc, (String)"info.config.refresh.nochanges", (Object[])new Object[0]);
            } else {
                try {
                    configurations = this.changeHandler.switchConfiguration(this.serverXMLConfig, result);
                }
                catch (ConfigUpdateException configUpdateException) {
                    void e;
                    FFDCFilter.processException((Throwable)configUpdateException, (String)"com.ibm.ws.config.xml.internal.ConfigRefresher", (String)"145", (Object)this, (Object[])new Object[]{variableDelta});
                    Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{e.getMessage()});
                }
            }
            this.configurationMonitor.updateFileMonitor(this.serverXMLConfig.getFilesToMonitor());
            this.configurationMonitor.updateDirectoryMonitor(this.serverXMLConfig.getDirectoriesToMonitor());
            if (configurations != null) {
                this.futuresForChanges = this.fireConfigurationChanges(configurations);
            }
        }
        catch (Exception newConfiguration) {
            void e;
            FFDCFilter.processException((Throwable)newConfiguration, (String)"com.ibm.ws.config.xml.internal.ConfigRefresher", (String)"157", (Object)this, (Object[])new Object[]{variableDelta});
            configUpdatesDelivered.setResult((Throwable)e);
        }
        finally {
            if (!this.changesEndedHook.queueNotification(configUpdatesDelivered)) {
                this.changesEnded(configUpdatesDelivered);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private ConfigComparator.ComparatorResult compareConfigurations(ServerConfiguration serverConfiguration, ServerConfiguration newConfiguration, Map<String, ConfigComparator.DeltaType> variableDelta) {
        ConfigComparator.ComparatorResult result;
        ConfigComparator comparator = new ConfigComparator(serverConfiguration, newConfiguration, (MetaTypeRegistry)this.metatypeTracker.getService(), variableDelta);
        try {
            result = comparator.computeDelta();
        }
        catch (ConfigUpdateException configUpdateException) {
            void e1;
            FFDCFilter.processException((Throwable)configUpdateException, (String)"com.ibm.ws.config.xml.internal.ConfigRefresher", (String)"173", (Object)this, (Object[])new Object[]{serverConfiguration, newConfiguration, variableDelta});
            Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{e1.getMessage()});
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doRefreshConfiguration(): Configuration changes: " + result), (Object[])new Object[0]);
        }
        result.setNewConfiguration(newConfiguration);
        return result;
    }

    private Collection<Future<?>> fireConfigurationChanges(Collection<ConfigurationInfo> configurations) {
        ArrayList futures = new ArrayList();
        for (ConfigurationInfo info : configurations) {
            info.fireEvents(futures);
        }
        return futures;
    }

    void changesEnded(final RuntimeUpdateNotification configUpdatesDelivered) {
        final long endingConfigStartTime = this.configStartTime;
        final Collection<Future<?>> endingFuturesForChanges = this.futuresForChanges;
        this.configStartTime = 0L;
        this.futuresForChanges = null;
        Executor executor = (Executor)this.executorTracker.getService();
        if (executor != null) {
            executor.execute(new Runnable(){
                static final long serialVersionUID = -2771400905243585973L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    ConfigRefresher.this.endConfigChanges(configUpdatesDelivered, endingConfigStartTime, endingFuturesForChanges);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigRefresher$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
                }
            });
        } else {
            this.endConfigChanges(configUpdatesDelivered, endingConfigStartTime, endingFuturesForChanges);
        }
    }

    private void endConfigChanges(RuntimeUpdateNotification configUpdatesDelivered, long endingConfigStartTime, Collection<Future<?>> endingFuturesForChanges) {
        RuntimeUpdateNotification appsStarting;
        boolean noTimeout = endingFuturesForChanges != null ? this.waitForAll(endingFuturesForChanges, 1L, TimeUnit.MINUTES) : true;
        configUpdatesDelivered.setResult(true);
        RuntimeUpdateManager runtimeUpdateManager = (RuntimeUpdateManager)this.runtimeUpdateManagerTracker.getService();
        if (runtimeUpdateManager == null) {
            if (FrameworkState.isStopping()) {
                return;
            }
            throw new IllegalStateException("The RuntimeUpdateManager service could not be obtained");
        }
        RuntimeUpdateNotification featureUpdatesCompleted = runtimeUpdateManager.getNotification("FeatureUpdatesCompleted");
        if (featureUpdatesCompleted != null) {
            featureUpdatesCompleted.waitForCompletion();
        }
        if ((appsStarting = runtimeUpdateManager.getNotification("ApplicationsStarting")) != null) {
            appsStarting.waitForCompletion();
        }
        if (endingFuturesForChanges != null) {
            if (noTimeout) {
                Tr.audit((TraceComponent)tc, (String)"info.config.refresh.stop", (Object[])new Object[]{TimestampUtils.getElapsedTimeNanos((long)endingConfigStartTime)});
            } else {
                Tr.warning((TraceComponent)tc, (String)"info.config.refresh.timeout", (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={InterruptedException.class, ExecutionException.class, TimeoutException.class})
    private boolean waitForAll(Collection<Future<?>> futureList, long timeout, TimeUnit timeUnit) {
        long timeoutNanos = timeUnit.toNanos(timeout);
        for (Future<?> future : futureList) {
            if (future == null || future.isDone()) continue;
            if (timeoutNanos <= 0L) {
                return false;
            }
            long startTime = System.nanoTime();
            try {
                future.get(timeoutNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
            catch (TimeoutException e) {
                return false;
            }
            long endTime = System.nanoTime();
            timeoutNanos -= endTime - startTime;
        }
        return true;
    }

    public void variableRefresh(Map<String, ConfigComparator.DeltaType> deltaMap) {
        this.doRefresh(deltaMap);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ChangesEndedHook
    implements CheckpointHook {
        private final ThreadLocal<Boolean> checkpointThread = new ThreadLocal<Boolean>(){
            static final long serialVersionUID = 3852481382349970891L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigRefresher$ChangesEndedHook$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        };
        final Deque<RuntimeUpdateNotification> configUpdatesToDeliver = new ArrayDeque<RuntimeUpdateNotification>();
        static final long serialVersionUID = -6833338976868354700L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ChangesEndedHook() {
        }

        boolean queueNotification(RuntimeUpdateNotification notification) {
            if (!this.checkpointThread.get().booleanValue()) {
                return false;
            }
            this.configUpdatesToDeliver.add(notification);
            return true;
        }

        public void prepare() {
            this.checkpointThread.set(true);
        }

        public void restore() {
            this.checkpointThread.set(false);
            RuntimeUpdateNotification notification = null;
            while ((notification = this.configUpdatesToDeliver.pollFirst()) != null) {
                ConfigRefresher.this.changesEnded(notification);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigRefresher$ChangesEndedHook", ChangesEndedHook.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }
}

