/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.api.ConfigurationServiceClient;
import com.ibm.ws.bluemix.utility.api.ServiceConfiguration;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationRegistry;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImportServiceAction
extends BaseAction {
    private static final Option ACCEPT_LICENSE_OPT = new Option("acceptLicense", false);
    private static final Option KEY_NAME_OPT = new Option("credentialName", true);
    private static final Option CAAS_URL_OPT = new Option("caasUrl", true, false, true);
    private static final Option ENCODE_ALGORITHM_OPT = new Option("encodeAlgorithm", true);
    private static final Option ENCODE_KEY_OPT = new Option("encodeKey", true);
    private static final Option PARAMETERS_OPT = new Option("p", true, true);

    public ImportServiceAction() {
        this.registerOption(ACCEPT_LICENSE_OPT);
        this.registerOption(KEY_NAME_OPT);
        this.registerOption(CAAS_URL_OPT);
        this.registerOption(ENCODE_ALGORITHM_OPT);
        this.registerOption(ENCODE_KEY_OPT);
        this.registerOption(PARAMETERS_OPT);
        this.registerArguments("serviceName");
    }

    @Override
    public String getActionName() {
        return "import";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        String serviceName = arguments.getPositionalArguments().get(0);
        BluemixClient client = BluemixClient.getBluemixClient();
        CloudFoundryServiceInstance service = client.getService(serviceName);
        String caasURL = arguments.getOption(CAAS_URL_OPT);
        ConfigurationServiceClient caasClient = null;
        caasClient = ConfigurationServiceClient.getConfigurationServiceClient(caasURL, client.getTargetInfo());
        String serviceKeyName = arguments.getOption(KEY_NAME_OPT);
        Map<String, String> variables = arguments.getParameterOption(PARAMETERS_OPT);
        ServiceConfiguration configuration = caasClient.importConfiguration(service, serviceKeyName, variables);
        ServiceConfigurationRegistry registry = new ServiceConfigurationRegistry(Utils.getUserDir());
        if (registry.requiresLicenseCheck(configuration)) {
            boolean acceptLicense = arguments.hasOption(ACCEPT_LICENSE_OPT);
            if (acceptLicense) {
                this.stdout.println(NLS.getOption("import.license.accept", new Object[0]));
                this.stdout.println();
            } else {
                this.stdout.println(NLS.getOption("import.license.agreement", configuration.getName()));
                this.displayLibraryInfo(configuration);
                String prompt = NLS.getOption("import.license.prompt", "[1]", "[2]");
                if (!this.getResponse(prompt, "1", "2", null)) {
                    this.stdout.println(NLS.getOption("import.license.not.accepted", new Object[0]));
                    return ReturnCode.USER_ABORT;
                }
            }
        }
        String encodeAlgorithm = arguments.getOption(ENCODE_ALGORITHM_OPT);
        String encodeKey = arguments.getOption(ENCODE_KEY_OPT);
        boolean newInstall = registry.install(configuration, encodeAlgorithm, encodeKey);
        this.stdout.println();
        if (newInstall) {
            this.stdout.println(NLS.getOption("import.imported", configuration.getName()));
        } else {
            this.stdout.println(NLS.getOption("import.updated", configuration.getName()));
        }
        String instructions = configuration.getInstructions();
        if (instructions != null) {
            this.stdout.println();
            this.stdout.println(NLS.getOption("import.instructions", new Object[0]));
            this.stdout.println(instructions);
        }
        return ReturnCode.OK;
    }

    private void displayLibraryInfo(ServiceConfiguration configuration) {
        LinkedHashMap licenseLibraryMap = new LinkedHashMap();
        List<ServiceConfiguration.Library> libraries = configuration.getLibraries();
        for (ServiceConfiguration.Library library : libraries) {
            String url;
            String license = library.getLicense();
            if (license == null) continue;
            ArrayList<String> urls = (ArrayList<String>)licenseLibraryMap.get(license);
            if (urls == null) {
                urls = new ArrayList<String>();
                licenseLibraryMap.put(license, urls);
            }
            if ((url = library.getDisplayUrl()) == null) {
                url = library.getUrl();
            }
            urls.add(url);
        }
        Map<String, ServiceConfiguration.License> licenseMap = configuration.getLicenseMap();
        for (Map.Entry entry : licenseLibraryMap.entrySet()) {
            String licenseId = (String)entry.getKey();
            ServiceConfiguration.License license = licenseMap.get(licenseId);
            this.stdout.println(NLS.getOption("import.license", licenseId));
            this.stdout.println(NLS.getOption("import.license.link", license.getUrl()));
            this.stdout.println(NLS.getOption("import.libraries", new Object[0]));
            List urls = (List)entry.getValue();
            for (String url : urls) {
                this.stdout.println(" " + url);
            }
            this.stdout.println();
        }
    }
}

