/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.RLSAccessFile;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CoordinationLock {
    private static final TraceComponent tc = Tr.register(CoordinationLock.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    public static final int LOCK_SUCCESS = 1;
    public static final int LOCK_FAILURE = 2;
    public static final int LOCK_INTERRUPT = 4;
    static final int LOCKRETRYCOUNT = 0;
    static final int LOCKRETRYDELAY = 10000;
    static final int LOCKRETRYTIMES = 30;
    private static String RECOVERY_FILE_1_NAME = "log1";
    private static String RECOVERY_FILE_2_NAME = "log2";
    CoordinationLockHandle _handle1 = null;
    CoordinationLockHandle _handle2 = null;
    private final String _lockDirectory;
    private boolean _lockFilesExist = false;
    private boolean _interrupted = false;
    static final long serialVersionUID = -4689287197944100322L;

    @ManualTrace
    public CoordinationLock(String lockDirectory) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"CoordinationLock", (Object[])new Object[]{lockDirectory});
        }
        this._lockDirectory = lockDirectory;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"CoordinationLock", (Object)this);
        }
    }

    @ManualTrace
    public int lock() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lock", (Object[])new Object[0]);
        }
        int result = 2;
        if (!this._lockFilesExist) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Confirming/Creating the lock files", (Object[])new Object[0]);
            }
            this._handle1 = this.ensureFileExists(RECOVERY_FILE_1_NAME);
            if (this._handle1 != null) {
                this._handle2 = this.ensureFileExists(RECOVERY_FILE_2_NAME);
                if (this._handle2 != null) {
                    this._lockFilesExist = true;
                } else {
                    Tr.error((TraceComponent)tc, (String)"CWRLS0004_RECOVERY_LOG_CREATE_FAILED", (Object[])new Object[]{this._lockDirectory + File.separator + RECOVERY_FILE_2_NAME});
                    this._handle1 = null;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"CWRLS0004_RECOVERY_LOG_CREATE_FAILED", (Object[])new Object[]{this._lockDirectory + File.separator + RECOVERY_FILE_1_NAME});
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Already Confirmed/Created the lock files", (Object[])new Object[0]);
        }
        if (this._lockFilesExist) {
            result = this.obtainLock(this._handle1);
            if (result == 1) {
                result = this.obtainLock(this._handle2);
                if (result != 1) {
                    if (result == 2) {
                        Tr.error((TraceComponent)tc, (String)"CWRLS0005_RECOVERY_LOG_LOCK_FAILED", (Object[])new Object[]{this._lockDirectory + File.separator + RECOVERY_FILE_2_NAME});
                    }
                    this.releaseLock(this._handle1);
                }
            } else if (result == 2) {
                Tr.error((TraceComponent)tc, (String)"CWRLS0005_RECOVERY_LOG_LOCK_FAILED", (Object[])new Object[]{this._lockDirectory + File.separator + RECOVERY_FILE_1_NAME});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lock", (Object)result);
        }
        return result;
    }

    @ManualTrace
    public void unlock() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unlock", (Object[])new Object[0]);
        }
        if (this._handle2 != null) {
            this.releaseLock(this._handle2);
        }
        if (this._handle1 != null) {
            this.releaseLock(this._handle1);
        }
        this._handle2 = null;
        this._handle1 = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unlock");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private int obtainLock(CoordinationLockHandle handle) {
        int result;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"obtainLock", (Object[])new Object[]{handle});
            }
            result = 2;
            try {
                final File file = new File(handle._directory, handle._fileName);
                try {
                    handle._raf = AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){
                        static final long serialVersionUID = 8758173627421796857L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        @ManualTrace
                        public RandomAccessFile run() throws Exception {
                            if (tc.isEntryEnabled()) {
                                Tr.entry((TraceComponent)tc, (String)"run", (Object[])new Object[]{this});
                            }
                            RLSAccessFile raf = RLSAccessFile.getRLSAccessFile(file);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"run");
                            }
                            return raf;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.CoordinationLock$1", 1.class, null, null);
                        }
                    });
                    handle._channel = handle._raf.getChannel();
                }
                catch (PrivilegedActionException privilegedActionException) {
                    void exc;
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"229", (Object)this, (Object[])new Object[]{handle});
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.obtainLock", (String)"253", (Object)this);
                    throw exc;
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"232", (Object)this, (Object[])new Object[]{handle});
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.obtainLock", (String)"258", (Object)this);
                    throw exc;
                }
                boolean halt = false;
                int lockAttempt = 0;
                while (!halt) {
                    int l;
                    ++lockAttempt;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RLSHA: Lock attempt #" + lockAttempt + " on lock file " + handle), (Object[])new Object[0]);
                    }
                    handle._fileLock = handle._channel.tryLock();
                    if (handle._fileLock != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RLSHA: Obtained an exclusive access lock on lock file " + handle), (Object[])new Object[0]);
                        }
                        halt = true;
                        result = 1;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RLSHA: Unable to obtain an exclusive access lock on lock file " + handle), (Object[])new Object[0]);
                    }
                    if ((l = lockAttempt - 2) / 30 * 30 == l) {
                        Tr.warning((TraceComponent)tc, (String)"CWRLS0026_RECOVERY_LOG_LOCK_RETRY", (Object[])new Object[]{file});
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Sleeping for 10000 ms before re-try", (Object[])new Object[0]);
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"268", (Object)this, (Object[])new Object[]{handle});
                    }
                    if (!this._interrupted) continue;
                    halt = true;
                    result = 4;
                    try {
                        handle._raf.close();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"281", (Object)this, (Object[])new Object[]{handle});
                    }
                }
            }
            catch (Exception file) {
                void exc;
                FFDCFilter.processException((Throwable)file, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"286", (Object)this, (Object[])new Object[]{handle});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("An unexpected exception has occured when trying to obtain the exclusive lock " + exc), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{exc});
                if (handle._raf == null) break block21;
                try {
                    handle._raf.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"296", (Object)this, (Object[])new Object[]{handle});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"obtainLock", (Object)result);
        }
        return result;
    }

    @ManualTrace
    public void releaseLock(CoordinationLockHandle clh) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseLock", (Object[])new Object[]{clh});
        }
        if (clh._fileLock != null) {
            try {
                clh._fileLock.release();
                clh._fileLock = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"320", (Object)this, (Object[])new Object[]{clh});
            }
        }
        if (clh._channel != null) {
            try {
                clh._channel.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"327", (Object)this, (Object[])new Object[]{clh});
            }
        }
        if (clh._raf != null) {
            try {
                clh._raf.close();
                clh._raf = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"335", (Object)this, (Object[])new Object[]{clh});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseLock");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public CoordinationLockHandle ensureFileExists(String lockFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ensureFileExists", (Object[])new Object[]{lockFile});
        }
        CoordinationLockHandle clh = null;
        if (RLSUtils.createDirectoryTree(this._lockDirectory)) {
            final File file = new File(this._lockDirectory, lockFile);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = -4329885356556756938L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    @ManualTrace
                    public Object run() throws Exception {
                        if (tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)tc, (String)"run", (Object[])new Object[]{this});
                        }
                        new RandomAccessFile(file, "rw").close();
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"run");
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.CoordinationLock$2", 2.class, null, null);
                    }
                });
                if (file.exists()) {
                    clh = new CoordinationLockHandle();
                    clh._fileName = lockFile;
                    clh._directory = this._lockDirectory;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                void exc;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"383", (Object)this, (Object[])new Object[]{lockFile});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.ensureFileExists", (String)"418", (Object)this);
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"385", (Object)this, (Object[])new Object[]{lockFile});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.ensureFileExists", (String)"422", (Object)this);
            }
            if (clh != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Lock file exists", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to create the lock file", (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unable to create the lock directory", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ensureFileExists", clh);
        }
        return clh;
    }

    @ManualTrace
    public synchronized void interrupt() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"interrupt", (Object[])new Object[0]);
        }
        this._interrupted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"interrupt");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class CoordinationLockHandle {
        RandomAccessFile _raf = null;
        FileChannel _channel = null;
        String _fileName = null;
        String _directory = null;
        FileLock _fileLock = null;
        static final long serialVersionUID = 1108483394700969916L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        void raf(RandomAccessFile raf) {
            this._raf = raf;
        }

        public String toString() {
            return this._directory + File.separator + this._fileName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.CoordinationLock$CoordinationLockHandle", CoordinationLockHandle.class, null, null);
        }
    }
}

