/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.BigIntegers;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private static final BcPGPKeyConverter KEY_CONVERTER = new BcPGPKeyConverter();
    private final PGPPrivateKey pgpPrivKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        this.pgpPrivKey = pGPPrivateKey;
    }

    @Override
    public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
        try {
            Object object;
            ECDHBasicAgreement eCDHBasicAgreement;
            byte[] byArray2;
            Object object2;
            Object object3;
            AsymmetricKeyParameter asymmetricKeyParameter = KEY_CONVERTER.getPrivateKey(this.pgpPrivKey);
            if (n != 18) {
                AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(n);
                BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = new BufferedAsymmetricBlockCipher(asymmetricBlockCipher);
                bufferedAsymmetricBlockCipher.init(false, asymmetricKeyParameter);
                if (n == 2 || n == 1) {
                    byte[] byArray3 = byArray[0];
                    bufferedAsymmetricBlockCipher.processBytes(byArray3, 2, byArray3.length - 2);
                } else {
                    ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                    int n2 = (elGamalPrivateKeyParameters.getParameters().getP().bitLength() + 7) / 8;
                    byte[] byArray4 = new byte[n2];
                    byte[] byArray5 = byArray[0];
                    if (byArray5.length - 2 > n2) {
                        bufferedAsymmetricBlockCipher.processBytes(byArray5, 3, byArray5.length - 3);
                    } else {
                        System.arraycopy(byArray5, 2, byArray4, byArray4.length - (byArray5.length - 2), byArray5.length - 2);
                        bufferedAsymmetricBlockCipher.processBytes(byArray4, 0, byArray4.length);
                    }
                    byArray5 = byArray[1];
                    for (int i = 0; i != byArray4.length; ++i) {
                        byArray4[i] = 0;
                    }
                    if (byArray5.length - 2 > n2) {
                        bufferedAsymmetricBlockCipher.processBytes(byArray5, 3, byArray5.length - 3);
                    } else {
                        System.arraycopy(byArray5, 2, byArray4, byArray4.length - (byArray5.length - 2), byArray5.length - 2);
                        bufferedAsymmetricBlockCipher.processBytes(byArray4, 0, byArray4.length);
                    }
                }
                return bufferedAsymmetricBlockCipher.doFinal();
            }
            ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)this.pgpPrivKey.getPublicKeyPacket().getKey();
            byte[] byArray6 = byArray[0];
            int n3 = (((byArray6[0] & 0xFF) << 8) + (byArray6[1] & 0xFF) + 7) / 8;
            if (2 + n3 + 1 > byArray6.length) {
                throw new PGPException("encoded length out of range");
            }
            byte[] byArray7 = new byte[n3];
            System.arraycopy(byArray6, 2, byArray7, 0, n3);
            int n4 = byArray6[n3 + 2] & 0xFF;
            if (2 + n3 + 1 + n4 > byArray6.length) {
                throw new PGPException("encoded length out of range");
            }
            byte[] byArray8 = new byte[n4];
            System.arraycopy(byArray6, 2 + n3 + 1, byArray8, 0, n4);
            if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                if (byArray7.length != 33 || 64 != byArray7[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                object3 = new X25519PublicKeyParameters(byArray7, 1);
                object2 = new X25519Agreement();
                object2.init((CipherParameters)asymmetricKeyParameter);
                byArray2 = new byte[object2.getAgreementSize()];
                object2.calculateAgreement((CipherParameters)object3, byArray2, 0);
            } else {
                object3 = ((ECPrivateKeyParameters)asymmetricKeyParameter).getParameters();
                object2 = new ECPublicKeyParameters(((ECDomainParameters)object3).getCurve().decodePoint(byArray7), (ECDomainParameters)object3);
                eCDHBasicAgreement = new ECDHBasicAgreement();
                eCDHBasicAgreement.init((CipherParameters)asymmetricKeyParameter);
                object = eCDHBasicAgreement.calculateAgreement((CipherParameters)object2);
                byArray2 = BigIntegers.asUnsignedByteArray(eCDHBasicAgreement.getFieldSize(), (BigInteger)object);
            }
            object3 = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(eCDHPublicBCPGKey.getHashAlgorithm()), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            object2 = RFC6637Utils.createUserKeyingMaterial(this.pgpPrivKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator());
            eCDHBasicAgreement = new KeyParameter(((RFC6637KDFCalculator)object3).createKey(byArray2, (byte[])object2));
            object = BcImplProvider.createWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            object.init(false, (CipherParameters)eCDHBasicAgreement);
            return PGPPad.unpadSessionData(object.unwrap(byArray8, 0, byArray8.length));
        }
        catch (IOException iOException) {
            throw new PGPException("exception creating user keying material: " + iOException.getMessage(), iOException);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception decrypting session info: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }
}

