/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;

public class PGPObjectFactory
implements Iterable {
    private BCPGInputStream in;
    private KeyFingerPrintCalculator fingerPrintCalculator;

    public PGPObjectFactory(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) {
        this.in = BCPGInputStream.wrap(inputStream);
        this.fingerPrintCalculator = keyFingerPrintCalculator;
    }

    public PGPObjectFactory(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 2: {
                ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        arrayList.add(new PGPSignature(this.in));
                    }
                    catch (UnsupportedPacketVersionException unsupportedPacketVersionException) {
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create signature object: " + pGPException);
                    }
                }
                return new PGPSignatureList(arrayList.toArray(new PGPSignature[arrayList.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException pGPException) {
                    throw new IOException("can't create secret key object: " + pGPException);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in, this.fingerPrintCalculator);
            }
            case 14: {
                try {
                    return PGPPublicKeyRing.readSubkey(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException pGPException) {
                    throw new IOException("processing error: " + pGPException.getMessage());
                }
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 1: 
            case 3: 
            case 9: 
            case 18: 
            case 20: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> arrayList = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        arrayList.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create one pass signature object: " + pGPException);
                    }
                }
                return new PGPOnePassSignatureList(arrayList.toArray(new PGPOnePassSignature[arrayList.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 21: {
                return new PGPPadding(this.in);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
        }
        throw new IOException("unknown object in stream: " + this.in.nextPacketTag());
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private boolean triedNext = false;
            private Object obj = null;

            @Override
            public boolean hasNext() {
                if (!this.triedNext) {
                    this.triedNext = true;
                    this.obj = this.getObject();
                }
                return this.obj != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.triedNext = false;
                return this.obj;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove element from factory.");
            }

            private Object getObject() {
                try {
                    return PGPObjectFactory.this.nextObject();
                }
                catch (IOException iOException) {
                    throw new PGPRuntimeOperationException("Iterator failed to get next object: " + iOException.getMessage(), iOException);
                }
            }
        };
    }
}

