/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
class CachedTime {
    private static final DateTimeFormatter dateFormatter;
    private static final CachedTime instance;
    private final AtomicReference<CachedFormattedTime> cachedTime = new AtomicReference();
    static final long serialVersionUID = 7349319852350035141L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected CachedTime() {
    }

    public static CachedTime getCachedTime() {
        return instance;
    }

    protected String getTimeAsString(long now) {
        now -= now % 1000L;
        CachedFormattedTime cachedFormattedTime = this.cachedTime.get();
        if (cachedFormattedTime != null && now == cachedFormattedTime.timeInMilliseconds) {
            return cachedFormattedTime.formattedTimeString;
        }
        String sTime = dateFormatter.format(Instant.ofEpochMilli(now));
        this.cachedTime.compareAndSet(cachedFormattedTime, new CachedFormattedTime(now, sTime));
        return sTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.interceptor.CachedTime", CachedTime.class, null, null);
        dateFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM uuuu HH:mm:ss zzz", Locale.US).withZone(ZoneId.of("GMT"));
        instance = new CachedTime();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class CachedFormattedTime {
        final long timeInMilliseconds;
        final String formattedTimeString;
        static final long serialVersionUID = 3754155481595474106L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CachedFormattedTime(long time, String formattedString) {
            this.timeInMilliseconds = time;
            this.formattedTimeString = formattedString;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.interceptor.CachedTime$CachedFormattedTime", CachedFormattedTime.class, null, null);
        }
    }
}

