/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.servlet.ESIProcessor;
import com.ibm.ws.cache.servlet.ESIProcessorStats;
import com.ibm.ws.cache.servlet.ESIServerStats;
import java.io.IOException;
import java.util.HashMap;

public class ESIStats {
    private static final TraceComponent _tc = Tr.register(ESIStats.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private HashMap _serverStats = new HashMap();
    private boolean _gatherEntries = false;

    public boolean getGatherEntries() {
        return this._gatherEntries;
    }

    public void setGatherEntries(boolean gatherEntries) {
        this._gatherEntries = gatherEntries;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("setGatherEntries " + gatherEntries));
        }
    }

    public void gather() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"gather");
        }
        this.clear();
        int gatherWhat = this._gatherEntries ? 8064 : 3968;
        ESIProcessorStats[] stats = ESIProcessor.gather(gatherWhat);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"sorting gathered statistics");
        }
        for (int idx = 0; idx < stats.length; ++idx) {
            String hostName = stats[idx].getHostName();
            ESIServerStats serverStats = (ESIServerStats)this._serverStats.get(hostName);
            if (serverStats == null) {
                serverStats = new ESIServerStats(hostName);
                this._serverStats.put(hostName, serverStats);
            }
            serverStats.addProcessorStats(stats[idx]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"gather");
        }
    }

    public ESIServerStats[] getServerStats() {
        return this._serverStats.values().toArray(new ESIServerStats[0]);
    }

    public void clear() {
        this._serverStats.clear();
    }

    public void resetCounters() throws IOException {
        ESIProcessor.resetCounters();
    }

    public void clearCaches() throws IOException {
        ESIProcessor.clearCaches();
    }
}

