/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.web;

import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.ExternalInvalidation;
import com.ibm.ws.cache.web.ExternalCacheEntry;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class ExternalCacheFragment
implements ExternalInvalidation,
Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static SimpleDateFormat httpDateFormat = null;
    private static final String EXPIRES = "Expires";
    private String uri = null;
    private String host = null;
    private ArrayList vHostList = new ArrayList();
    private String externalCacheGroupId = null;
    private byte[] content = null;
    private ValueSet invalidationIds = new ValueSet(4);
    private ValueSet uris = new ValueSet(4);
    private Vector[] headerTable = null;
    private long expirationTime = -1L;
    private long timeStamp = -1L;
    private transient ExternalCacheEntry externalCacheEntry = null;

    public String getExternalCacheGroupId() {
        return this.externalCacheGroupId;
    }

    public void setExternalCacheGroupId(String externalCacheGroupId) {
        this.externalCacheGroupId = externalCacheGroupId;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void addHostToList(String host) {
        if (!this.vHostList.contains(host)) {
            this.vHostList.add(host);
        }
    }

    public ArrayList getHostList() {
        return this.vHostList;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public Enumeration getInvalidationIds() {
        return this.invalidationIds.elements();
    }

    public void setInvalidationIds(ValueSet invalidationIds) {
        this.invalidationIds = invalidationIds;
    }

    public Enumeration getTemplates() {
        return this.uris.elements();
    }

    public void setTemplates(ValueSet uris) {
        this.uris = uris;
    }

    public Vector[] getHeaderTable() {
        return this.headerTable;
    }

    public void setHeaderTable(Vector[] headerTable) {
        this.headerTable = headerTable;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalCacheEntry getEntry() {
        if (this.externalCacheEntry != null) {
            return this.externalCacheEntry;
        }
        this.externalCacheEntry = new ExternalCacheEntry();
        this.externalCacheEntry.uri = this.uri;
        this.externalCacheEntry.host = this.host;
        this.externalCacheEntry.content = this.content;
        this.externalCacheEntry.headerTable = this.headerTable;
        SimpleDateFormat simpleDateFormat = httpDateFormat;
        synchronized (simpleDateFormat) {
            if (this.expirationTime >= 0L) {
                if (this.headerTable[0].contains(EXPIRES)) {
                    this.headerTable[1].set(this.headerTable[0].indexOf(EXPIRES), httpDateFormat.format(new Date(this.expirationTime)));
                } else {
                    this.headerTable[0].add(EXPIRES);
                    this.headerTable[1].add(httpDateFormat.format(new Date(this.expirationTime)));
                }
            }
        }
        return this.externalCacheEntry;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExternalCacheFragment)) {
            return false;
        }
        ExternalCacheFragment externalCacheFragment = (ExternalCacheFragment)object;
        return this.uri.equals(externalCacheFragment.uri);
    }

    public int hashCode() {
        if (this.uri == null) {
            return ExternalCacheFragment.class.hashCode();
        }
        return this.uri.hashCode();
    }

    static {
        httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        httpDateFormat.setTimeZone(timeZone);
    }
}

