/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.weaver.model.NestedWeavable;
import org.apache.commons.weaver.model.WeavableConstructor;
import org.apache.commons.weaver.model.WeavableField;
import org.apache.commons.weaver.model.WeavableMethod;
import org.apache.commons.weaver.model.WeavablePackage;
import org.apache.commons.weaver.utils.Args;

public class WeavableClass<T>
extends NestedWeavable<WeavableClass<T>, Class<T>, WeavablePackage, Package> {
    private final ConcurrentNavigableMap<String, WeavableField<T>> fields = new ConcurrentSkipListMap<String, WeavableField<T>>();
    private final ConcurrentNavigableMap<Constructor<T>, WeavableConstructor<T>> ctors = new ConcurrentSkipListMap<Constructor<T>, WeavableConstructor<T>>(new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> ctor1, Constructor<?> ctor2) {
            return Args.compare(ctor1.getParameterTypes(), ctor2.getParameterTypes());
        }
    });
    private final ConcurrentNavigableMap<Method, WeavableMethod<T>> methods = new ConcurrentSkipListMap<Method, WeavableMethod<T>>(new Comparator<Method>(){

        @Override
        public int compare(Method methd1, Method methd2) {
            int result = methd1.getName().compareTo(methd2.getName());
            return result == 0 ? Args.compare(methd1.getParameterTypes(), methd2.getParameterTypes()) : result;
        }
    });

    public WeavableClass(Class<T> target, WeavablePackage parent) {
        super(target, parent);
    }

    public WeavableField<T> getWeavable(Field fld) {
        String key = fld.getName();
        if (this.fields.containsKey(key)) {
            WeavableField result = (WeavableField)this.fields.get(key);
            return result;
        }
        WeavableField result = new WeavableField(fld, this);
        WeavableField faster = this.fields.putIfAbsent(key, result);
        return faster == null ? result : faster;
    }

    public WeavableMethod<T> getWeavable(Method methd) {
        if (this.methods.containsKey(methd)) {
            WeavableMethod result = (WeavableMethod)this.methods.get(methd);
            return result;
        }
        WeavableMethod result = new WeavableMethod(methd, this);
        WeavableMethod faster = this.methods.putIfAbsent(methd, result);
        return faster == null ? result : faster;
    }

    public WeavableConstructor<T> getWeavable(Constructor<T> ctor) {
        if (this.ctors.containsKey(ctor)) {
            WeavableConstructor result = (WeavableConstructor)this.ctors.get(ctor);
            return result;
        }
        WeavableConstructor<T> result = new WeavableConstructor<T>(ctor, this);
        WeavableConstructor<T> faster = this.ctors.putIfAbsent(ctor, result);
        return faster == null ? result : faster;
    }

    public Iterable<WeavableField<T>> getFields() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    public Iterable<WeavableConstructor<T>> getConstructors() {
        return Collections.unmodifiableCollection(this.ctors.values());
    }

    public Iterable<WeavableMethod<T>> getMethods() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    @Override
    protected int localCompareTo(WeavableClass<T> obj) {
        return ((Class)this.getTarget()).getName().compareTo(((Class)obj.getTarget()).getName());
    }
}

