/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.ChannelSelector;
import com.ibm.ws.tcpchannel.internal.NioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.NioTCPChannel;
import com.ibm.ws.tcpchannel.internal.SimpleSync;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;

public class NioTCPWriteRequestContextImpl
extends TCPWriteRequestContextImpl {
    private static final TraceComponent tc = Tr.register(NioTCPWriteRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    protected NioTCPWriteRequestContextImpl(TCPConnLink link) {
        super(link);
    }

    @Override
    public long processSyncWriteRequest(long numBytes, int timeout) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processSyncRequest(" + numBytes + "," + timeout + ")"), (Object[])new Object[0]);
        }
        long numUserBytesWritten = 0L;
        if (numBytes != 0L) {
            if (this.blockWait == null) {
                this.blockWait = new SimpleSync();
            }
            this.blockingIOError = null;
            this.blockedThread = true;
            VirtualConnection vc = this.writeInternal(numBytes, null, false, timeout);
            while (vc == null) {
                this.blockWait.simpleWait();
                if (this.blockingIOError != null) break;
                vc = ((NioTCPChannel)this.getTCPConnLink().getTCPChannel()).getWorkQueueManager().processWork(this, 1);
            }
            this.blockedThread = false;
            if (this.blockingIOError != null) {
                throw this.blockingIOError;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getIOCompleteAmount() -->" + String.valueOf(this.getIOCompleteAmount())), (Object[])new Object[0]);
            }
            numUserBytesWritten = this.getIOCompleteAmount();
        } else {
            WsByteBuffer[] buffers = this.getBuffers();
            NioSocketIOChannel channel = (NioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel();
            numUserBytesWritten = buffers.length == 1 ? (long)channel.write(buffers[0].getWrappedByteBufferNonSafe()) : channel.write(this.getByteBufferArray());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processSyncRequest", (Object)numUserBytesWritten);
        }
        return numUserBytesWritten;
    }

    @Override
    public VirtualConnection processAsyncWriteRequest() {
        return ((NioTCPChannel)this.getTCPConnLink().getTCPChannel()).getWorkQueueManager().processWork(this, 0);
    }

    @Override
    protected void immediateTimeout() {
        ChannelSelector sel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"immediateTimeout", (Object[])new Object[0]);
        }
        if (null != (sel = ((NioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).getChannelSelectorWrite())) {
            this.timeoutTime = System.currentTimeMillis() - 2000L;
            sel.resetTimeout(this.timeoutTime);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"No write selector, ignoring immediate timeout", (Object[])new Object[0]);
        }
    }
}

