/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClaimsImpl
implements Claims,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(ClaimsImpl.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private final Map<String, Object> claimsMap = Collections.synchronizedMap(new HashMap());

    @Override
    public Object put(String key, Object value) {
        return this.claimsMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.claimsMap.remove(key);
    }

    @Override
    @FFDCIgnore(value={NullPointerException.class})
    public void putAll(Map<? extends String, ? extends Object> m) {
        try {
            this.claimsMap.putAll(m);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        this.claimsMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.claimsMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.claimsMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.claimsMap.entrySet();
    }

    @Override
    public String getIssuer() {
        return (String)this.claimsMap.get("iss");
    }

    @Override
    public String getSubject() {
        return (String)this.claimsMap.get("sub");
    }

    @Override
    public List<String> getAudience() {
        List<String> audiences = null;
        Object obj = this.claimsMap.get("aud");
        if (obj instanceof String) {
            audiences = new ArrayList<String>();
            audiences.add((String)obj);
        } else if (obj instanceof List) {
            audiences = (List)obj;
        }
        return audiences;
    }

    @Override
    public long getExpiration() {
        Long exp = (Long)this.claimsMap.get("exp");
        if (exp != null) {
            return exp;
        }
        return -1L;
    }

    @Override
    public long getNotBefore() {
        Long nbf = (Long)this.claimsMap.get("nbf");
        if (nbf != null) {
            return nbf;
        }
        return -1L;
    }

    @Override
    public long getIssuedAt() {
        Long iat = (Long)this.claimsMap.get("iat");
        if (iat != null) {
            return iat;
        }
        return -1L;
    }

    @Override
    public String getJwtId() {
        return (String)this.claimsMap.get("jti");
    }

    @Override
    public String getAuthorizedParty() {
        return (String)this.claimsMap.get("azp");
    }

    @Override
    public <T> T getClaim(String claimName, Class<T> requiredType) {
        try {
            if (this.claimsMap.get(claimName) != null) {
                return (T)this.claimsMap.get(claimName);
            }
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.security.jwt.internal.ClaimsImpl", (String)"167", (Object)this, (Object[])new Object[]{claimName, requiredType});
        }
        return null;
    }

    @Override
    public Map<String, Object> getAllClaims() {
        return this.claimsMap;
    }

    @Override
    public String toJsonString() {
        return JwtUtils.toJson(this.claimsMap);
    }

    @Override
    public int size() {
        return this.claimsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.claimsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.claimsMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.claimsMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.claimsMap.get(key);
    }
}

