/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.stat.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.stat.CachePerf;
import com.ibm.ws.cache.stat.CachePerfFactory;
import com.ibm.ws.cache.stat.internal.CacheStatsModule;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(service={CachePerfFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class CacheStatsFactory
implements CachePerfFactory {
    private static TraceComponent tc = Tr.register(CacheStatsFactory.class, (String)"WebSphere Dynamic Cache Monitor", (String)"com.ibm.ws.cache.resources.dynacache");

    public CachePerf create(DCache cache) {
        String methodName = "create()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create()", (Object[])new Object[]{cache.getCacheName()});
        }
        CacheStatsModule cachePerf = null;
        if (StatsFactory.isPMIEnabled()) {
            try {
                cachePerf = new CacheStatsModule(cache.getCacheName(), cache.getSwapToDisk());
            }
            catch (StatsFactoryException e) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"create()", (Object)((Object)cachePerf));
        }
        return cachePerf;
    }
}

