/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService,
ExtendedHttpService {
    final Bundle bundle;
    final HttpServiceRuntimeImpl httpServiceRuntime;
    private boolean shutdown = false;

    public HttpServiceImpl(Bundle bundle, HttpServiceRuntimeImpl httpServiceRuntime) {
        this.bundle = bundle;
        this.httpServiceRuntime = httpServiceRuntime;
    }

    @Override
    public synchronized HttpContext createDefaultHttpContext() {
        this.checkShutdown();
        return new DefaultHttpContext();
    }

    @Override
    public synchronized void registerFilter(final String alias, final Filter filter, final Dictionary<String, String> initparams, HttpContext httpContext) throws ServletException {
        this.checkShutdown();
        final HttpContext finalHttpContext = httpContext == null ? this.createDefaultHttpContext() : httpContext;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ServletException {
                    HttpServiceImpl.this.httpServiceRuntime.registerHttpServiceFilter(HttpServiceImpl.this.bundle, alias, filter, initparams, finalHttpContext);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            HttpServiceImpl.unchecked(e.getException());
        }
    }

    @Override
    public synchronized void registerResources(final String alias, final String name, HttpContext httpContext) throws NamespaceException {
        this.checkShutdown();
        final HttpContext finalHttpContext = httpContext == null ? this.createDefaultHttpContext() : httpContext;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NamespaceException {
                    HttpServiceImpl.this.httpServiceRuntime.registerHttpServiceResources(HttpServiceImpl.this.bundle, alias, name, finalHttpContext);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            HttpServiceImpl.unchecked(e.getException());
        }
    }

    @Override
    public synchronized void registerServlet(final String alias, final Servlet servlet, final Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.checkShutdown();
        final HttpContext finalHttpContext = httpContext == null ? this.createDefaultHttpContext() : httpContext;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NamespaceException, ServletException {
                    HttpServiceImpl.this.httpServiceRuntime.registerHttpServiceServlet(HttpServiceImpl.this.bundle, alias, servlet, initparams, finalHttpContext);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            HttpServiceImpl.unchecked(e.getException());
        }
    }

    @Override
    public synchronized void unregister(String alias) {
        this.checkShutdown();
        this.httpServiceRuntime.unregisterHttpServiceAlias(this.bundle, alias);
    }

    @Override
    public synchronized void unregisterFilter(Filter filter) {
        this.checkShutdown();
        this.httpServiceRuntime.unregisterHttpServiceFilter(this.bundle, filter);
    }

    synchronized void shutdown() {
        this.httpServiceRuntime.unregisterHttpServiceObjects(this.bundle);
        this.shutdown = true;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Service instance is already shutdown");
        }
    }

    static <T> T unchecked(Exception exception) {
        return HttpServiceImpl.unchecked0(exception);
    }

    private static <T, E extends Exception> T unchecked0(Exception exception) throws E {
        throw exception;
    }

    class DefaultHttpContext
    implements HttpContext {
        DefaultHttpContext() {
        }

        @Override
        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return true;
        }

        @Override
        public URL getResource(String name) {
            if (name != null) {
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                return HttpServiceImpl.this.bundle.getEntry(name);
            }
            return null;
        }

        @Override
        public String getMimeType(String name) {
            return null;
        }
    }
}

