/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.whiteboard;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.whiteboard.customizer.SubsystemServletContextHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.subsystem.Subsystem;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SubsystemServletContextHelperFactory
implements ServiceFactory<ServletContextHelper> {
    private static final TraceComponent _tc = Tr.register(SubsystemServletContextHelperFactory.class);
    private static final String SHARED_CONSOLE_PATH = "/shared";
    private final BundleContext context;
    private final Subsystem subsystem;
    private final ServiceReference<Subsystem> subsystemRef;
    private final String whiteboardContextPath;
    private final String subsystemContextPath;
    private final SubsystemServletContextHelperFactory sharedConsoleHelper;
    private ServiceRegistration<ServletContextHelper> helperReg;
    private ServiceRegistration<SubsystemServletContextHelper> markerReg;
    static final long serialVersionUID = 5217693133514620621L;

    public SubsystemServletContextHelperFactory(BundleContext context, ServiceReference<Subsystem> subsystemRef, String whiteboardContextPath, String subsystemContextPath) {
        this.context = context;
        this.subsystemRef = subsystemRef;
        this.subsystem = (Subsystem)context.getService(this.subsystemRef);
        this.subsystemContextPath = subsystemContextPath;
        this.whiteboardContextPath = whiteboardContextPath;
        this.sharedConsoleHelper = "com.ibm.ws.esa.shared.bundle.subsystem".equals(this.subsystem.getSymbolicName()) ? new SubsystemServletContextHelperFactory(context, subsystemRef, whiteboardContextPath) : null;
    }

    private SubsystemServletContextHelperFactory(BundleContext context, ServiceReference<Subsystem> subsystemRef, String whiteboardContextPath) {
        this.context = context;
        this.subsystemRef = subsystemRef;
        this.subsystem = (Subsystem)context.getService(this.subsystemRef);
        this.subsystemContextPath = SHARED_CONSOLE_PATH;
        this.whiteboardContextPath = whiteboardContextPath;
        this.sharedConsoleHelper = null;
    }

    public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
        ServletContextHelper helper = new ServletContextHelper(bundle){
            static final long serialVersionUID = -5682586130962145305L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        return helper;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
    }

    void register() {
        String fullContextPath;
        Hashtable<String, String> contextHelperProps = new Hashtable<String, String>();
        ((Dictionary)contextHelperProps).put("osgi.http.whiteboard.context.name", "subsystemID." + this.subsystem.getSubsystemId());
        ((Dictionary)contextHelperProps).put("osgi.http.whiteboard.context.path", this.subsystemContextPath);
        this.helperReg = this.context.registerService(ServletContextHelper.class.getName(), (Object)this, contextHelperProps);
        String string = fullContextPath = "/".equals(this.whiteboardContextPath) ? this.subsystemContextPath : this.whiteboardContextPath + this.subsystemContextPath;
        if (fullContextPath.length() > 1 && fullContextPath.endsWith("/")) {
            fullContextPath = fullContextPath.substring(0, fullContextPath.length() - 1);
        }
        Tr.audit((TraceComponent)_tc, (String)"context.root.added", (Object[])new Object[]{fullContextPath});
        if (this.sharedConsoleHelper != null) {
            this.sharedConsoleHelper.register();
        } else {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("com.ibm.ws.http.whiteboard.context.for.subsystem", this.subsystemRef);
            ((Dictionary)props).put("com.ibm.ws.http.whiteboard.subsystem.context.path", fullContextPath);
            this.markerReg = this.context.registerService(SubsystemServletContextHelper.class, (Object)new SubsystemServletContextHelper(), props);
        }
    }

    void unregister() {
        String fullContextPath = null;
        if (this.markerReg != null) {
            fullContextPath = (String)this.markerReg.getReference().getProperty("com.ibm.ws.http.whiteboard.subsystem.context.path");
            this.markerReg.unregister();
        }
        if (this.sharedConsoleHelper != null) {
            this.sharedConsoleHelper.unregister();
        }
        if (this.helperReg != null) {
            this.helperReg.unregister();
        }
        if (fullContextPath != null) {
            Tr.audit((TraceComponent)_tc, (String)"context.root.removed", (Object[])new Object[]{fullContextPath});
        }
        this.context.ungetService(this.subsystemRef);
    }

    Bundle getBundle(long id) {
        return this.subsystem.getBundleContext().getBundle(id);
    }

    Object getProperty(String key) {
        return this.helperReg.getReference().getProperty(key);
    }

    Subsystem getSubsystem() {
        return this.subsystem;
    }

    public SubsystemServletContextHelperFactory getSharedConsoleHelper() {
        return this.sharedConsoleHelper;
    }
}

