/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.certificateutil.keytool;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class KeytoolCommand {
    private static final Class<?> CLASS_NAME = KeytoolCommand.class;
    private static final Logger logger = Logger.getLogger(CLASS_NAME.getCanonicalName());
    private static final int BUFFER_SIZE = 4096;
    private final ArrayList<String> cmd = new ArrayList();
    private String toString = null;

    KeytoolCommand(String filePath, String password, int validity, String subjectDN, int keySize, String keyType, String sigAlg) {
        this.cmd.add(this.getAbsoluteKeytoolPath());
        this.cmd.add("-genkey");
        this.cmd.add("-keystore");
        this.cmd.add(filePath);
        this.cmd.add("-storepass");
        this.cmd.add(password);
        this.cmd.add("-keypass");
        this.cmd.add(password);
        this.cmd.add("-validity");
        this.cmd.add(Integer.toString(validity));
        this.cmd.add("-dname");
        this.cmd.add(subjectDN);
        this.cmd.add("-alias");
        this.cmd.add("default");
        this.cmd.add("-sigalg");
        this.cmd.add(sigAlg);
        this.cmd.add("-keyalg");
        this.cmd.add(keyType);
        this.cmd.add("-keySize");
        this.cmd.add(Integer.toString(keySize));
    }

    String getAbsoluteKeytoolPath() {
        String javaHome = System.getProperty("java.home");
        String keytool = javaHome + "/bin/keytool";
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            keytool = keytool + ".exe";
        }
        return keytool;
    }

    List<String> getCommandArgs() {
        return this.cmd;
    }

    void executeCommand() throws CertificateException {
        String exceptionMessage;
        Exception cause = null;
        try {
            int exitCode;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Executing keytool command: " + this.toString());
            }
            Process proc = Runtime.getRuntime().exec(this.cmd.toArray(new String[this.cmd.size()]));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Waiting for keytool command process to complete...");
            }
            if ((exitCode = proc.waitFor()) == 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("keytool command process completed successfully");
                }
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("keytool command process failed to complete successfully (exit code: " + exitCode + ")");
            }
            exceptionMessage = this.getProcErrorOutput(proc);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("keytool command process execution resulted in IOException: " + e.getMessage());
            }
            exceptionMessage = e.getLocalizedMessage();
            cause = e;
        }
        catch (InterruptedException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("InterruptedException while waiting for keytool command process result: " + e.getMessage());
            }
            exceptionMessage = e.getLocalizedMessage();
            cause = e;
        }
        if (cause != null) {
            throw new CertificateException(exceptionMessage, cause);
        }
        throw new CertificateException(exceptionMessage);
    }

    String getProcErrorOutput(Process proc) throws IOException {
        int read;
        StringBuffer output = new StringBuffer();
        InputStream procIn = proc.getInputStream();
        do {
            byte[] buffer = new byte[4096];
            read = procIn.read(buffer);
            String s = new String(buffer);
            output.append(s);
        } while (read == 4096);
        return output.toString();
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer buf = new StringBuffer();
            Iterator<String> itr = this.cmd.iterator();
            while (itr.hasNext()) {
                String str = itr.next();
                buf.append(str);
                if (itr.hasNext()) {
                    buf.append(" ");
                }
                if (!str.equals("-storepass") && !str.equals("-keypass")) continue;
                buf.append("*** ");
                itr.next();
            }
            this.toString = buf.toString();
        }
        return this.toString;
    }
}

