/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.osgi.internal.naming;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.naming.JavaColonNamingHelper;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.container.service.naming.RemoteJavaColonNamingHelper;
import com.ibm.ws.container.service.naming.RemoteObjectInstance;
import com.ibm.ws.container.service.naming.RemoteObjectInstanceFactory;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.injectionengine.InternalInjectionEngine;
import com.ibm.ws.injectionengine.osgi.internal.IndirectReference;
import com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl;
import com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionScopeData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.serialization.SerializationContext;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Collections;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Trivial
@Component(service={JavaColonNamingHelper.class, RemoteJavaColonNamingHelper.class})
public class InjectionJavaColonHelper
implements JavaColonNamingHelper,
RemoteJavaColonNamingHelper {
    private static final TraceComponent tc = Tr.register(InjectionJavaColonHelper.class);
    private OSGiInjectionEngineImpl injectionEngine;
    private SerializationService serializationService;
    private RemoteObjectInstanceFactory roiFactory;

    @org.osgi.service.component.annotations.Reference
    protected void setInjectionEngine(OSGiInjectionEngineImpl injectionEngine) {
        this.injectionEngine = injectionEngine;
    }

    protected void unsetInjectionEngine(OSGiInjectionEngineImpl injectionEngine) {
    }

    @org.osgi.service.component.annotations.Reference
    protected void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    protected void unssetSerializationService(SerializationService serializationService) {
        if (this.serializationService == serializationService) {
            this.serializationService = null;
        }
    }

    @org.osgi.service.component.annotations.Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRemoteObjectInstanceFactory(RemoteObjectInstanceFactory roiFactory) {
        this.roiFactory = roiFactory;
    }

    protected void unsetRemoteObjectInstanceFactory(RemoteObjectInstanceFactory roiFactory) {
        this.roiFactory = null;
    }

    public Object getObjectInstance(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance (" + namespace + ", " + name + ")"), (Object[])new Object[0]);
        }
        Object instance = null;
        InjectionBinding<?> binding = this.getInjectionBinding(namespace, name);
        if (binding != null) {
            try {
                instance = binding.getInjectionObject();
            }
            catch (Exception ex) {
                NamingException nex = this.newCannotInstantiateObjectException(namespace.prefix() + name, ex);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + nex.toString(true)));
                }
                throw nex;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + Util.identity((Object)instance)));
        }
        return instance;
    }

    private InjectionBinding<?> getInjectionBinding(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        OSGiInjectionScopeData isd = this.getInjectionScopeData(namespace);
        InjectionBinding<?> binding = isd != null ? isd.getInjectionBinding(namespace, name) : null;
        return binding;
    }

    protected OSGiInjectionScopeData getInjectionScopeData(NamingConstants.JavaColonNamespace namespace) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        OSGiInjectionScopeData isd = null;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd == null) {
            NamingException nex = new NamingException(Tr.formatMessage((TraceComponent)tc, (String)"JNDI_NON_JEE_THREAD_CWNEN1000E", (Object[])new Object[0]));
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getInjectionScopeData : (no CMD) : " + nex.toString(true)), (Object[])new Object[0]);
            }
            throw nex;
        }
        isd = this.injectionEngine.getInjectionScopeData(cmd, namespace);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(cmd + " -> " + isd), (Object[])new Object[0]);
        }
        return isd;
    }

    private NamingException newCannotInstantiateObjectException(String name, Exception cause) {
        String msgTxt = Tr.formatMessage((TraceComponent)tc, (String)"JNDI_CANNOT_INSTANTIATE_OBJECT_CWNEN1001E", (Object[])new Object[]{name});
        NamingException nex = new NamingException(msgTxt);
        nex.initCause(cause);
        return nex;
    }

    public boolean hasObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        OSGiInjectionScopeData isd;
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("hasObjectWithPrefix (" + namespace + ", " + name + ")"), (Object[])new Object[0]);
        }
        boolean bl = result = (isd = this.getInjectionScopeData(namespace)) != null && isd.hasObjectWithPrefix(namespace, name);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hasObjectWithPrefix", (Object)result);
        }
        return result;
    }

    public Collection<? extends NameClassPair> listInstances(NamingConstants.JavaColonNamespace namespace, String nameInContext) throws NamingException {
        OSGiInjectionScopeData isd;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listInstances (" + namespace + ", " + nameInContext + ")"), (Object[])new Object[0]);
        }
        if ((isd = this.getInjectionScopeData(namespace)) != null) {
            Collection<? extends NameClassPair> retVal = isd.listInstances(namespace, nameInContext);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("listInstances: " + retVal));
            }
            return retVal;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listInstances : empty (no ISD)");
        }
        return Collections.emptyList();
    }

    public RemoteObjectInstance getRemoteObjectInstance(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        Object bindingObject;
        RemoteObjectInstance roi = null;
        InjectionBinding<?> binding = this.getInjectionBinding(namespace, name);
        if (binding != null && (bindingObject = binding.getRemoteObject()) != null) {
            if (bindingObject instanceof IndirectReference) {
                bindingObject = this.resolveIndirectReferences(binding, (IndirectReference)bindingObject, 0);
            }
            if (bindingObject instanceof Reference) {
                SerializationContext sc = this.serializationService.createSerializationContext();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = null;
                try {
                    oos = sc.createObjectOutputStream((OutputStream)baos);
                    oos.writeObject(bindingObject);
                }
                catch (IOException ex) {
                    NamingException ne = new NamingException("Unable to serialize naming reference: " + bindingObject);
                    ne.initCause(ex);
                    throw ne;
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                roi = this.roiFactory.create(baos.toByteArray());
            } else {
                roi = bindingObject instanceof Remote ? this.roiFactory.create((Remote)bindingObject, binding.getInjectionClassTypeName()) : this.roiFactory.create(bindingObject);
            }
        }
        return roi;
    }

    @FFDCIgnore(value={InjectionException.class})
    private Object resolveIndirectReferences(InjectionBinding<?> binding, IndirectReference ref, int hopCounter) throws NamingException {
        if (hopCounter > 5) {
            throw new NamingException("Too many indirect references");
        }
        Object resolvedObject = ref;
        InternalInjectionEngine ie = (InternalInjectionEngine)InjectionEngineAccessor.getInstance();
        String factoryClassName = ref.getFactoryClassName();
        try {
            ObjectFactory factory = ie.getObjectFactory(factoryClassName, null);
            resolvedObject = factory.getObjectInstance(ref, null, null, null);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        if (resolvedObject instanceof IndirectReference) {
            resolvedObject = this.resolveIndirectReferences(binding, (IndirectReference)resolvedObject, hopCounter + 1);
        }
        return resolvedObject;
    }

    public boolean hasRemoteObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        return this.hasObjectWithPrefix(namespace, name);
    }

    public Collection<? extends NameClassPair> listRemoteInstances(NamingConstants.JavaColonNamespace namespace, String nameInContext) throws NamingException {
        return this.listInstances(namespace, nameInContext);
    }
}

