/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.annotation.scanning;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.eba.jpa.annotation.scanning.AnnotationSource;
import com.ibm.ws.eba.jpa.annotation.scanning.BlueprintAnnotations;
import com.ibm.ws.eba.jpa.annotation.scanning.JPAAnnotation;
import com.ibm.ws.eba.jpa.annotation.scanning.PersistenceContextAnnotation;
import com.ibm.ws.eba.jpa.annotation.scanning.PersistenceUnitAnnotation;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Adaptable;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.FieldInfo;
import com.ibm.wsspi.anno.info.Info;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.MethodInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceProperty;
import javax.persistence.PersistenceUnit;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JpAnnotationSource
implements AnnotationSource {
    protected Container container;
    protected ClassSource_Aggregate moduleClassSource;
    protected AnnotationTargets_Targets moduleAnnotationTargets;
    protected InfoStore moduleInfoStore;
    protected Bundle bundle = null;
    private Map<String, List<FieldAnnotationTarget>> persistenceUnitFieldAnnotations = new HashMap<String, List<FieldAnnotationTarget>>();
    private Map<String, List<FieldAnnotationTarget>> persistenceContextFieldAnnotations = new HashMap<String, List<FieldAnnotationTarget>>();
    private Map<String, List<MethodAnnotationTarget>> persistenceUnitMethodAnnotations = new HashMap<String, List<MethodAnnotationTarget>>();
    private Map<String, List<MethodAnnotationTarget>> persistenceContextMethodAnnotations = new HashMap<String, List<MethodAnnotationTarget>>();
    private final InfoStore useInfoStore;
    static final long serialVersionUID = 4143386712455825223L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JpAnnotationSource(Container container, Bundle bundleContainer) {
        this.bundle = bundleContainer;
        this.container = container;
        this.moduleClassSource = null;
        this.moduleAnnotationTargets = null;
        this.moduleInfoStore = null;
        this.useInfoStore = this.getInfoStore();
        this.persistenceUnitFieldAnnotations = this.getFieldTargets(PersistenceUnit.class.getName());
        this.persistenceUnitMethodAnnotations = this.getMethodTargets(PersistenceUnit.class.getName());
        this.persistenceContextFieldAnnotations = this.getFieldTargets(PersistenceContext.class.getName());
        this.persistenceContextMethodAnnotations = this.getMethodTargets(PersistenceContext.class.getName());
    }

    public Adaptable getDeployedModule() {
        return this.container;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationTargets_Targets getAnnotationTargets() {
        if (this.moduleAnnotationTargets == null) {
            try {
                BlueprintAnnotations anno = (BlueprintAnnotations)this.container.adapt(BlueprintAnnotations.class);
                anno.setBundle(this.bundle);
                this.moduleAnnotationTargets = anno.getWebModuleAnnotationTargets();
            }
            catch (UnableToAdaptException anno) {
                void e;
                FFDCFilter.processException((Throwable)anno, (String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource", (String)"139", (Object)this, (Object[])new Object[0]);
                e.getMessage();
                return null;
            }
        }
        return this.moduleAnnotationTargets;
    }

    /*
     * WARNING - void declaration
     */
    public InfoStore getInfoStore() {
        if (this.moduleInfoStore == null) {
            try {
                BlueprintAnnotations anno = (BlueprintAnnotations)this.container.adapt(BlueprintAnnotations.class);
                anno.setBundle(this.bundle);
                this.moduleInfoStore = anno.getWebModuleInfoStore();
            }
            catch (UnableToAdaptException anno) {
                void e;
                FFDCFilter.processException((Throwable)anno, (String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource", (String)"153", (Object)this, (Object[])new Object[0]);
                e.getMessage();
                return null;
            }
        }
        return this.moduleInfoStore;
    }

    public List<ClassAnnotationTarget> getClassTargets(String targetAnnotationClassName) {
        ArrayList<ClassAnnotationTarget> classAnnotationTargets = new ArrayList<ClassAnnotationTarget>();
        AnnotationTargets_Targets useAnnotationTargets = this.getAnnotationTargets();
        Set classTargetNames = useAnnotationTargets.getAnnotatedClasses(targetAnnotationClassName, AnnotationTargets_Targets.POLICY_SEED);
        for (String annotatedClassName : classTargetNames) {
            ClassInfo annotatedClassInfo = this.useInfoStore.getDelayableClassInfo(annotatedClassName);
            AnnotationInfo annotationInfo = annotatedClassInfo.getDeclaredAnnotation(targetAnnotationClassName);
            ClassAnnotationTarget classAnnotationTarget = new ClassAnnotationTarget(annotatedClassInfo, annotationInfo);
            classAnnotationTargets.add(classAnnotationTarget);
        }
        return classAnnotationTargets;
    }

    public List<FieldAnnotationTarget> getDeclaredFieldTargets(String targetAnnotationClassName) {
        ArrayList<FieldAnnotationTarget> fieldAnnotationTargets = new ArrayList<FieldAnnotationTarget>();
        AnnotationTargets_Targets useAnnotationTargets = this.getAnnotationTargets();
        Set classTargetNames = useAnnotationTargets.getClassesWithFieldAnnotation(targetAnnotationClassName, AnnotationTargets_Targets.POLICY_SEED);
        for (String annotatedClassName : classTargetNames) {
            ClassInfo annotatedClassInfo = this.useInfoStore.getDelayableClassInfo(annotatedClassName);
            for (FieldInfo fieldInfo : annotatedClassInfo.getDeclaredFields()) {
                AnnotationInfo annotationInfo = fieldInfo.getDeclaredAnnotation(targetAnnotationClassName);
                if (annotationInfo == null) continue;
                FieldAnnotationTarget fieldAnnotationTarget = new FieldAnnotationTarget(annotatedClassInfo, fieldInfo, annotationInfo);
                fieldAnnotationTargets.add(fieldAnnotationTarget);
            }
        }
        return fieldAnnotationTargets;
    }

    public Map<String, List<FieldAnnotationTarget>> getFieldTargets(String targetAnnotationClassName) {
        HashMap<String, List<FieldAnnotationTarget>> allFieldAnnotations = new HashMap<String, List<FieldAnnotationTarget>>();
        AnnotationTargets_Targets useAnnotationTargets = this.getAnnotationTargets();
        Set classTargetNames = useAnnotationTargets.getClassesWithFieldAnnotation(targetAnnotationClassName, AnnotationTargets_Targets.POLICY_SEED);
        for (String annotatedClassName : classTargetNames) {
            ArrayList<FieldAnnotationTarget> fieldAnnotationTargetsPerClass = new ArrayList<FieldAnnotationTarget>();
            ClassInfo annotatedClassInfo = this.useInfoStore.getDelayableClassInfo(annotatedClassName);
            for (FieldInfo fieldInfo : annotatedClassInfo.getDeclaredFields()) {
                AnnotationInfo annotationInfo = fieldInfo.getAnnotation(targetAnnotationClassName);
                if (annotationInfo == null) continue;
                FieldAnnotationTarget fieldAnnotationTarget = new FieldAnnotationTarget(annotatedClassInfo, fieldInfo, annotationInfo);
                fieldAnnotationTargetsPerClass.add(fieldAnnotationTarget);
            }
            allFieldAnnotations.put(annotatedClassName, fieldAnnotationTargetsPerClass);
        }
        return allFieldAnnotations;
    }

    public List<MethodAnnotationTarget> getDeclaredMethodTargets(String targetAnnotationClassName) {
        ArrayList<MethodAnnotationTarget> methodAnnotationTargets = new ArrayList<MethodAnnotationTarget>();
        AnnotationTargets_Targets useAnnotationTargets = this.getAnnotationTargets();
        Set classTargetNames = useAnnotationTargets.getClassesWithMethodAnnotation(targetAnnotationClassName, AnnotationTargets_Targets.POLICY_SEED);
        for (String annotatedClassName : classTargetNames) {
            ClassInfo annotatedClassInfo = this.useInfoStore.getDelayableClassInfo(annotatedClassName);
            for (MethodInfo methodInfo : annotatedClassInfo.getDeclaredMethods()) {
                AnnotationInfo annotationInfo = methodInfo.getDeclaredAnnotation(targetAnnotationClassName);
                if (annotationInfo == null) continue;
                MethodAnnotationTarget methodAnnotationTarget = new MethodAnnotationTarget(annotatedClassInfo, methodInfo, annotationInfo);
                methodAnnotationTargets.add(methodAnnotationTarget);
            }
        }
        return methodAnnotationTargets;
    }

    public Map<String, List<MethodAnnotationTarget>> getMethodTargets(String targetAnnotationClassName) {
        HashMap<String, List<MethodAnnotationTarget>> allMethodAnnotations = new HashMap<String, List<MethodAnnotationTarget>>();
        AnnotationTargets_Targets useAnnotationTargets = this.getAnnotationTargets();
        Set classTargetNames = useAnnotationTargets.getClassesWithMethodAnnotation(targetAnnotationClassName, AnnotationTargets_Targets.POLICY_SEED);
        for (String annotatedClassName : classTargetNames) {
            ClassInfo annotatedClassInfo = this.useInfoStore.getDelayableClassInfo(annotatedClassName);
            ArrayList<MethodAnnotationTarget> methodAnnotationTargetsPerClass = new ArrayList<MethodAnnotationTarget>();
            for (MethodInfo methodInfo : annotatedClassInfo.getDeclaredMethods()) {
                AnnotationInfo annotationInfo = methodInfo.getAnnotation(targetAnnotationClassName);
                if (annotationInfo == null) continue;
                MethodAnnotationTarget methodAnnotationTarget = new MethodAnnotationTarget(annotatedClassInfo, methodInfo, annotationInfo);
                methodAnnotationTargetsPerClass.add(methodAnnotationTarget);
            }
            allMethodAnnotations.put(annotatedClassName, methodAnnotationTargetsPerClass);
        }
        return allMethodAnnotations;
    }

    @Override
    public Collection<JPAAnnotation> getAnnotations(String className) {
        ArrayList<JPAAnnotation> result = new ArrayList<JPAAnnotation>();
        AnnotationTargets_Targets targets = this.getAnnotationTargets();
        while (className != null) {
            if (this.persistenceUnitFieldAnnotations.containsKey(className)) {
                for (FieldAnnotationTarget f : this.persistenceUnitFieldAnnotations.get(className)) {
                    result.add(this.convertPersistenceUnitAnnotation((Info)f.targetFieldInfo));
                }
            }
            if (this.persistenceContextFieldAnnotations.containsKey(className)) {
                for (FieldAnnotationTarget f : this.persistenceContextFieldAnnotations.get(className)) {
                    result.add(this.convertPersistenceContextAnnotation((Info)f.targetFieldInfo));
                }
            }
            if (this.persistenceUnitMethodAnnotations.containsKey(className)) {
                for (MethodAnnotationTarget m : this.persistenceUnitMethodAnnotations.get(className)) {
                    result.add(this.convertPersistenceUnitAnnotation((Info)m.targetMethodInfo));
                }
            }
            if (this.persistenceContextMethodAnnotations.containsKey(className)) {
                for (MethodAnnotationTarget m : this.persistenceContextMethodAnnotations.get(className)) {
                    result.add(this.convertPersistenceContextAnnotation((Info)m.targetMethodInfo));
                }
            }
            className = targets.getSuperclassName(className);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private PersistenceUnitAnnotation convertPersistenceUnitAnnotation(Info info) {
        AnnotationInfo anInfo = null;
        AnnotationValue name = null;
        AnnotationValue unitName = null;
        try {
            anInfo = info.getAnnotation(PersistenceUnit.class);
            name = anInfo.getCachedAnnotationValue("name");
            unitName = anInfo.getCachedAnnotationValue("unitName");
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource", (String)"412", (Object)this, (Object[])new Object[]{info});
            e.printStackTrace(System.out);
        }
        return new PersistenceUnitAnnotation(name != null ? name.getStringValue() : null, unitName != null ? unitName.getStringValue() : null, info instanceof MethodInfo ? JPAAnnotation.Target.Method : JPAAnnotation.Target.Field, this.getPropertyName(info));
    }

    /*
     * WARNING - void declaration
     */
    private PersistenceContextAnnotation convertPersistenceContextAnnotation(Info info) {
        AnnotationValue context = null;
        AnnotationInfo anInfo = null;
        AnnotationValue name = null;
        AnnotationValue unitName = null;
        try {
            anInfo = info.getAnnotation(PersistenceContext.class);
            name = anInfo.getCachedAnnotationValue("name");
            unitName = anInfo.getCachedAnnotationValue("unitName");
            context = anInfo.getCachedAnnotationValue("context");
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource", (String)"437", (Object)this, (Object[])new Object[]{info});
            e.printStackTrace(System.out);
        }
        PersistenceContextAnnotation.ContextType contextType = PersistenceContextAnnotation.ContextType.TRANSACTION;
        if (context != null && context.getStringValue().equals("EXTENDED")) {
            contextType = PersistenceContextAnnotation.ContextType.EXTENDED;
        }
        AnnotationValue properties = anInfo.getCachedAnnotationValue("properties");
        HashMap<String, String> props = new HashMap<String, String>();
        if (properties != null) {
            for (AnnotationValue v : properties.getArrayValue()) {
                PersistenceProperty p = (PersistenceProperty)v.getObjectValue();
                props.put(p.name(), p.value());
            }
        }
        return new PersistenceContextAnnotation(name != null ? name.getStringValue() : null, unitName != null ? unitName.getStringValue() : null, info instanceof MethodInfo ? JPAAnnotation.Target.Method : JPAAnnotation.Target.Field, this.getPropertyName(info), contextType, props);
    }

    private String getPropertyName(Info info) {
        if (info instanceof MethodInfo) {
            String name = info.getName();
            if (name.startsWith("get") || name.startsWith("set")) {
                if (Character.isUpperCase((name = name.substring(3)).charAt(0)) && (name.length() < 2 || !Character.isUpperCase(name.charAt(1)))) {
                    name = Character.toString(Character.toLowerCase(name.charAt(0))) + name.substring(1);
                }
                return name;
            }
            return name;
        }
        return info.getName();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JpAnnotationSource.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class MethodAnnotationTarget {
        public final ClassInfo targetClassInfo;
        public final MethodInfo targetMethodInfo;
        public final AnnotationInfo targetAnnotationInfo;
        static final long serialVersionUID = -1966277689778809768L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MethodAnnotationTarget(ClassInfo targetClassInfo, MethodInfo targetMethodInfo, AnnotationInfo targetAnnotationInfo) {
            this.targetClassInfo = targetClassInfo;
            this.targetMethodInfo = targetMethodInfo;
            this.targetAnnotationInfo = targetAnnotationInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MethodAnnotationTarget.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class FieldAnnotationTarget {
        public final ClassInfo targetClassInfo;
        public final FieldInfo targetFieldInfo;
        public final AnnotationInfo targetAnnotationInfo;
        static final long serialVersionUID = 8061559271760855279L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FieldAnnotationTarget(ClassInfo targetClassInfo, FieldInfo targetFieldInfo, AnnotationInfo targetAnnotationInfo) {
            this.targetClassInfo = targetClassInfo;
            this.targetFieldInfo = targetFieldInfo;
            this.targetAnnotationInfo = targetAnnotationInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FieldAnnotationTarget.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ClassAnnotationTarget {
        public final ClassInfo targetClassInfo;
        public final AnnotationInfo targetAnnotationInfo;
        static final long serialVersionUID = -4421661017441598176L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassAnnotationTarget(ClassInfo targetClassInfo, AnnotationInfo targetAnnotationInfo) {
            this.targetClassInfo = targetClassInfo;
            this.targetAnnotationInfo = targetAnnotationInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClassAnnotationTarget.class);
        }
    }
}

