/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.annotation.scanning;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.eba.blueprint.transform.BlueprintBundle;
import com.ibm.ws.eba.blueprint.transform.BlueprintTransformer;
import com.ibm.ws.eba.jpa.annotation.scanning.JpAnnotationSource;
import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintAnnotationEnhancer;
import com.ibm.ws.eba.jpa.blueprint.xml.JPAAnnotationHandlerException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BlueprintTransformerImpl
implements BlueprintTransformer {
    private static final String BUNDLE_ANNOTATION_HEADER = "Bundle-Scan-Annotations";
    private final AtomicReference<ArtifactContainerFactory> containerFactory = new AtomicReference();
    private final AtomicReference<AdaptableModuleFactory> adaptableModuleFactory = new AtomicReference();
    static final long serialVersionUID = -3734110169402811931L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public void transformBlueprintBundle(BlueprintBundle bpBundle) throws Exception {
        Bundle bundle = bpBundle.getBundle();
        if (this.isBundleAnnotationScanningEnabled(bundle)) {
            File cacheDir = bundle.getDataFile("cache");
            if (!FileUtils.ensureDirExists((File)cacheDir)) {
                return;
            }
            File cacheDirAdapt = bundle.getDataFile("cacheAdapt");
            if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
                return;
            }
            File cacheDirOverlay = bundle.getDataFile("cacheOverlay");
            if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
                return;
            }
            ArtifactContainer artifactContainer = this.containerFactory.get().getContainer(cacheDir, (Object)bundle);
            Container bundleContainer = this.adaptableModuleFactory.get().getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
            try {
                JpAnnotationSource source = new JpAnnotationSource(bundleContainer, bundle);
                BluePrintAnnotationEnhancer decorator = new BluePrintAnnotationEnhancer(source);
                decorator.enhanceAll(bpBundle.getXmlFiles());
            }
            catch (JPAAnnotationHandlerException source) {
                FFDCFilter.processException((Throwable)source, (String)"com.ibm.ws.eba.jpa.annotation.scanning.BlueprintTransformerImpl", (String)"66", (Object)this, (Object[])new Object[]{bpBundle});
            }
        }
    }

    private boolean isBundleAnnotationScanningEnabled(Bundle bundle) {
        String header;
        boolean result = true;
        if (bundle.getHeaders().get("Fragment-Host") != null) {
            result = false;
        }
        if ((header = (String)bundle.getHeaders().get(BUNDLE_ANNOTATION_HEADER)) != null) {
            header = header.toLowerCase();
        }
        if (header != null && (header.equals("false") || header.equals("no") || header.equals("disabled"))) {
            result = false;
        }
        return result;
    }

    public void setContainerFactory(ArtifactContainerFactory ref) {
        this.containerFactory.set(ref);
    }

    public void unsetContainerFactory(ArtifactContainerFactory ref) {
        this.containerFactory.lazySet(null);
    }

    public void setAdaptableModuleFactory(AdaptableModuleFactory ref) {
        this.adaptableModuleFactory.set(ref);
    }

    public void unsetAdaptableModuleFactory(AdaptableModuleFactory ref) {
        this.adaptableModuleFactory.lazySet(null);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BlueprintTransformerImpl.class);
    }
}

