/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.Serializable;

public final class ConnectorProperty
implements Serializable {
    private static final long serialVersionUID = -842064029887347417L;
    private static final TraceComponent tc = Tr.register(ConnectorProperty.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private final String name;
    private final String type;
    private Object value;
    private final Boolean ignore;
    private final Boolean supportsDynamicUpdates;
    private final Boolean confidential;

    public ConnectorProperty(String name, String type, String value) {
        this(name, type, value, null, null, null);
    }

    public ConnectorProperty(String name, String type, String value, String ignore, String supportsDynamicUpdates, String confidential) {
        this.name = name;
        this.type = type;
        this.setValue(value);
        this.ignore = Boolean.valueOf(ignore);
        this.supportsDynamicUpdates = Boolean.valueOf(supportsDynamicUpdates);
        this.confidential = Boolean.valueOf(confidential);
    }

    String getName() {
        return this.name;
    }

    String getType() {
        return this.type;
    }

    Boolean getIgnore() {
        return this.ignore;
    }

    Boolean getSupportsDynamicUpdates() {
        return this.supportsDynamicUpdates;
    }

    Boolean getConfidential() {
        return this.confidential;
    }

    Object getValue() {
        return this.value;
    }

    private void setValue(Object newValue) {
        try {
            this.value = this.type == null ? newValue : (this.type.equals("java.lang.String") ? newValue : (this.type.equals("java.lang.Boolean") ? Boolean.valueOf((String)newValue) : (this.type.equals("java.lang.Integer") ? new Integer((String)newValue) : (this.type.equals("java.lang.Double") ? new Double((String)newValue) : (this.type.equals("java.lang.Byte") ? new Byte((String)newValue) : (this.type.equals("java.lang.Short") ? new Short((String)newValue) : (this.type.equals("java.lang.Long") ? new Long((String)newValue) : (this.type.equals("java.lang.Float") ? new Float((String)newValue) : (this.type.equals("java.lang.Character") ? Character.valueOf(((String)newValue).charAt(0)) : newValue)))))))));
        }
        catch (NumberFormatException nfe) {
            Tr.warning((TraceComponent)tc, (String)"INCOMPATIBLE_PROPERTY_TYPE_J2CA0207", (Object[])new Object[]{this.name, this.type, newValue});
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        String nl = ConnectorProperties.nl;
        buf.append("[Deployed Resource Adapter Property]");
        buf.append(nl);
        buf.append("\tName:  ");
        buf.append(this.name);
        buf.append("\tType:  ");
        buf.append(this.type);
        buf.append("\tValue: ");
        buf.append(this.value.toString());
        buf.append("\tIgnore: ");
        buf.append(this.ignore.toString());
        buf.append("\tSupports-dymnamic-updates: ");
        buf.append(this.supportsDynamicUpdates.toString());
        buf.append("\tConfidential: ");
        buf.append(this.confidential.toString());
        buf.append(nl);
        return buf.toString();
    }
}

