/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;

public final class ConnectorProperties
extends Vector<Object>
implements Serializable {
    private static final long serialVersionUID = -248509787807561932L;
    private static final TraceComponent tc = Tr.register(ConnectorProperties.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    public static final String nl = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    @Override
    public boolean add(Object o) {
        ConnectorProperty connectorPropertyToAdd = (ConnectorProperty)o;
        String nameToAdd = connectorPropertyToAdd.getName();
        ConnectorProperty connectorProperty = null;
        String name = null;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            String value;
            connectorProperty = (ConnectorProperty)e.nextElement();
            name = connectorProperty.getName();
            if (!name.equals(nameToAdd)) continue;
            if (tc.isDebugEnabled() && !(value = (String)connectorPropertyToAdd.getValue()).equals("")) {
                if (name.equals("UserName") || name.equals("Password")) {
                    Tr.debug((TraceComponent)tc, (String)"DUPLICATE_USERNAME_PASSWORD_CONNECTOR_PROPERTY_J2CA0103", (Object[])new Object[]{(ConnectorProperty)o});
                } else {
                    Tr.warning((TraceComponent)tc, (String)"DUPLICATE_CONNECTOR_PROPERTY_J2CA0308", (Object[])new Object[]{(ConnectorProperty)o});
                }
            }
            return true;
        }
        return super.add(o);
    }

    public boolean findConnectorPropertyBoolean(String desiredPropertyName, boolean defaultValue) {
        boolean retVal = defaultValue;
        String name = null;
        String value = null;
        Boolean booleanValue = null;
        ConnectorProperty property = null;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            property = (ConnectorProperty)e.nextElement();
            name = property.getName();
            if (!name.equals(desiredPropertyName)) continue;
            try {
                value = (String)property.getValue();
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                    booleanValue = Boolean.valueOf(value);
                }
            }
            catch (ClassCastException cce) {
                booleanValue = (Boolean)property.getValue();
            }
            if (booleanValue != null) {
                retVal = booleanValue;
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("findConnectorPropertyBoolean - unrecognized value of ConnectorProperty " + desiredPropertyName + " with value <" + value + ">.  Using default of <" + defaultValue + "> instead."), (Object[])new Object[0]);
        }
        return retVal;
    }

    public String findConnectorPropertyString(String desiredPropertyName, String defaultValue) {
        String retVal = defaultValue;
        String name = null;
        ConnectorProperty property = null;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            property = (ConnectorProperty)e.nextElement();
            name = property.getName();
            if (!name.equals(desiredPropertyName)) continue;
            retVal = (String)property.getValue();
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        String propName = null;
        buf.append("[Deployed Resource Adapter Properties]" + nl);
        for (int i = 0; i < this.elementCount; ++i) {
            ConnectorProperty prop = (ConnectorProperty)this.elementAt(i);
            propName = prop.getName();
            if (propName.equals("Password") || propName.equals("xaRecoveryPassword")) {
                buf.append("\t");
                buf.append(propName);
                buf.append(" \t ");
                buf.append(prop.getType());
                buf.append(" \t ");
                buf.append("********");
                buf.append(nl);
                continue;
            }
            buf.append("\t");
            buf.append(propName);
            buf.append(" \t ");
            buf.append(prop.getType());
            buf.append(" \t ");
            buf.append(prop.getValue());
            buf.append(nl);
        }
        return buf.toString();
    }
}

