/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.resource.ResourceException;

public class CommonFunction {
    private static final TraceComponent tc = Tr.register(CommonFunction.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS(CommonFunction.class, (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    public static final String nl = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    public static String exceptionList(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("<=================================>");
        sb.append("Exception Message -> ");
        sb.append(ex.getMessage());
        sb.append(nl);
        if (ex instanceof ResourceException) {
            sb.append("  ResourceException Error Code -> ");
            sb.append(((ResourceException)ex).getErrorCode());
            sb.append(nl);
        }
        if (ex instanceof SQLException) {
            sb.append("  SQLException  Error Code -> ");
            sb.append(((SQLException)ex).getErrorCode());
            sb.append(nl);
            sb.append("  SQLException  SQLState -> ");
            sb.append(((SQLException)ex).getSQLState());
            sb.append(nl);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        sb.append(sw.getBuffer());
        sb.append("<=================================>");
        Throwable ex2 = null;
        ex2 = ex.getCause();
        if (ex2 != null) {
            sb.append("Next Linked Exception:" + nl);
            sb.append(CommonFunction.exceptionList(ex2));
        }
        return sb.toString();
    }

    public static final String getNLSMessage(String key, Object ... args) {
        return NLS.getFormattedMessage(key, args, key);
    }

    static byte[] serObjByte(Object pk) throws IOException {
        byte[] b;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serObjByte", (Object[])new Object[]{pk == null ? null : pk.getClass()});
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(pk);
            out.flush();
            out.close();
            b = bos.toByteArray();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)CommonFunction.class.getName(), (String)"203");
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serObjByte", (Object)new Object[]{"Unable to serialize: " + pk, e});
            }
            throw e;
        }
        catch (Error e) {
            FFDCFilter.processException((Throwable)e, (String)CommonFunction.class.getName(), (String)"210");
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serObjByte", (Object)new Object[]{"Unable to serialize: " + pk, e});
            }
            throw e;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serObjByte");
        }
        return b;
    }

    static String stackTraceToString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (int depth = 0; depth < 10 && th != null; ++depth) {
            th.printStackTrace(pw);
            Throwable cause = th.getCause();
            if (cause == th) continue;
            th = cause;
            pw.append("-------- chained exception -------").append(nl);
        }
        return sw.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return new StringBuffer(obj.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(obj))).toString();
    }
}

