/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache.keyproviders;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.AuthCacheConfig;
import com.ibm.ws.security.authentication.cache.CacheContext;
import com.ibm.ws.security.authentication.cache.CacheKeyProvider;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BasicAuthCacheKeyProvider
implements CacheKeyProvider {
    private static final TraceComponent tc = Tr.register(BasicAuthCacheKeyProvider.class);
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static final String KEY_SEPARATOR = ":";
    private static MessageDigest CLONEABLE_MESSAGE_DIGEST = null;
    static final long serialVersionUID = 4962200211190021421L;

    public Object provideKey(CacheContext cacheContext) {
        Set<Object> keys = null;
        if (this.isPossibleToCreateAnyKey(cacheContext)) {
            keys = new HashSet();
            String hashedPassword = this.createHashedPassword(cacheContext);
            this.addKeysFromContext(keys, cacheContext, hashedPassword);
            this.addKeysFromWSCredential(keys, cacheContext, hashedPassword);
        } else {
            keys = Collections.emptySet();
        }
        return keys;
    }

    private boolean isPossibleToCreateAnyKey(CacheContext cacheContext) {
        SubjectHelper subjectHelper = new SubjectHelper();
        return cacheContext.getUserid() != null || subjectHelper.getWSCredential(cacheContext.getSubject()) != null;
    }

    @FFDCIgnore(value={NoSuchAlgorithmException.class})
    private String createHashedPassword(CacheContext cacheContext) {
        String hashedPassword;
        block3: {
            hashedPassword = null;
            try {
                AuthCacheConfig config = cacheContext.getAuthCacheConfig();
                String password = cacheContext.getPassword();
                if (config.isBasicAuthLookupAllowed() && password != null) {
                    hashedPassword = BasicAuthCacheKeyProvider.getHashedPassword(password);
                }
            }
            catch (NoSuchAlgorithmException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"There was a problem creating the hashed password.", (Object[])new Object[]{e});
            }
        }
        return hashedPassword;
    }

    /*
     * WARNING - void declaration
     */
    private void addKeysFromContext(Set<Object> keys, CacheContext cacheContext, @Sensitive String hashedPassword) {
        block2: {
            try {
                SubjectHelper subjectHelper = new SubjectHelper();
                String realm = subjectHelper.getRealm(cacheContext.getSubject());
                String userid = cacheContext.getUserid();
                this.addKeys(keys, realm, userid, hashedPassword);
            }
            catch (Exception subjectHelper) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = keys;
                objectArray[1] = cacheContext;
                objectArray[2] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)subjectHelper, (String)"com.ibm.ws.security.authentication.internal.cache.keyproviders.BasicAuthCacheKeyProvider", (String)"85", (Object)this, (Object[])objectArray);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"There was a problem creating the cache key.", (Object[])new Object[]{e});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addKeysFromWSCredential(Set<Object> keys, CacheContext cacheContext, @Sensitive String hashedPassword) {
        block3: {
            SubjectHelper subjectHelper = new SubjectHelper();
            WSCredential wsCredential = subjectHelper.getWSCredential(cacheContext.getSubject());
            if (wsCredential != null) {
                try {
                    String realm = wsCredential.getRealmName();
                    String securityName = wsCredential.getSecurityName();
                    String uniqueSecurityName = wsCredential.getUniqueSecurityName();
                    this.addKeys(keys, realm, securityName, hashedPassword);
                    this.addKeys(keys, realm, uniqueSecurityName, hashedPassword);
                }
                catch (Exception realm) {
                    void e;
                    Object[] objectArray = new Object[3];
                    objectArray[0] = keys;
                    objectArray[1] = cacheContext;
                    objectArray[2] = "<sensitive java.lang.String>";
                    FFDCFilter.processException((Throwable)realm, (String)"com.ibm.ws.security.authentication.internal.cache.keyproviders.BasicAuthCacheKeyProvider", (String)"102", (Object)this, (Object[])objectArray);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"There was a problem creating the password based cache keys from the WSCredential.", (Object[])new Object[]{e});
                }
            }
        }
    }

    private void addKeys(Set<Object> keys, String realm, String userid, @Sensitive String hashedPassword) {
        String keyWithoutPassword = BasicAuthCacheKeyProvider.createLookupKey(realm, userid);
        this.addKey(keys, keyWithoutPassword);
        if (keyWithoutPassword != null && hashedPassword != null) {
            String keyWithPassword = keyWithoutPassword + KEY_SEPARATOR + hashedPassword;
            this.addKey(keys, keyWithPassword);
        }
    }

    private void addKey(Set<Object> keys, String cacheKey) {
        if (cacheKey != null) {
            keys.add(cacheKey);
        }
    }

    public static String createLookupKey(String realm, String userid) {
        String key = null;
        if (realm != null && userid != null) {
            key = realm + KEY_SEPARATOR + userid;
        }
        return key;
    }

    @FFDCIgnore(value={NoSuchAlgorithmException.class})
    public static String createLookupKey(String realm, String userid, @Sensitive String password) {
        String lookupKey;
        block3: {
            lookupKey = null;
            if (realm != null && userid != null && password != null) {
                try {
                    String hashedPassword = BasicAuthCacheKeyProvider.getHashedPassword(password);
                    lookupKey = realm + KEY_SEPARATOR + userid + KEY_SEPARATOR + hashedPassword;
                }
                catch (NoSuchAlgorithmException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"There was a problem creating the lookup key.", (Object[])new Object[]{e});
                }
            }
        }
        return lookupKey;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        if (CLONEABLE_MESSAGE_DIGEST == null) {
            CLONEABLE_MESSAGE_DIGEST = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        }
        try {
            return (MessageDigest)CLONEABLE_MESSAGE_DIGEST.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.security.authentication.internal.cache.keyproviders.BasicAuthCacheKeyProvider", (String)"191", null, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void cnse;
                Tr.debug((TraceComponent)tc, (String)"CloneNotSupportedException caught while trying to clone MessageDigest with algorithm SHA. This is pretty unlikely, and we need to get details about the JDK which is in use.", (Object[])new Object[]{cnse});
            }
            return MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        }
    }

    private static String getHashedPassword(@Sensitive String password) throws NoSuchAlgorithmException {
        String hashedPassword = null;
        if (password != null) {
            MessageDigest messageDigest = BasicAuthCacheKeyProvider.getMessageDigest();
            hashedPassword = Base64Coder.base64EncodeToString(messageDigest.digest(Base64Coder.getBytes(password)));
        }
        return hashedPassword;
    }
}

