/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.LogMetaInfUtils;
import org.apache.myfaces.config.element.ConfigOthersSlot;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.myfaces.config.element.FacesConfigNameSlot;
import org.apache.myfaces.config.element.OrderSlot;
import org.apache.myfaces.config.element.Ordering;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.util.CyclicDependencyException;
import org.apache.myfaces.config.util.DirectedAcyclicGraphVerifier;
import org.apache.myfaces.config.util.Vertex;
import org.apache.myfaces.spi.FacesConfigurationMerger;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.FacesConfigurationProviderFactory;

public class DefaultFacesConfigurationMerger
extends FacesConfigurationMerger {
    private static final Logger log = Logger.getLogger(DefaultFacesConfigurationMerger.class.getName());

    @Override
    public FacesConfigData getFacesConfigData(ExternalContext externalContext) {
        FacesConfigurationProvider facesConfigProvider = FacesConfigurationProviderFactory.getFacesConfigurationProviderFactory(externalContext).getFacesConfigurationProvider(externalContext);
        DigesterFacesConfigDispenserImpl dispenser = new DigesterFacesConfigDispenserImpl();
        ((FacesConfigDispenser)dispenser).feed(facesConfigProvider.getStandardFacesConfig(externalContext));
        ((FacesConfigDispenser)dispenser).feed(facesConfigProvider.getMetaInfServicesFacesConfig(externalContext));
        FacesConfig webAppFacesConfig = facesConfigProvider.getWebAppFacesConfig(externalContext);
        boolean metadataComplete = false;
        metadataComplete = webAppFacesConfig != null ? Boolean.valueOf(webAppFacesConfig.getMetadataComplete()) : false;
        FacesConfig annotationFacesConfig = facesConfigProvider.getAnnotationsFacesConfig(externalContext, metadataComplete);
        if (annotationFacesConfig != null) {
            ((FacesConfigDispenser)dispenser).feed(annotationFacesConfig);
        }
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        appConfigResources.addAll(facesConfigProvider.getClassloaderFacesConfig(externalContext));
        appConfigResources.addAll(facesConfigProvider.getContextSpecifiedFacesConfig(externalContext));
        appConfigResources.addAll(facesConfigProvider.getApplicationConfigurationResourceDocumentPopulatorFacesConfig(externalContext));
        appConfigResources.addAll(facesConfigProvider.getFacesFlowFacesConfig(externalContext));
        this.orderAndFeedArtifacts(dispenser, appConfigResources, webAppFacesConfig);
        List<FacesConfig> faceletTagLibFacesConfig = facesConfigProvider.getFaceletTaglibFacesConfig(externalContext);
        if (faceletTagLibFacesConfig != null && !faceletTagLibFacesConfig.isEmpty()) {
            for (FacesConfig fc : faceletTagLibFacesConfig) {
                ((FacesConfigDispenser)dispenser).feed(fc);
            }
        }
        LogMetaInfUtils.logMetaInf();
        return dispenser;
    }

    protected void orderAndFeedArtifacts(FacesConfigDispenser dispenser, List<FacesConfig> appConfigResources, FacesConfig webAppConfig) throws FacesException {
        if (webAppConfig != null && webAppConfig.getAbsoluteOrdering() != null) {
            if (webAppConfig.getOrdering() != null && log.isLoggable(Level.WARNING)) {
                log.warning("<ordering> element found in application faces config. This description will be ignored and the actions described in <absolute-ordering> element will be taken into account instead.");
            }
            ArrayList<FacesConfig> othersResources = new ArrayList<FacesConfig>();
            List<OrderSlot> slots = webAppConfig.getAbsoluteOrdering().getOrderList();
            for (FacesConfig resource : appConfigResources) {
                if (resource.getName() != null && (resource.getName() == null || this.containsResourceInSlot(slots, resource.getName()))) continue;
                othersResources.add(resource);
            }
            for (OrderSlot slot : webAppConfig.getAbsoluteOrdering().getOrderList()) {
                if (slot instanceof ConfigOthersSlot) {
                    for (FacesConfig resource : othersResources) {
                        dispenser.feed(resource);
                    }
                    continue;
                }
                FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
                FacesConfig targetFacesConfig = this.getFacesConfig(appConfigResources, nameSlot.getName());
                if (targetFacesConfig == null) continue;
                dispenser.feed(targetFacesConfig);
            }
        } else if (!appConfigResources.isEmpty()) {
            for (FacesConfig resource : appConfigResources) {
                if (resource.getAbsoluteOrdering() == null || !log.isLoggable(Level.WARNING)) continue;
                log.warning("<absolute-ordering> element found in application configuration resource " + resource.getName() + ". " + "This description will be ignored and the actions described " + "in <ordering> elements will be taken into account instead.");
            }
            List<FacesConfig> postOrderedList = this.getPostOrderedList(appConfigResources);
            List<FacesConfig> sortedList = this.sortRelativeOrderingList(postOrderedList);
            if (sortedList == null) {
                sortedList = this.applySortingAlgorithm(appConfigResources);
            }
            for (FacesConfig resource : sortedList) {
                dispenser.feed(resource);
            }
        }
        if (webAppConfig != null) {
            dispenser.feed(webAppConfig);
        }
    }

    protected List<FacesConfig> applySortingAlgorithm(List<FacesConfig> appConfigResources) throws FacesException {
        Vertex<FacesConfig> v;
        ArrayList vertexList = new ArrayList();
        for (FacesConfig config : appConfigResources) {
            v = null;
            v = config.getName() != null ? new Vertex<FacesConfig>(config.getName(), config) : new Vertex<FacesConfig>(config);
            vertexList.add(v);
        }
        boolean[] referencedVertex = new boolean[vertexList.size()];
        for (int i = 0; i < vertexList.size(); ++i) {
            int j;
            Vertex v1;
            v = (Vertex<FacesConfig>)vertexList.get(i);
            FacesConfig f = v.getNode();
            if (f.getOrdering() == null) continue;
            for (OrderSlot slot : f.getOrdering().getBeforeList()) {
                String string;
                if (!(slot instanceof FacesConfigNameSlot) || (v1 = (Vertex)vertexList.get(j = DirectedAcyclicGraphVerifier.findVertex(vertexList, string = ((FacesConfigNameSlot)slot).getName()))) == null) continue;
                referencedVertex[i] = true;
                referencedVertex[j] = true;
                v1.addDependency(v);
            }
            for (OrderSlot slot : f.getOrdering().getAfterList()) {
                String string;
                if (!(slot instanceof FacesConfigNameSlot) || (v1 = (Vertex)vertexList.get(j = DirectedAcyclicGraphVerifier.findVertex(vertexList, string = ((FacesConfigNameSlot)slot).getName()))) == null) continue;
                referencedVertex[i] = true;
                referencedVertex[j] = true;
                v.addDependency(v1);
            }
        }
        ArrayList<Vertex> beforeAfterOthersList = new ArrayList<Vertex>();
        ArrayList<Vertex> othersList = new ArrayList<Vertex>();
        ArrayList referencedList = new ArrayList();
        for (int i = 0; i < vertexList.size(); ++i) {
            if (!referencedVertex[i]) {
                Vertex v2 = (Vertex)vertexList.get(i);
                FacesConfig facesConfig = (FacesConfig)v2.getNode();
                boolean added = false;
                if (facesConfig.getOrdering() != null) {
                    if (!facesConfig.getOrdering().getBeforeList().isEmpty()) {
                        added = true;
                        beforeAfterOthersList.add(v2);
                    } else if (!facesConfig.getOrdering().getAfterList().isEmpty()) {
                        added = true;
                        beforeAfterOthersList.add(v2);
                    }
                }
                if (added) continue;
                othersList.add(v2);
                continue;
            }
            referencedList.add(vertexList.get(i));
        }
        try {
            DirectedAcyclicGraphVerifier.topologicalSort(referencedList);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
        }
        ArrayList<FacesConfig> sortedList = new ArrayList<FacesConfig>();
        for (Vertex vertex : referencedList) {
            sortedList.add((FacesConfig)vertex.getNode());
        }
        for (Vertex vertex : othersList) {
            sortedList.add((FacesConfig)vertex.getNode());
        }
        for (Vertex vertex : beforeAfterOthersList) {
            FacesConfig f = (FacesConfig)vertex.getNode();
            boolean added = false;
            if (f.getOrdering() != null && !f.getOrdering().getBeforeList().isEmpty()) {
                added = true;
                sortedList.add(0, f);
            }
            if (added) continue;
            sortedList.add(f);
        }
        for (int i = 0; i < sortedList.size(); ++i) {
            int j;
            boolean founded;
            String name;
            FacesConfig facesConfig = (FacesConfig)sortedList.get(i);
            if (facesConfig.getOrdering() == null) continue;
            for (OrderSlot slot : facesConfig.getOrdering().getBeforeList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                founded = false;
                for (j = i - 1; j >= 0; --j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                log.severe("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                throw new FacesException("Circular references detected when sorting application config resources. Use absolute ordering instead.");
            }
            for (OrderSlot slot : facesConfig.getOrdering().getAfterList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                founded = false;
                for (j = i + 1; j < sortedList.size(); ++j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                log.severe("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                throw new FacesException("Circular references detected when sorting application config resources. Use absolute ordering instead.");
            }
        }
        return sortedList;
    }

    protected List<FacesConfig> sortRelativeOrderingList(List<FacesConfig> preOrderedList) {
        FacesConfig resource;
        int i;
        ArrayList<FacesConfig> sortedList = new ArrayList<FacesConfig>();
        for (i = 0; i < preOrderedList.size(); ++i) {
            resource = preOrderedList.get(i);
            if (resource.getOrdering() != null) {
                if (resource.getOrdering().getBeforeList().isEmpty() && resource.getOrdering().getAfterList().isEmpty()) {
                    sortedList.add(resource);
                    continue;
                }
                if (resource.getOrdering().getBeforeList().isEmpty()) {
                    this.applyAfterRule(sortedList, resource);
                    continue;
                }
                if (resource.getOrdering().getAfterList().isEmpty()) {
                    boolean referenceNode = false;
                    block1: for (int j = i + 1; j < preOrderedList.size(); ++j) {
                        FacesConfig pointingResource = preOrderedList.get(j);
                        for (OrderSlot slot : pointingResource.getOrdering().getBeforeList()) {
                            if (slot instanceof FacesConfigNameSlot && resource.getName().equals(((FacesConfigNameSlot)slot).getName())) {
                                referenceNode = true;
                            }
                            if (!(slot instanceof ConfigOthersSlot)) continue;
                            referenceNode = false;
                            break;
                        }
                        if (referenceNode) break;
                        for (OrderSlot slot : pointingResource.getOrdering().getAfterList()) {
                            if (!(slot instanceof FacesConfigNameSlot) || !resource.getName().equals(((FacesConfigNameSlot)slot).getName())) continue;
                            referenceNode = true;
                            continue block1;
                        }
                    }
                    this.applyBeforeRule(sortedList, resource, referenceNode);
                    continue;
                }
                int beforeWeight = 0;
                int afterWeight = 0;
                for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
                    if (!(slot instanceof FacesConfigNameSlot)) continue;
                    ++beforeWeight;
                }
                for (OrderSlot slot : resource.getOrdering().getAfterList()) {
                    if (!(slot instanceof FacesConfigNameSlot)) continue;
                    ++afterWeight;
                }
                if (beforeWeight >= afterWeight) {
                    this.applyBeforeRule(sortedList, resource, false);
                    continue;
                }
                this.applyAfterRule(sortedList, resource);
                continue;
            }
            sortedList.add(resource);
        }
        for (i = 0; i < sortedList.size(); ++i) {
            String name;
            resource = (FacesConfig)sortedList.get(i);
            if (resource.getOrdering() == null) continue;
            for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                boolean founded = false;
                for (int j = i - 1; j >= 0; --j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                return null;
            }
            for (OrderSlot slot : resource.getOrdering().getAfterList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                boolean founded = false;
                for (int j = i + 1; j < sortedList.size(); ++j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                return null;
            }
        }
        return sortedList;
    }

    private void applyBeforeRule(List<FacesConfig> sortedList, FacesConfig resource, boolean referenced) throws FacesException {
        boolean configOthers = false;
        ArrayList<String> names = new ArrayList<String>();
        for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
            if (slot instanceof ConfigOthersSlot) {
                configOthers = true;
                break;
            }
            FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
            names.add(nameSlot.getName());
        }
        if (configOthers) {
            if (resource.getOrdering().getBeforeList().size() > 1) {
                sortedList.add(0, resource);
            } else if (!referenced) {
                sortedList.add(0, resource);
            } else {
                sortedList.add(resource);
            }
        } else {
            boolean founded = false;
            for (int i = 0; i < sortedList.size(); ++i) {
                if (!names.contains(sortedList.get(i).getName())) continue;
                sortedList.add(i, resource);
                founded = true;
                break;
            }
            if (!founded) {
                sortedList.add(resource);
            }
        }
    }

    private void applyAfterRule(List<FacesConfig> sortedList, FacesConfig resource) throws FacesException {
        boolean configOthers = false;
        ArrayList<String> names = new ArrayList<String>();
        for (OrderSlot slot : resource.getOrdering().getAfterList()) {
            if (slot instanceof ConfigOthersSlot) {
                configOthers = true;
                break;
            }
            FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
            names.add(nameSlot.getName());
        }
        if (configOthers) {
            sortedList.add(resource);
        } else {
            boolean founded = false;
            for (int i = sortedList.size() - 1; i >= 0; --i) {
                if (!names.contains(sortedList.get(i).getName())) continue;
                if (i + 1 < sortedList.size()) {
                    sortedList.add(i + 1, resource);
                } else {
                    sortedList.add(resource);
                }
                founded = true;
                break;
            }
            if (!founded) {
                sortedList.add(resource);
            }
        }
    }

    protected List<FacesConfig> getPostOrderedList(List<FacesConfig> appConfigResources) throws FacesException {
        ArrayList<String> availableReferences = new ArrayList<String>();
        for (FacesConfig resource : appConfigResources) {
            String name = resource.getName();
            if (name == null || "".equals(name)) continue;
            availableReferences.add(name);
        }
        for (FacesConfig resource : appConfigResources) {
            String name;
            OrderSlot slot;
            Ordering ordering = resource.getOrdering();
            if (ordering == null) continue;
            Iterator<OrderSlot> it = resource.getOrdering().getBeforeList().iterator();
            while (it.hasNext()) {
                slot = it.next();
                if (!(slot instanceof FacesConfigNameSlot) || availableReferences.contains(name = ((FacesConfigNameSlot)slot).getName())) continue;
                it.remove();
            }
            it = resource.getOrdering().getAfterList().iterator();
            while (it.hasNext()) {
                slot = it.next();
                if (!(slot instanceof FacesConfigNameSlot) || availableReferences.contains(name = ((FacesConfigNameSlot)slot).getName())) continue;
                it.remove();
            }
        }
        List<FacesConfig> appFilteredConfigResources = null;
        if (appConfigResources instanceof ArrayList) {
            appFilteredConfigResources = (List)((ArrayList)appConfigResources).clone();
        } else {
            appFilteredConfigResources = new ArrayList();
            appFilteredConfigResources.addAll(appConfigResources);
        }
        Collections.sort(appFilteredConfigResources, new Comparator<FacesConfig>(){

            @Override
            public int compare(FacesConfig o1, FacesConfig o2) {
                int o1Weight = 0;
                int o2Weight = 0;
                if (o1.getOrdering() != null) {
                    for (OrderSlot slot : o1.getOrdering().getBeforeList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o1Weight;
                    }
                    for (OrderSlot slot : o1.getOrdering().getAfterList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o1Weight;
                    }
                }
                if (o2.getOrdering() != null) {
                    for (OrderSlot slot : o2.getOrdering().getBeforeList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o2Weight;
                    }
                    for (OrderSlot slot : o2.getOrdering().getAfterList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o2Weight;
                    }
                }
                return o2Weight - o1Weight;
            }
        });
        LinkedList<FacesConfig> postOrderedList = new LinkedList<FacesConfig>();
        ArrayList<FacesConfig> othersList = new ArrayList<FacesConfig>();
        ArrayList<String> nameBeforeStack = new ArrayList<String>();
        ArrayList<String> nameAfterStack = new ArrayList<String>();
        boolean[] visitedSlots = new boolean[appFilteredConfigResources.size()];
        for (int i = 0; i < appFilteredConfigResources.size(); ++i) {
            if (visitedSlots[i]) continue;
            this.resolveConflicts(appFilteredConfigResources, i, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, false);
        }
        postOrderedList.addAll(othersList);
        return postOrderedList;
    }

    private void resolveConflicts(List<FacesConfig> appConfigResources, int index, boolean[] visitedSlots, List<String> nameBeforeStack, List<String> nameAfterStack, List<FacesConfig> postOrderedList, List<FacesConfig> othersList, boolean indexReferenced) throws FacesException {
        FacesConfig facesConfig = appConfigResources.get(index);
        if (nameBeforeStack.contains(facesConfig.getName())) {
            return;
        }
        if (nameAfterStack.contains(facesConfig.getName())) {
            return;
        }
        if (facesConfig.getOrdering() != null) {
            FacesConfig resource;
            boolean alreadyAdded;
            FacesConfigNameSlot nameSlot;
            boolean pointingResource = false;
            for (OrderSlot slot : facesConfig.getOrdering().getBeforeList()) {
                if (!(slot instanceof FacesConfigNameSlot)) continue;
                nameSlot = (FacesConfigNameSlot)slot;
                alreadyAdded = false;
                for (FacesConfig res : postOrderedList) {
                    if (!nameSlot.getName().equals(res.getName())) continue;
                    alreadyAdded = true;
                    break;
                }
                if (!alreadyAdded) {
                    int indexSlot = -1;
                    for (int i = 0; i < appConfigResources.size(); ++i) {
                        resource = appConfigResources.get(i);
                        if (resource.getName() == null || !nameSlot.getName().equals(resource.getName())) continue;
                        indexSlot = i;
                        break;
                    }
                    if (indexSlot == -1) continue;
                    pointingResource = true;
                    nameBeforeStack.add(facesConfig.getName());
                    this.resolveConflicts(appConfigResources, indexSlot, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, true);
                    nameBeforeStack.remove(facesConfig.getName());
                    continue;
                }
                pointingResource = true;
            }
            for (OrderSlot slot : facesConfig.getOrdering().getAfterList()) {
                if (!(slot instanceof FacesConfigNameSlot)) continue;
                nameSlot = (FacesConfigNameSlot)slot;
                alreadyAdded = false;
                for (FacesConfig res : postOrderedList) {
                    if (!nameSlot.getName().equals(res.getName())) continue;
                    alreadyAdded = true;
                    break;
                }
                if (!alreadyAdded) {
                    int indexSlot = -1;
                    for (int i = 0; i < appConfigResources.size(); ++i) {
                        resource = appConfigResources.get(i);
                        if (resource.getName() == null || !nameSlot.getName().equals(resource.getName())) continue;
                        indexSlot = i;
                        break;
                    }
                    if (indexSlot == -1) continue;
                    pointingResource = true;
                    nameAfterStack.add(facesConfig.getName());
                    this.resolveConflicts(appConfigResources, indexSlot, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, true);
                    nameAfterStack.remove(facesConfig.getName());
                    continue;
                }
                pointingResource = true;
            }
            if (facesConfig.getOrdering().getBeforeList().isEmpty() && facesConfig.getOrdering().getAfterList().isEmpty()) {
                postOrderedList.add(0, appConfigResources.get(index));
            } else if (pointingResource || indexReferenced) {
                postOrderedList.add(appConfigResources.get(index));
            } else {
                othersList.add(appConfigResources.get(index));
            }
        } else {
            postOrderedList.add(0, appConfigResources.get(index));
        }
        visitedSlots[index] = true;
    }

    private FacesConfig getFacesConfig(List<FacesConfig> appConfigResources, String name) {
        for (FacesConfig cfg : appConfigResources) {
            if (cfg.getName() == null || !name.equals(cfg.getName())) continue;
            return cfg;
        }
        return null;
    }

    private boolean containsResourceInSlot(List<OrderSlot> slots, String name) {
        for (OrderSlot slot : slots) {
            FacesConfigNameSlot nameSlot;
            if (!(slot instanceof FacesConfigNameSlot) || !name.equals((nameSlot = (FacesConfigNameSlot)slot).getName())) continue;
            return true;
        }
        return false;
    }
}

