/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.aries.application.utils.service.ServiceCollection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ArrayServiceList<E>
implements ServiceCollection<E>,
List<E> {
    private List<E> list = new ArrayList();
    private List<ServiceReference> refList = new ArrayList<ServiceReference>();
    private BundleContext context;

    public ArrayServiceList(BundleContext ctx) {
        this.context = ctx;
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException("The operation add is not supported. Use addService with a service reference.");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("The operation add is not supported. Use addService with a service reference.");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("The operation addAll is not supported. Use addService with a service reference.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("The operation addAll is not supported. Use addService with a service reference.");
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
        for (ServiceReference ref : this.refList) {
            this.context.ungetService(ref);
        }
        this.refList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        final ListIterator<E> it = this.list.listIterator(index);
        final ListIterator<ServiceReference> refIt = this.refList.listIterator(index);
        ListIterator result = new ListIterator<E>(){
            private ServiceReference current;

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return it.hasPrevious();
            }

            @Override
            public E next() {
                Object result = it.next();
                this.current = (ServiceReference)refIt.next();
                return result;
            }

            @Override
            public int nextIndex() {
                return it.nextIndex();
            }

            @Override
            public E previous() {
                Object result = it.previous();
                this.current = (ServiceReference)refIt.previous();
                return result;
            }

            @Override
            public int previousIndex() {
                return it.previousIndex();
            }

            @Override
            public void remove() {
                it.remove();
                refIt.remove();
                ArrayServiceList.this.context.ungetService(this.current);
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }
        };
        return result;
    }

    @Override
    public synchronized boolean remove(Object o) {
        int index = this.list.indexOf(o);
        ServiceReference ref = this.refList.remove(index);
        this.context.ungetService(ref);
        return this.list.remove(o);
    }

    @Override
    public synchronized E remove(int index) {
        ServiceReference ref = this.refList.remove(index);
        this.context.ungetService(ref);
        return this.list.remove(index);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        boolean worked = false;
        for (Object obj : c) {
            worked |= this.remove(obj);
        }
        return worked;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("The operation retainAll is not supported.");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("The operation set is not supported.");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("The operation subList is not supported.");
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    @Override
    public synchronized void addService(ServiceReference ref) {
        Object service = this.context.getService(ref);
        if (service != null) {
            this.list.add(service);
            this.refList.add(ref);
        }
    }
}

