/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.embeddable.impl.EmbeddableRecoveryAgentImpl;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TxRecoveryAgentImpl;
import com.ibm.tx.jta.util.TxTMHelper;
import com.ibm.tx.util.TMHelper;
import com.ibm.tx.util.TMService;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.recoverylog.spi.RecLogServiceImpl;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import javax.transaction.SystemException;

public class EmbeddableTMHelper
extends TxTMHelper {
    private static final TraceComponent tc = Tr.register(EmbeddableTMHelper.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean waitForRecovery) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[]{waitForRecovery});
        }
        if (!this._recoverDBLogStarted) {
            ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
            if (cp != null && cp.getResourceFactory() != null) {
                this._recoverDBLogStarted = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Tran Logging to an RDBMS set recoverDBLogStarted flag", (Object[])new Object[0]);
                }
            }
            EmbeddableTMHelper embeddableTMHelper = this;
            synchronized (embeddableTMHelper) {
                TMHelper.setTMService((TMService)this);
                ConfigurationProviderManager.start();
                if (EmbeddableTMHelper.getState() != TMService.TMStates.INACTIVE && EmbeddableTMHelper.getState() != TMService.TMStates.STOPPED) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"start", (Object)"Already started");
                    }
                    return;
                }
                EmbeddableTMHelper.setResyncException(null);
                this._recLogService = new RecLogServiceImpl();
                this._recoveryDirector = RecoveryDirectorFactory.createRecoveryDirector();
                if (cp != null) {
                    this._recoveryIdentity = cp.getRecoveryIdentity();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RecoveryIdentity is ", (Object[])new Object[]{this._recoveryIdentity});
                    }
                    this._recoveryGroup = cp.getRecoveryGroup();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"recoveryGroup is ", (Object[])new Object[]{this._recoveryGroup});
                    }
                }
                if (this._recoveryIdentity != null && !this._recoveryIdentity.isEmpty()) {
                    this._recLogService.initialize((Object)this._recoveryIdentity);
                } else {
                    String serverName = null;
                    if (cp != null) {
                        serverName = cp.getServerName();
                    }
                    this._recLogService.initialize((Object)serverName);
                }
                EmbeddableRecoveryAgentImpl txAgent = new EmbeddableRecoveryAgentImpl(this._recoveryDirector);
                if (this._recoveryIdentity != null && !this._recoveryIdentity.isEmpty()) {
                    this._recLogService.setPeerRecoverySupported(true);
                    txAgent.setPeerRecoverySupported(true);
                    TransactionImpl.setDisable2PCDefault((boolean)false);
                    Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Server with identity " + this._recoveryIdentity + " is monitoring its peers for Transaction Peer Recovery"), (Object[])new Object[0]);
                }
                if (this._recoveryGroup != null && !this._recoveryGroup.isEmpty()) {
                    txAgent.setRecoveryGroup(this._recoveryGroup);
                    this._recLogService.setRecoveryGroup(this._recoveryGroup);
                }
                EmbeddableTMHelper.setRecoveryAgent((TxRecoveryAgentImpl)txAgent);
                RecoveryManager._waitForRecovery = waitForRecovery;
                this._recLogService.start();
                EmbeddableTMHelper.setState((TMService.TMStates)TMService.TMStates.RECOVERING);
                if (waitForRecovery) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for completion of asynchronous recovery", (Object[])new Object[0]);
                    }
                    _asyncRecoverySemaphore.waitEvent();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Asynchronous recovery is complete", (Object[])new Object[0]);
                    }
                    if (_resyncException != null) {
                        try {
                            this.shutdown();
                        }
                        catch (RuntimeException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.TxTMHelper.start", (String)"137", (Object)((Object)this));
                        }
                        Throwable se = new SystemException().initCause((Throwable)_resyncException);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"start", (Object)se);
                        }
                        throw (SystemException)se;
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Tran Logging to an RDBMS and START processing is in progress", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }
}

