/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SubsystemFeatureDefinitionImpl
implements ProvisioningFeatureDefinition,
LibertyFeature {
    private static final TraceComponent tc = Tr.register(SubsystemFeatureDefinitionImpl.class);
    private final FeatureDefinitionUtils.ImmutableAttributes iAttr;
    private volatile FeatureDefinitionUtils.ProvisioningDetails mfDetails;
    private final String apiServiceElements;
    private final AtomicReference<Collection<Bundle>> featureBundles = new AtomicReference();
    private final AtomicInteger detailUsers = new AtomicInteger(0);
    static final long serialVersionUID = 9179741325800721897L;

    SubsystemFeatureDefinitionImpl(FeatureDefinitionUtils.ImmutableAttributes attr, FeatureDefinitionUtils.ProvisioningDetails details) {
        this.setProvisioningDetails(details);
        this.iAttr = attr;
        this.apiServiceElements = this.iAttr.hasApiServices ? this.mfDetails.getCachedRawHeader("IBM-API-Service") : null;
    }

    public SubsystemFeatureDefinitionImpl(String repoType, InputStream inputStream) throws IOException {
        this.setProvisioningDetails(new FeatureDefinitionUtils.ProvisioningDetails(null, inputStream));
        this.iAttr = FeatureDefinitionUtils.loadAttributes(repoType, null, this.mfDetails);
        this.apiServiceElements = this.iAttr.hasApiServices ? this.mfDetails.getCachedRawHeader("IBM-API-Service") : null;
    }

    public SubsystemFeatureDefinitionImpl(String repoType, File file) throws IOException {
        this.mfDetails = new FeatureDefinitionUtils.ProvisioningDetails(file, null);
        this.iAttr = FeatureDefinitionUtils.loadAttributes(repoType, file, this.mfDetails);
        this.apiServiceElements = this.iAttr.hasApiServices ? this.mfDetails.getCachedRawHeader("IBM-API-Service") : null;
    }

    FeatureDefinitionUtils.ImmutableAttributes getImmutableAttributes() {
        return this.iAttr;
    }

    FeatureDefinitionUtils.ProvisioningDetails getProvisioningDetails() {
        return this.mfDetails;
    }

    @Trivial
    synchronized void setProvisioningDetails(FeatureDefinitionUtils.ProvisioningDetails details) {
        if (details == null) {
            if (this.detailUsers.decrementAndGet() <= 0) {
                this.featureBundles.set(null);
                this.mfDetails = null;
            }
        } else {
            this.mfDetails = details;
            this.detailUsers.incrementAndGet();
        }
    }

    @Override
    public File getFeatureDefinitionFile() {
        return this.iAttr.featureFile;
    }

    @Override
    public File getFeatureChecksumFile() {
        return this.iAttr.checksumFile;
    }

    @Override
    public String getFeatureName() {
        return this.iAttr.featureName;
    }

    @Override
    public String getSymbolicName() {
        return this.iAttr.symbolicName;
    }

    @Override
    public String getIbmShortName() {
        return this.iAttr.shortName;
    }

    @Override
    public int getIbmFeatureVersion() {
        return this.iAttr.featureVersion;
    }

    @Override
    public Version getVersion() {
        return this.iAttr.version;
    }

    @Override
    public AppForceRestart getAppForceRestart() {
        return this.iAttr.appRestart;
    }

    @Override
    public Visibility getVisibility() {
        return this.iAttr.visibility;
    }

    @Override
    public EnumSet<ProcessType> getProcessTypes() {
        return this.iAttr.processTypes;
    }

    @Override
    public boolean isSingleton() {
        return this.iAttr.isSingleton;
    }

    @Override
    public String getBundleRepositoryType() {
        return this.iAttr.bundleRepositoryType;
    }

    @Override
    public boolean isSupportedFeatureVersion() {
        return this.iAttr.isSupportedFeatureVersion();
    }

    @Override
    public boolean isAutoFeature() {
        return this.iAttr.isAutoFeature;
    }

    @Override
    public String getApiServices() {
        return this.apiServiceElements;
    }

    @Override
    public Collection<File> getLocalizationFiles() {
        File dir = this.iAttr.getLocalizationDirectory();
        File[] files = null;
        if (dir != null && dir.isDirectory()) {
            files = dir.listFiles(new FilenameFilter(){
                static final long serialVersionUID = -6764374062422547304L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(((SubsystemFeatureDefinitionImpl)SubsystemFeatureDefinitionImpl.this).iAttr.symbolicName + ".properties") || name.startsWith(((SubsystemFeatureDefinitionImpl)SubsystemFeatureDefinitionImpl.this).iAttr.symbolicName + "_") && name.endsWith(".properties");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        File[] files;
        File dir = this.iAttr.getLocalizationDirectory();
        for (File file : files = new File[]{new File(dir, this.iAttr.symbolicName + "_" + locale.toString() + ".properties"), new File(dir, this.iAttr.symbolicName + "_" + locale.getLanguage() + ".properties"), new File(dir, this.iAttr.symbolicName + ".properties")}) {
            if (!file.exists()) continue;
            try {
                return new PropertyResourceBundle(new FileReader(file));
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl", (String)"281", (Object)this, (Object[])new Object[]{locale});
            }
        }
        return null;
    }

    @Override
    public Collection<FeatureResource> getConstituents(SubsystemContentType type) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        return this.mfDetails.getConstituents(type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getHeader(String header) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        try {
            return this.mfDetails.getMainAttributeValue(header);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl", (String)"305", (Object)this, (Object[])new Object[]{header});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"IOException reading manifest attribute from {0}: {1}", (Object[])new Object[]{this.iAttr.featureFile, e});
            }
            return null;
        }
    }

    @Override
    public String getHeader(String header, Locale locale) {
        ResourceBundle rb;
        String value = this.getHeader(header);
        if (value == null || value.isEmpty() || locale == null) {
            return value;
        }
        if (value.charAt(0) == '%' && FeatureDefinitionUtils.LOCALIZABLE_HEADERS.contains(header) && (rb = this.getResourceBundle(locale)) != null) {
            value = rb.getString(value.substring(1));
        }
        return value;
    }

    @Override
    public Collection<HeaderElementDefinition> getHeaderElements(String header) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        return this.mfDetails.getRawHeaderElements(header);
    }

    void setHeader(String header, String value) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        this.mfDetails.setHeaderValue(header, value);
    }

    public int hashCode() {
        return this.iAttr.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubsystemFeatureDefinitionImpl other = (SubsystemFeatureDefinitionImpl)obj;
        return this.iAttr.equals(other.iAttr);
    }

    @Override
    public boolean isSuperseded() {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        return this.mfDetails.isSuperseded();
    }

    @Override
    public String getSupersededBy() {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        return this.mfDetails.getSupersededBy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isCapabilitySatisfied(Collection<ProvisioningFeatureDefinition> featureDefinitionsToCheck) {
        if (!this.iAttr.isAutoFeature) {
            return true;
        }
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        boolean isCapabilitySatisfied = true;
        Iterator<Filter> iter = this.mfDetails.getCapabilityFilters().iterator();
        HashSet<ProvisioningFeatureDefinition> satisfiedFeatureDefs = new HashSet<ProvisioningFeatureDefinition>();
        while (iter.hasNext() && isCapabilitySatisfied) {
            Filter checkFilter = iter.next();
            Iterator<ProvisioningFeatureDefinition> featureDefIter = featureDefinitionsToCheck.iterator();
            boolean featureMatch = false;
            while (featureDefIter.hasNext() && !featureMatch) {
                ProvisioningFeatureDefinition featureDef = featureDefIter.next();
                if (satisfiedFeatureDefs.contains(featureDef)) continue;
                HashMap<String, String> filterProps = new HashMap<String, String>();
                filterProps.put("osgi.identity", featureDef.getSymbolicName());
                try {
                    filterProps.put("type", this.mfDetails.getMainAttributeValue("Subsystem-Type"));
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl", (String)"432", (Object)this, (Object[])new Object[]{featureDefinitionsToCheck});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"IOException reading manifest attribute from {0}: {1}", (Object[])new Object[]{this.iAttr.featureFile, e});
                    continue;
                }
                if (!checkFilter.matches(filterProps)) continue;
                satisfiedFeatureDefs.add(featureDef);
                featureMatch = true;
            }
            isCapabilitySatisfied = featureMatch;
        }
        return isCapabilitySatisfied;
    }

    @Override
    public boolean isKernel() {
        return false;
    }

    public String toString() {
        if (this.mfDetails == null) {
            return this.iAttr.toString();
        }
        return this.mfDetails.toString();
    }

    @Override
    public Collection<String> getIcons() {
        ArrayList<String> icons = new ArrayList<String>();
        String iconHeader = this.getHeader("Subsystem-Icon");
        if (iconHeader != null) {
            String[] iconHeaders;
            for (String iconDirective : iconHeaders = iconHeader.split(",")) {
                String[] iconDirectives = iconDirective.split(";");
                icons.add(iconDirectives[0].trim());
            }
        }
        return icons;
    }

    @Override
    public Collection<Bundle> getBundles() {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation or without a registered service");
        }
        Collection<Bundle> bundles = this.featureBundles.get();
        if (bundles == null) {
            bundles = new ArrayList<Bundle>();
            Collection<FeatureResource> bundlesInFeature = this.mfDetails.getConstituents(SubsystemContentType.BUNDLE_TYPE);
            BundleContext ctx = FrameworkUtil.getBundle(FrameworkUtil.class).getBundleContext();
            for (FeatureResource bundle : bundlesInFeature) {
                String location = bundle.getLocation();
                Bundle b = ctx.getBundle(location);
                if (b == null) continue;
                bundles.add(b);
            }
            bundles = Collections.unmodifiableCollection(bundles);
            this.featureBundles.compareAndSet(null, bundles);
        }
        return bundles;
    }
}

