/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility.tasks;

import com.ibm.ws.http.plugin.merge.PluginMergeTool;
import com.ibm.ws.http.plugin.merge.PluginMergeToolFactory;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.webserver.plugin.utility.tasks.BasePluginConfigCommandTask;
import com.ibm.ws.webserver.plugin.utility.utils.CommandUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;

public class MergePluginFilesTask
extends BasePluginConfigCommandTask {
    static final String ARG_REQ_SOURCE_PATH = "--sourcePath";
    static final String ARG_OPT_TARGET_PATH = "--targetPath";
    static final String FILE_SELECT_REG_EXP = ".*plugin-cfg.*.xml";
    static final String TARGET_MERGED_FILE_NAME = "merged-plugin-cfg.xml";
    static final String CURRENT_DIR = "user.dir";

    public MergePluginFilesTask(String scriptName) {
        super(scriptName);
    }

    public String getTaskName() {
        return "merge";
    }

    public Set<String> getSupportedOptions() {
        return null;
    }

    public void execute(ExecutionContext context) {
        this.reqArgs.add(ARG_REQ_SOURCE_PATH);
        this.knownArgs.add(ARG_OPT_TARGET_PATH);
        this.knownArgs.addAll(this.reqArgs);
        this.validateArgumentList(context.getArguments(), true);
        String sourcePath = this.getArgumentValue(ARG_REQ_SOURCE_PATH, context.getArguments(), null);
        String targetPath = this.getArgumentValue(ARG_OPT_TARGET_PATH, context.getArguments(), null);
        String[] sourceFileNames = sourcePath.split(",");
        if (sourceFileNames.length == 1) {
            this.mergePluginFilesFromDir(context.getCommandConsole(), sourcePath, targetPath);
        } else {
            this.mergePluginFilesFromList(context.getCommandConsole(), sourceFileNames, targetPath);
        }
    }

    public String getTaskUsage() {
        return CommandUtils.getMessage("MergePluginFilesTask.usage.options", "");
    }

    public String getTaskHelp() {
        String footer = this.getOption("global.options", new Object[0]) + NL + this.buildScriptOptions("MergePluginFilesTask.required-option-key.sourcePath", "MergePluginFilesTask.required-option-desc.sourcePath") + this.buildScriptOptions("MergePluginFilesTask.required-option-key.targetPath", "MergePluginFilesTask.required-option-desc.targetPath") + NL;
        return this.getTaskHelp("MergePluginFilesTask.desc", "MergePluginFilesTask.usage.options", null, null, null, footer, this.scriptName);
    }

    public String getTaskDescription() {
        StringBuilder scriptHelp = new StringBuilder();
        String UseOption = this.getOption("MergePluginFilesTask.usage.options", new Object[0]);
        UseOption = "\t" + UseOption.substring(5);
        scriptHelp.append(UseOption);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("MergePluginFilesTask.desc", new Object[0]));
        scriptHelp.append(NL);
        return scriptHelp.toString();
    }

    private void mergePluginFilesFromList(CommandConsole console, String[] sourceFileNames, String targetPath) {
        console.printlnInfoMessage(this.getMessage("MergePluginFilesTask.merging.plugin.list", new Object[0]));
        for (String strFile : sourceFileNames) {
            File file = new File(strFile);
            if (!file.exists()) {
                this.abort(console, this.getMessage("MergePluginFilesTask.merging.plugin.file.not.exists", strFile));
                return;
            }
            if (!file.isDirectory()) continue;
            this.abort(console, this.getMessage("MergePluginFilesTask.merging.plugin.file.is.directory", file.getAbsolutePath()));
            return;
        }
        String strTargetDir = System.getProperty(CURRENT_DIR);
        if (targetPath == null) {
            targetPath = strTargetDir + File.separator + TARGET_MERGED_FILE_NAME;
        } else {
            File targetPathFile = new File(targetPath);
            if (targetPathFile.exists() && targetPathFile.isDirectory()) {
                targetPath = targetPath + File.separator + TARGET_MERGED_FILE_NAME;
            }
        }
        console.printlnInfoMessage(this.getMessage("MergePluginFilesTask.merging.plugin.target.file.generating", targetPath));
        String[] args = new String[sourceFileNames.length + 1];
        System.arraycopy(sourceFileNames, 0, args, 0, sourceFileNames.length);
        args[sourceFileNames.length] = targetPath;
        this.merge(args);
        console.printlnInfoMessage(this.getMessage("MergePluginFilesTask.merging.plugin.target.file.generated", new Object[0]));
    }

    private void mergePluginFilesFromDir(final CommandConsole console, String sourcePath, String targetPath) {
        console.printlnInfoMessage(this.getMessage("MergePluginFilesTask.merging.plugin.dir", sourcePath));
        File sourcePathFile = new File(sourcePath);
        if (!sourcePathFile.exists()) {
            this.abort(console, this.getMessage("MergePluginFilesTask.merging.plugin.source.dir.not.exists", sourcePathFile));
            return;
        }
        if (!sourcePathFile.isDirectory()) {
            this.abort(console, this.getMessage("MergePluginFilesTask.merging.plugin.source.file.not.directory", sourcePathFile));
            return;
        }
        File[] files = sourcePathFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean result = name.matches(MergePluginFilesTask.FILE_SELECT_REG_EXP);
                if (result) {
                    console.printlnInfoMessage(MergePluginFilesTask.this.getMessage("MergePluginFilesTask.merging.plugin.source.file.selected", name));
                }
                return result;
            }
        });
        String strTargetDir = System.getProperty(CURRENT_DIR);
        if (targetPath == null) {
            targetPath = strTargetDir + File.separator + TARGET_MERGED_FILE_NAME;
        } else {
            File targetPathFile = new File(targetPath);
            if (targetPathFile.exists() && targetPathFile.isDirectory()) {
                targetPath = targetPath + File.separator + TARGET_MERGED_FILE_NAME;
            }
        }
        console.printlnInfoMessage(this.getMessage("MergePluginFilesTask.merging.plugin.target.file.generating", targetPath));
        String[] sourceFileNames = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            sourceFileNames[i] = files[i].getAbsolutePath();
        }
        String[] args = new String[sourceFileNames.length + 1];
        System.arraycopy(sourceFileNames, 0, args, 0, sourceFileNames.length);
        args[sourceFileNames.length] = targetPath;
        this.merge(args);
        console.printlnInfoMessage(this.getMessage("MergePluginFilesTask.merging.plugin.target.file.generated", new Object[0]));
    }

    private void merge(String[] args) {
        PluginMergeTool mergeTool = PluginMergeToolFactory.getMergeToolInstance();
        mergeTool.merge(args);
    }
}

