/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.xml.internal.ConfigurationInfo;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ExtendedMetatypeManager {
    static final TraceComponent tc = Tr.register(ExtendedMetatypeManager.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final String EXT_SOURCE_PID_KEY = "ibm.extends.source.pid";
    public static final String EXT_IMMEDIATE_SUBTYPE_PID_KEY = "ibm.extends.subtype.pid";
    private static final String EXT_SOURCE_FACTORY_KEY = "ibm.extends.source.factoryPid";
    private final MetaTypeRegistry metatypeRegistry;
    private final ConfigurationAdmin configAdmin;
    private final HashMap<String, ExtendedConfiguration> knownSupertypeConfigs = new HashMap();
    private static int index = -1;
    static final long serialVersionUID = -5964489346879728611L;

    public ExtendedMetatypeManager(MetaTypeRegistry metatypeRegistry, ConfigurationAdmin ca) {
        this.metatypeRegistry = metatypeRegistry;
        this.configAdmin = ca;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        try {
            ExtendedConfiguration[] superTypeConfigs = (ExtendedConfiguration[])this.configAdmin.listConfigurations("(ibm.extends.source.pid=*)");
            if (superTypeConfigs != null) {
                for (ExtendedConfiguration superTypeConfig : superTypeConfigs) {
                    String subTypeConfigPid = (String)superTypeConfig.getProperties().get(EXT_IMMEDIATE_SUBTYPE_PID_KEY);
                    if (subTypeConfigPid == null) {
                        subTypeConfigPid = (String)superTypeConfig.getProperties().get(EXT_SOURCE_PID_KEY);
                    }
                    this.knownSupertypeConfigs.put(subTypeConfigPid, superTypeConfig);
                }
            }
        }
        catch (InvalidSyntaxException superTypeConfigs) {
            void e;
            FFDCFilter.processException((Throwable)superTypeConfigs, (String)"com.ibm.ws.config.xml.internal.ExtendedMetatypeManager", (String)"66", (Object)this, (Object[])new Object[0]);
            e.getCause();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ExtendedMetatypeManager", (String)"68", (Object)this, (Object[])new Object[0]);
            e.getCause();
        }
    }

    public void createSuperTypes(ConfigurationInfo info) {
        if (info.ocd != null && info.ocd.getExtends() != null) {
            if (info.config.getFactoryPid() == null) {
                Tr.error((TraceComponent)tc, (String)"error.factoryOnly", (Object[])new Object[]{info.config.getPid(), info.ocd.getExtends()});
            } else {
                this.createSuperTypes(info, info.ocd.getExtends(), info.config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSuperTypes(ConfigurationInfo info, String superFactoryPid, ExtendedConfiguration leafTypeConfig) {
        ExtendedConfiguration subTypeConfig = leafTypeConfig;
        try {
            boolean requireActualUpdate = info.ocd.supportsHiddenExtensions();
            while (superFactoryPid != null) {
                MetaTypeRegistry.RegistryEntry re;
                ExtendedConfiguration config = null;
                HashMap<String, ExtendedConfiguration> hashMap = this.knownSupertypeConfigs;
                synchronized (hashMap) {
                    config = this.knownSupertypeConfigs.get(subTypeConfig.getPid());
                    if (config == null) {
                        config = (ExtendedConfiguration)this.configAdmin.createFactoryConfiguration(superFactoryPid, null);
                        String id = subTypeConfig.getFullId().getId();
                        if (id != null && id.startsWith("default-")) {
                            id = "extends-" + ++index;
                        }
                        config.setFullId(new ConfigID(superFactoryPid, id));
                        this.knownSupertypeConfigs.put(subTypeConfig.getPid(), config);
                    }
                }
                Dictionary<String, Object> properties = subTypeConfig.getProperties();
                if (properties != null) {
                    this.renameProps(subTypeConfig.getFactoryPid(), properties);
                    if (properties.get(EXT_SOURCE_PID_KEY) == null) {
                        properties.put(EXT_SOURCE_PID_KEY, leafTypeConfig.getPid());
                        properties.put(EXT_SOURCE_FACTORY_KEY, leafTypeConfig.getFactoryPid());
                    }
                    properties.put(EXT_IMMEDIATE_SUBTYPE_PID_KEY, subTypeConfig.getPid());
                    properties.put("config.id", config.getFullId().toString());
                    properties.remove("config.parentPID");
                    if (this.requiresUpdate(requireActualUpdate, config, properties)) {
                        config.updateProperties(properties);
                    }
                    info.addSuperTypeConfig(config);
                }
                if ((re = this.metatypeRegistry.getRegistryEntry(superFactoryPid)) == null) {
                    return;
                }
                if (re.getObjectClassDefinition().getExtends() != null) {
                    superFactoryPid = re.getObjectClassDefinition().getExtends();
                    subTypeConfig = config;
                    requireActualUpdate |= re.getObjectClassDefinition().supportsHiddenExtensions();
                    continue;
                }
                return;
            }
        }
        catch (IOException requireActualUpdate) {
            FFDCFilter.processException((Throwable)requireActualUpdate, (String)"com.ibm.ws.config.xml.internal.ExtendedMetatypeManager", (String)"156", (Object)this, (Object[])new Object[]{info, superFactoryPid, leafTypeConfig});
        }
    }

    private boolean requiresUpdate(boolean requireActualUpdate, ExtendedConfiguration config, Dictionary<String, Object> properties) {
        Dictionary<String, Object> existingProperties;
        if (requireActualUpdate && (existingProperties = config.getProperties()) != null) {
            return !this.equals(existingProperties, properties);
        }
        return true;
    }

    private boolean equals(Dictionary<String, Object> cd, Dictionary<String, Object> otherCD) {
        int otherId;
        boolean result = true;
        int thisId = cd.get("id") == null ? 0 : 1;
        int n = otherId = otherCD.get("id") == null ? 0 : 1;
        if (otherCD.size() - otherId == cd.size() - thisId) {
            Enumeration<String> keys = cd.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (key.equals("service.pid") || key.equals("service.factoryPid")) continue;
                Object value = cd.get(key);
                Object otherValue = otherCD.get(key);
                if (otherValue == null) {
                    result = key.equals("id");
                }
                if (value == otherValue) continue;
                if (value instanceof String[] && otherValue instanceof String[]) {
                    if (Arrays.equals((String[])value, (String[])otherValue)) continue;
                    result = false;
                    continue;
                }
                if (value.equals(otherValue)) continue;
                result = false;
            }
        } else {
            result = false;
        }
        if (!result && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("differing configurations old: " + cd + "\n new: " + otherCD), (Object[])new Object[0]);
        }
        return result;
    }

    private final void renameProps(String pid, Dictionary<String, Object> properties) {
        for (Map.Entry<String, String> renameMapping : this.getRenameMappings(pid).entrySet()) {
            Object value = properties.get(renameMapping.getKey());
            if (value == null) continue;
            properties.put(renameMapping.getValue(), value);
        }
    }

    private final Map<String, String> getRenameMappings(String pid) {
        HashMap<String, String> renameMappings = new HashMap<String, String>();
        MetaTypeRegistry.RegistryEntry pidEntry = this.metatypeRegistry.getRegistryEntry(pid);
        String superPid = pidEntry.getExtends();
        if (superPid != null) {
            for (Map.Entry<String, ExtendedAttributeDefinition> entry : pidEntry.getObjectClassDefinition().getAttributeMap().entrySet()) {
                String rename = entry.getValue().getRename();
                if (rename == null) continue;
                renameMappings.put(entry.getKey(), rename);
            }
        }
        return renameMappings;
    }

    public void deleteSuperType(String pid) {
        ExtendedConfiguration c;
        while ((c = this.removeSuperTypeForPid(pid)) != null) {
            pid = c.getPid();
            c.delete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedConfiguration removeSuperTypeForPid(String pid) {
        HashMap<String, ExtendedConfiguration> hashMap = this.knownSupertypeConfigs;
        synchronized (hashMap) {
            return this.knownSupertypeConfigs.remove(pid);
        }
    }

    public Configuration getSuperTypeConfig(String pid) {
        return this.knownSupertypeConfigs.get(pid);
    }
}

