/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ConfigExpressionScanner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
abstract class ConfigExpressionEvaluator {
    private long subtotal;
    private String resultExpr;
    private long value;
    private static final String SERVICE_PID_UNMATCHED_FILTER = "(service.pid=unbound)";
    static final long serialVersionUID = 980579380494791468L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ConfigExpressionEvaluator() {
    }

    abstract String getProperty(String var1) throws ConfigEvaluatorException;

    abstract Object getPropertyObject(String var1) throws ConfigEvaluatorException;

    String evaluateExpression(String expr) throws ConfigEvaluatorException {
        ConfigExpressionScanner scanner = new ConfigExpressionScanner(expr);
        if (!this.parseOperand(expr, scanner, true)) {
            return null;
        }
        if (this.resultExpr != null) {
            return scanner.end() ? this.resultExpr : null;
        }
        this.subtotal = this.value;
        while (!scanner.end()) {
            ConfigExpressionScanner.NumericOperator op = scanner.scanNumericOperator();
            if (op == null) {
                return null;
            }
            if (!this.parseOperand(expr, scanner, false) || this.resultExpr != null) {
                return null;
            }
            this.subtotal = op.evaluate(this.subtotal, this.value);
        }
        return String.valueOf(this.subtotal);
    }

    private boolean parseOperand(String expr, ConfigExpressionScanner scanner, boolean initial) throws ConfigEvaluatorException {
        String value;
        String name = scanner.scanName();
        if (name == null) {
            Long value2 = scanner.scanLong();
            if (value2 == null) {
                return false;
            }
            this.value = value2;
            return true;
        }
        if (scanner.scan('(')) {
            String argName = scanner.scanName();
            if (argName != null && scanner.scan(')')) {
                if (name.equals("servicePidOrFilter")) {
                    this.resultExpr = this.evaluateServicePidOrFilterExpression(this.getPropertyObject(argName));
                    return this.resultExpr != null && initial;
                }
                if (name.equals("count")) {
                    this.value = this.evaluateCountExpression(this.getPropertyObject(argName));
                    return true;
                }
            } else {
                return false;
            }
        }
        if ((value = this.getProperty(name)) == null) {
            return false;
        }
        this.value = Long.parseLong(value);
        return true;
    }

    private String evaluateServicePidOrFilterExpression(Object value) {
        if (value == null) {
            return SERVICE_PID_UNMATCHED_FILTER;
        }
        if (value instanceof String) {
            return FilterUtils.createPropertyFilter((String)"service.pid", (String)((String)value));
        }
        if (value instanceof String[]) {
            return this.evaluateServicePidOrFilterExpression(Arrays.asList((String[])value));
        }
        if (value instanceof Vector) {
            return this.evaluateServicePidOrFilterExpression((Vector)value);
        }
        return null;
    }

    private String evaluateServicePidOrFilterExpression(List<?> pids) {
        int size = pids.size();
        if (size > 0) {
            StringBuilder b = new StringBuilder();
            if (size != 1) {
                b.append("(|");
            }
            for (Object pid : pids) {
                if (!(pid instanceof String)) {
                    return null;
                }
                b.append(FilterUtils.createPropertyFilter((String)"service.pid", (String)((String)pid)));
            }
            if (pids.size() != 1) {
                b.append(')');
            }
            return b.toString();
        }
        return SERVICE_PID_UNMATCHED_FILTER;
    }

    private int evaluateCountExpression(Object value) {
        if (value == null) {
            return 0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        if (value instanceof Vector) {
            return ((Vector)value).size();
        }
        return 1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConfigExpressionEvaluator.class);
    }
}

