/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.ws.ffdc.FFDCConfigurator;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.logging.internal.impl.FileLogSet;
import com.ibm.ws.logging.internal.impl.IntrospectionLevel;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public final class IncidentStreamImpl
implements IncidentStream,
Closeable {
    private static final int DEFAULT_DEPTH = 1;
    private static final int DEFAULT_MAX_SIZE = 0x100000;
    private static final String EQUALS = " = ";
    protected final PrintStream ffdcLog;
    protected final File ffdcFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncidentStreamImpl(FileLogSet fileLogSet) throws IOException {
        TextFileOutputStreamFactory factory = FFDCConfigurator.getFileOutputStreamFactory();
        Object token = ThreadIdentityManager.runAsServer();
        try {
            FileLogSet fileLogSet2 = fileLogSet;
            synchronized (fileLogSet2) {
                this.ffdcFile = LoggingFileUtils.createNewFile(fileLogSet);
            }
            this.ffdcLog = new PrintStream(factory.createOutputStream(this.ffdcFile));
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public IncidentStreamImpl(OutputStream ffdcLogStream) {
        this.ffdcFile = null;
        this.ffdcLog = new PrintStream(ffdcLogStream);
    }

    File getFile() {
        return this.ffdcFile;
    }

    void printStackTrace(Throwable t) {
        t.printStackTrace(this.ffdcLog);
    }

    @Override
    public void close() {
        this.ffdcLog.close();
    }

    @Override
    public void introspectAndWrite(String text, Object value) {
        this.ffdcLog.println(text);
        this.introspect(value, 1, 0x100000);
    }

    @Override
    public void introspectAndWrite(String text, Object value, int depth) {
        this.ffdcLog.println(text);
        this.introspect(value, depth, 0x100000);
    }

    @Override
    public void introspectAndWrite(String text, Object value, int depth, int maxBytes) {
        this.ffdcLog.println(text);
        this.introspect(value, depth, maxBytes);
    }

    @Override
    public void introspectAndWriteLine(String text, Object value) {
        this.introspectAndWrite(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void introspectAndWriteLine(String text, Object value, int depth) {
        this.introspectAndWrite(text, value, depth);
        this.ffdcLog.println();
    }

    @Override
    public void introspectAndWriteLine(String text, Object value, int depth, int maxBytes) {
        this.introspectAndWrite(text, value, depth, maxBytes);
        this.ffdcLog.println();
    }

    @Override
    public void write(String text, boolean value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, byte value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, char value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, short value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, int value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, long value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, float value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, double value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, String value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    @Override
    public void write(String text, Object value) {
        this.printValueIntro(text);
        this.ffdcLog.print(value);
    }

    private void printValueIntro(String text) {
        if (text != null) {
            this.ffdcLog.print(text);
            this.ffdcLog.print(EQUALS);
        }
    }

    @Override
    public void writeLine(String text, boolean value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, byte value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, char value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, short value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, int value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, long value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, float value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, double value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, String value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    @Override
    public void writeLine(String text, Object value) {
        this.write(text, value);
        this.ffdcLog.println();
    }

    private void introspect(Object value, int max_depth, int max_size) {
        if (value == null) {
            this.ffdcLog.print("null");
        } else {
            int actualDepth;
            IntrospectionLevel rootLevel;
            IntrospectionLevel currentLevel = rootLevel = new IntrospectionLevel(value);
            IntrospectionLevel nextLevel = rootLevel.getNextLevel();
            int totalBytes = currentLevel.getNumberOfBytesinJustThisLevel();
            for (actualDepth = 0; actualDepth < max_depth && nextLevel.hasMembers() && totalBytes <= max_size; totalBytes += currentLevel.getNumberOfBytesinJustThisLevel(), ++actualDepth) {
                totalBytes -= currentLevel.getNumberOfBytesinJustThisLevel();
                totalBytes += currentLevel.getNumberOfBytesInAllLevelsIncludingThisOne();
                currentLevel = nextLevel;
                nextLevel = nextLevel.getNextLevel();
            }
            boolean exceededMaxBytes = false;
            if (totalBytes > max_size && actualDepth > 0) {
                --actualDepth;
                exceededMaxBytes = true;
            }
            rootLevel.print(this, actualDepth);
            if (exceededMaxBytes) {
                this.ffdcLog.println("Only " + actualDepth + " levels of object introspection were performed because performing the next level would have exceeded the specified maximum bytes of " + max_size);
            }
        }
    }
}

