/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi.hpel;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

abstract class AbstractHPELConfigService
implements ManagedService {
    private static final TraceComponent tc = Tr.register(AbstractHPELConfigService.class);
    private final ServiceRegistration<ManagedService> configRef;
    private final String pid;

    AbstractHPELConfigService(BundleContext context, String pid) {
        this.pid = pid;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("service.pid", pid);
        this.configRef = context.registerService(ManagedService.class, (Object)this, ht);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("HPEL properties updated for pid " + this.pid + ", properties=" + properties), (Object[])new Object[0]);
        }
        if (properties == null) {
            return;
        }
        HashMap<String, Object> newMap = null;
        if (properties instanceof Map) {
            newMap = (HashMap<String, Object>)((Object)properties);
        } else {
            newMap = new HashMap<String, Object>();
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                newMap.put(key, properties.get(key));
            }
        }
        this.forwardUpdated(newMap);
    }

    void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Stopping the HPEL managed service", (Object[])new Object[0]);
        }
        this.configRef.unregister();
    }

    abstract void forwardUpdated(Map<String, Object> var1);
}

