/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.internal;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.zos.core.utils.internal.NativeUtilsImpl;

@Trivial
public class NativeTraceHeader {
    static final int NATIVE_TRACE_PROBLEM_STATE = 1;
    static final int NATIVE_TRACE_SUPERVISOR_STATE = 0;
    static final int NATIVE_TRACE_KEY_8 = 8;
    static final int NATIVE_TRACE_KEY_2 = 2;
    private final int tracePoint;
    private final int tcbAddress;
    private final int key;
    private final int state;
    private final long createTime;

    public NativeTraceHeader(int tracePoint, int tcbAddress, int key, int state, long createTime) {
        this.tracePoint = tracePoint;
        this.tcbAddress = tcbAddress;
        this.key = key;
        this.state = state;
        this.createTime = createTime;
    }

    public String toString() {
        long createTimeMillis = NativeUtilsImpl.getStckMillis(this.createTime);
        StringBuilder sb = new StringBuilder("Trace: ");
        sb.append(DataFormatHelper.formatTime((long)createTimeMillis));
        sb.append(" t=").append(Integer.toHexString(this.tcbAddress)).append(" key=");
        if (this.state == 1) {
            sb.append("P");
        } else {
            sb.append("S");
        }
        sb.append(Integer.toHexString(this.key));
        sb.append(" (").append(Integer.toHexString(this.tracePoint)).append(")");
        return sb.toString();
    }
}

