/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.TraceComponentChangeListener;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.utils.DirectBufferHelper;
import com.ibm.ws.zos.core.utils.internal.DoubleGutterImpl;
import com.ibm.ws.zos.logging.internal.NativeTraceHeader;
import com.ibm.ws.zos.logging.internal.TraceListenerThread;
import com.ibm.ws.zos.logging.internal.TracedData;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

@Trivial
public class NativeTraceHandler
extends DoubleGutterImpl
implements TraceComponentChangeListener {
    private static final TraceComponent tc = Tr.register(NativeTraceHandler.class);
    private static final int MAX_STACK_SIZE = 0x400000;
    private static final String ZOS_NATIVE_PREFIX = "zos.native";
    private static final String ZOS_NATIVE_TRACE_GROUP = "zNative";
    private static final String ZOS_TRACE_PREFIX = "zos.trace";
    private static final String ZOS_TRACE_GROUP = "zTrace";
    private static final String ZOS_TRACE_COMPONENT = "06";
    private static int AGGREGATE_NATIVE_TRACE_LEVEL = 3;
    private boolean nativeAvailable = true;
    static final int TRC_KEY_RAW_DATA = 1;
    static final int TRC_KEY_EBCDIC_STRING = 2;
    static final int TRC_KEY_INT = 3;
    static final int TRC_KEY_DOUBLE = 4;
    static final int TRC_KEY_POINTER = 5;
    static final int TRC_KEY_LONG = 6;
    static final int TRC_KEY_SHORT = 7;
    static final int TRC_KEY_CHAR = 8;
    static final int TRC_KEY_HEX_INT = 9;
    static final int TRC_KEY_HEX_LONG = 10;
    private static final int TRC_LEVEL_NONE = 0;
    private static final int TRCE_LEVEL_EXCEPTION = 1;
    private static final int TRC_LEVEL_BASIC = 2;
    private static final int TRC_LEVEL_DETAILED = 3;
    private static ConcurrentHashMap<String, TraceComponent> traceComponents = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, NativeTraceComponentDefinition> traceComponentDefs = new ConcurrentHashMap();
    private static NativeTraceComponentDefinition[] testDefs = null;
    private TraceListenerThread thread = null;
    private final Charset ebcdicCharset = Charset.forName("IBM-1047");
    private final ThreadLocal<CharsetDecoder> ebcdicDecoder = new ThreadLocal<CharsetDecoder>(){
        static final long serialVersionUID = 3183685819873568002L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public CharsetDecoder initialValue() {
            return NativeTraceHandler.this.ebcdicCharset.newDecoder();
        }

        @Override
        @Trivial
        public CharsetDecoder get() {
            return ((CharsetDecoder)super.get()).reset();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private static volatile ServiceTracker<DirectBufferHelper, DirectBufferHelper> DirectBufferHelperTracker = null;

    protected synchronized DirectBufferHelper getDirectBufferInstance() {
        if (DirectBufferHelperTracker == null) {
            Bundle bundle = FrameworkUtil.getBundle(DirectBufferHelper.class);
            if (bundle == null) {
                return null;
            }
            BundleContext bc = bundle.getBundleContext();
            ServiceTracker tmp = new ServiceTracker(bc, DirectBufferHelper.class.getName(), null);
            tmp.open();
            DirectBufferHelperTracker = tmp;
        }
        return (DirectBufferHelper)DirectBufferHelperTracker.getService();
    }

    public NativeTraceHandler(NativeMethodManager nativeMethodManager) {
        Object[] callbackData = new Object[]{this, "writeNativeTrace"};
        nativeMethodManager.registerNatives(NativeTraceHandler.class, callbackData);
        this.initializeTraceDefinitions();
        TrConfigurator.addTraceComponentListener((TraceComponentChangeListener)this);
    }

    NativeTraceHandler(DirectBufferHelper bufferHelper, NativeTraceComponentDefinition[] testDefs) {
        NativeTraceHandler.testDefs = testDefs;
        this.nativeAvailable = false;
        this.initializeTraceDefinitions();
        TrConfigurator.addTraceComponentListener((TraceComponentChangeListener)this);
    }

    public void startTraceHandlerThread() {
        this.thread = AccessController.doPrivileged(new PrivilegedAction<TraceListenerThread>(){
            static final long serialVersionUID = -2046025251445026260L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public TraceListenerThread run() {
                return new TraceListenerThread(NativeTraceHandler.this);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        this.thread.start();
    }

    public void stopTraceHandlerWriter() {
        this.thread.end();
    }

    String getString(long address, int stringLength) {
        CharsetDecoder decoder = this.ebcdicDecoder.get();
        DirectBufferHelper bufferHelper = this.getDirectBufferInstance();
        ByteBuffer bb = bufferHelper.getSlice(address, stringLength);
        String string = null;
        try {
            string = decoder.decode(bb).toString();
        }
        catch (CharacterCodingException cce) {
            string = "<DECODE ERROR>";
        }
        return string;
    }

    String getString(ByteBuffer bb) {
        int length = (int)bb.getLong();
        long address = bb.getLong();
        return this.getString(address, length);
    }

    boolean readyToMapNative() {
        return this.getDirectBufferInstance() != null;
    }

    public int writeNativeTrace(int nativeTraceLevel, int tracePoint, long vaListPointer, long createTime, int tcbAddress, int state, int key) {
        boolean isLoggable;
        if (nativeTraceLevel == 0 || tracePoint == 0 || vaListPointer == 0L) {
            return -2;
        }
        String hexString = Integer.toHexString(tracePoint);
        if (hexString.length() == 7) {
            hexString = "0" + hexString;
        }
        String componentId = hexString.substring(0, 2);
        String moduleId = hexString.substring(2, 5);
        String tracePointId = hexString.substring(5, 8);
        int tpNum = Integer.parseInt(tracePointId, 16);
        int tracePointKey = tracePoint - tpNum;
        String tcName = this.mapNativeComponentToNamedLogger(componentId, moduleId);
        TraceComponent tcNative = this.getTraceComponent(tcName, tracePointKey);
        if (tcNative == null) {
            return -3;
        }
        boolean bl = isLoggable = tcNative.isDebugEnabled() || tcNative.isEventEnabled() || tcNative.isEntryEnabled();
        if (isLoggable && this.readyToMapNative()) {
            try {
                Object[] traceData = this.getTraceObjects(vaListPointer).toArray();
                NativeTraceHeader nativeTraceHeader = new NativeTraceHeader(tracePoint, tcbAddress, key, state, createTime);
                this.logTrace(nativeTraceLevel, tcNative, nativeTraceHeader.toString(), traceData);
            }
            catch (Throwable t) {
                return -1;
            }
        }
        return 0;
    }

    List<TracedData> getTraceObjects(long vaListPointer) {
        DirectBufferHelper bufferHelper = this.getDirectBufferInstance();
        ByteBuffer vaList = bufferHelper.getSlice(vaListPointer, 0x400000);
        ArrayList<TracedData> traceObjects = new ArrayList<TracedData>();
        int traceKey = (int)vaList.getLong();
        while (traceKey > 0) {
            short itemLength = (short)vaList.getLong();
            long item = vaList.getLong();
            String description = this.getString(vaList);
            TracedData data = null;
            switch (traceKey) {
                case 1: {
                    byte[] rawData = new byte[item == 0L ? (short)0 : itemLength];
                    bufferHelper.get(item, rawData);
                    data = new TracedData(traceKey, description, rawData, this.asDoubleGutter(item, rawData));
                    break;
                }
                case 3: {
                    Integer i = (int)item;
                    data = new TracedData(traceKey, description, i, i.toString());
                    break;
                }
                case 6: {
                    Long l = item;
                    data = new TracedData(traceKey, description, l, l.toString());
                    break;
                }
                case 7: {
                    Short s = (short)item;
                    data = new TracedData(traceKey, description, s, s.toString());
                    break;
                }
                case 4: {
                    Double d = Double.longBitsToDouble(item);
                    data = new TracedData(traceKey, description, d, d.toString());
                    break;
                }
                case 2: {
                    String string = this.getString(item, itemLength);
                    data = new TracedData(traceKey, description, string, string);
                    break;
                }
                case 9: {
                    data = new TracedData(traceKey, description, (int)item, Integer.toHexString((int)item));
                    break;
                }
                case 10: {
                    data = new TracedData(traceKey, description, item, Long.toHexString(item));
                    break;
                }
                case 5: {
                    data = new TracedData(traceKey, description, item, String.format("%016x", item));
                    break;
                }
                case 8: {
                    char c = new String(new byte[]{(byte)item}, this.ebcdicCharset).charAt(0);
                    data = new TracedData(traceKey, description, Character.valueOf(c), Character.toString(c));
                    break;
                }
                default: {
                    data = new TracedData(traceKey, "", item, "<UNKNOWN TRACE KEY>");
                }
            }
            traceObjects.add(data);
            traceKey = (int)vaList.getLong();
        }
        return traceObjects;
    }

    private void logTrace(int nativeTraceLevel, TraceComponent tc, String msg, Object[] traceObjects) {
        switch (nativeTraceLevel) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                if (!tc.isEventEnabled()) break;
                Tr.event((TraceComponent)tc, (String)msg, (Object[])traceObjects);
                break;
            }
            case 3: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)msg, (Object[])traceObjects);
                    break;
                }
                if (!tc.isEntryEnabled()) break;
                Tr.entry((TraceComponent)tc, (String)msg, (Object[])traceObjects);
                break;
            }
        }
    }

    private TraceComponent getTraceComponent(String numericName, int tracepoint) {
        TraceComponent tcNative = null;
        NativeTraceComponentDefinition def = null;
        String name = null;
        tcNative = traceComponents.get(numericName);
        if (tcNative == null) {
            return null;
        }
        if (tcNative.isDebugEnabled() || tcNative.isEventEnabled() || tcNative.isEntryEnabled()) {
            return tcNative;
        }
        def = traceComponentDefs.get(tracepoint);
        if (def == null) {
            return null;
        }
        name = def.getName();
        if (name == null) {
            return null;
        }
        tcNative = traceComponents.get(name);
        return tcNative;
    }

    private String mapNativeComponentToNamedLogger(String componentId, String moduleId) {
        String loggerName = null;
        String prefix = null;
        prefix = componentId.equalsIgnoreCase(ZOS_TRACE_COMPONENT) ? ZOS_TRACE_PREFIX : ZOS_NATIVE_PREFIX;
        loggerName = moduleId.equalsIgnoreCase("000") ? prefix + "." + componentId : prefix + "." + componentId + "." + moduleId;
        return loggerName;
    }

    private void initializeTraceDefinitions() {
        traceComponentDefs.clear();
        traceComponents.clear();
        NativeTraceComponentDefinition[] defs = null;
        if (this.nativeAvailable) {
            defs = this.ntv_getNativeTraceComponents();
            if (defs == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"initializeTraceDefinitions, Native trace components are missing", (Object[])new Object[0]);
                }
                return;
            }
        } else {
            if (testDefs == null) {
                return;
            }
            defs = testDefs;
        }
        String loggerName = ZOS_NATIVE_PREFIX;
        TraceComponent nativeTc = Tr.register((String)loggerName, (Class)null, (String)ZOS_NATIVE_TRACE_GROUP);
        traceComponents.put(loggerName, nativeTc);
        loggerName = ZOS_TRACE_PREFIX;
        nativeTc = Tr.register((String)loggerName, (Class)null, (String)ZOS_TRACE_GROUP);
        traceComponents.put(loggerName, nativeTc);
        for (NativeTraceComponentDefinition def : defs) {
            traceComponentDefs.put(def.getId(), def);
            String hexString = Integer.toHexString(def.getId());
            if (hexString.length() == 7) {
                hexString = "0" + hexString;
            }
            String componentId = hexString.substring(0, 2);
            String moduleId = hexString.substring(2, 5);
            loggerName = this.mapNativeComponentToNamedLogger(componentId, moduleId);
            String[] groups = null;
            if (!def.getGroups().isEmpty()) {
                groups = def.getGroups().toArray(new String[def.getGroups().size()]);
            }
            nativeTc = Tr.register((String)loggerName, (Class)null, groups);
            traceComponents.put(loggerName, nativeTc);
            if (def.getName().length() <= 0) continue;
            nativeTc = Tr.register((String)def.getName(), (Class)null, (String[])groups);
            traceComponents.put(def.getName(), nativeTc);
        }
        this.updateAggregateTraceLevel();
    }

    public void traceComponentRegistered(TraceComponent tc) {
    }

    public void traceComponentUpdated(TraceComponent tc) {
        this.updateAggregateTraceLevel();
    }

    private void updateAggregateTraceLevel() {
        if (traceComponents.isEmpty()) {
            return;
        }
        int highestNativeTraceLevel = 0;
        Enumeration<TraceComponent> tcs = traceComponents.elements();
        while (tcs.hasMoreElements()) {
            TraceComponent nativeTc = tcs.nextElement();
            int nativeTraceLevel = this.getNativeTraceLevel(nativeTc);
            if (nativeTraceLevel <= highestNativeTraceLevel) continue;
            highestNativeTraceLevel = nativeTraceLevel;
        }
        if (highestNativeTraceLevel != AGGREGATE_NATIVE_TRACE_LEVEL) {
            AGGREGATE_NATIVE_TRACE_LEVEL = highestNativeTraceLevel;
            if (this.nativeAvailable) {
                this.ntv_setTraceLevel(AGGREGATE_NATIVE_TRACE_LEVEL);
            }
        }
    }

    private int getNativeTraceLevel(TraceComponent tcNative) {
        int nativeTraceLevel = 0;
        if (tcNative.isDebugEnabled()) {
            nativeTraceLevel = 3;
        } else if (tcNative.isEventEnabled()) {
            nativeTraceLevel = 2;
        } else if (tcNative.isEntryEnabled()) {
            nativeTraceLevel = 3;
        }
        return nativeTraceLevel;
    }

    protected native long ntv_getThreadElement();

    protected native byte[] ntv_getTraces(long var1);

    protected native int ntv_stopListeningForTraces(long var1);

    protected native int ntv_traceWritten(long var1);

    protected native void ntv_setTraceLevel(int var1);

    protected native NativeTraceComponentDefinition[] ntv_getNativeTraceComponents();

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class NativeTraceComponentDefinition {
        private int id = 0;
        private String name = "";
        private ArrayList<String> groups;
        static final long serialVersionUID = -3506462965678206924L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        NativeTraceComponentDefinition(int id, String name, String groups) {
            this.setId(id);
            this.setName(name);
            this.setGroups(groups);
        }

        private void setId(int id) {
            this.id = id;
        }

        private void setName(String name) {
            if (name != null) {
                this.name = name;
            }
        }

        private void setGroups(String nativeGroups) {
            this.groups = new ArrayList();
            if (nativeGroups == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(nativeGroups, ",");
            while (st.hasMoreElements()) {
                String aGroup = (String)st.nextElement();
                this.groups.add(aGroup);
            }
        }

        protected int getId() {
            return this.id;
        }

        protected String getName() {
            return this.name;
        }

        protected ArrayList<String> getGroups() {
            return this.groups;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NativeTraceComponentDefinition.class);
        }
    }
}

