/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import java.nio.ByteBuffer;

@Trivial
public class NativeTraceData {
    private int traceLevel;
    private int tracePoint;
    private long varargListPointer;
    private long traceCreateTime;
    private int traceCreateTcb;
    private int traceCreateState;
    private int traceCreateKey;
    protected static final int TRACE_LEVEL_OFFSET = 0;
    protected static final int TRACE_POINT_OFFSET = 4;
    protected static final int VA_LIST_OFFSET = 8;
    protected static final int TRACE_CREATE_TIME_OFFSET = 16;
    protected static final int TRACE_CREATE_TCB_OFFSET = 24;
    protected static final int TRACE_CREATE_STATE_OFFSET = 28;
    protected static final int TRACE_CREATE_KEY_OFFSET = 32;

    public NativeTraceData(byte[] nativeNTD) {
        if (nativeNTD != null && nativeNTD.length != 0) {
            byte[] traceData = nativeNTD;
            ByteBuffer buf = ByteBuffer.wrap(traceData);
            this.traceLevel = buf.getInt(0);
            this.tracePoint = buf.getInt(4);
            this.varargListPointer = buf.getLong(8);
            this.traceCreateTime = buf.getLong(16);
            this.traceCreateTcb = buf.getInt(24);
            this.traceCreateState = buf.getInt(28);
            this.traceCreateKey = buf.getInt(32);
        }
    }

    int getTraceLevel() {
        return this.traceLevel;
    }

    int getTracePoint() {
        return this.tracePoint;
    }

    long getVarargListPointer() {
        return this.varargListPointer;
    }

    long getCreateTime() {
        return this.traceCreateTime;
    }

    int getCreatingTcb() {
        return this.traceCreateTcb;
    }

    int getCreateState() {
        return this.traceCreateState;
    }

    int getCreateKey() {
        return this.traceCreateKey;
    }
}

