/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.core.utils.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.utils.DirectBufferHelper;
import com.ibm.ws.zos.core.utils.NativeUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

@Trivial
public class DirectBufferHelperImpl
implements DirectBufferHelper {
    protected static final long GIGABYTE_MASK = -1073741824L;
    protected static final long GIGABYTE_OFFSET_MASK = 0x3FFFFFFFL;
    protected final ThreadLocal<Map<BufferKey, ByteBuffer>> segments = new ThreadLocal<Map<BufferKey, ByteBuffer>>(){
        static final long serialVersionUID = -7908833429218063505L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public Map<BufferKey, ByteBuffer> initialValue() {
            return new HashMap<BufferKey, ByteBuffer>();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    protected final ThreadLocal<BufferHolder> recentBuffer = new ThreadLocal();
    private NativeUtils nativeUtils = null;

    protected void activate(Map<String, Object> properties) throws Exception {
    }

    protected void deactivate() {
    }

    protected void setNativeUtils(NativeUtils nativeUtils) {
        this.nativeUtils = nativeUtils;
    }

    protected void unsetNativeUtils(NativeUtils nativeUtils) {
        if (this.nativeUtils == nativeUtils) {
            this.nativeUtils = null;
        }
    }

    @Override
    public ByteBuffer getSlice(long address, int length) {
        if ((long)length > 0x40000000L) {
            throw new IllegalArgumentException("Length must not exceed 1 GB");
        }
        int segmentOffset = this.getSegmentOffset(address);
        ByteBuffer segment = this.getSegment(address);
        segment.limit(segment.capacity()).position(segmentOffset).limit(segmentOffset + length);
        return segment.slice();
    }

    @Override
    public byte get(long address) {
        return this.getSegment(address).get(this.getSegmentOffset(address));
    }

    @Override
    public void get(long address, byte[] dest) {
        this.get(address, dest, 0, dest.length);
    }

    @Override
    public void get(long address, byte[] dest, int offset, int length) {
        if ((long)dest.length > 0x40000000L) {
            throw new IllegalArgumentException("Copy must not exceed 1 GB");
        }
        ByteBuffer segment = this.getSegment(address);
        segment.limit(segment.capacity()).position(this.getSegmentOffset(address));
        segment.get(dest, offset, length);
    }

    @Override
    public char getChar(long address) {
        return this.getSegment(address).getChar(this.getSegmentOffset(address));
    }

    @Override
    public double getDouble(long address) {
        return this.getSegment(address).getDouble(this.getSegmentOffset(address));
    }

    @Override
    public float getFloat(long address) {
        return this.getSegment(address).getFloat(this.getSegmentOffset(address));
    }

    @Override
    public int getInt(long address) {
        return this.getSegment(address).getInt(this.getSegmentOffset(address));
    }

    @Override
    public long getLong(long address) {
        return this.getSegment(address).getLong(this.getSegmentOffset(address));
    }

    @Override
    public short getShort(long address) {
        return this.getSegment(address).getShort(this.getSegmentOffset(address));
    }

    @Override
    public ByteBuffer getSegment(long address) {
        BufferHolder holder = this.recentBuffer.get();
        long base = this.getSegmentBase(address);
        if (holder != null && holder.base == base) {
            return holder.buffer;
        }
        BufferKey key = new BufferKey(base);
        ByteBuffer buffer = this.segments.get().get(key);
        if (buffer == null) {
            holder = new BufferHolder();
            holder.base = base;
            holder.buffer = buffer = this.mapDirectByteBuffer(base, Integer.MAX_VALUE);
            this.segments.get().put(key, holder.buffer);
            this.recentBuffer.set(holder);
        }
        return buffer;
    }

    protected long getSegmentBase(long address) {
        return address & 0xFFFFFFFFC0000000L;
    }

    protected int getSegmentOffset(long address) {
        return (int)(address & 0x3FFFFFFFL);
    }

    protected ByteBuffer mapDirectByteBuffer(long address, int size) {
        return this.nativeUtils.mapDirectByteBuffer(address, size);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class BufferHolder {
        long base;
        ByteBuffer buffer;
        static final long serialVersionUID = 4563441907688037337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected BufferHolder() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BufferHolder.class);
        }
    }

    @Trivial
    protected static final class BufferKey {
        final long baseAddress;
        final int hashCode;

        BufferKey(long baseAddress) {
            this.baseAddress = baseAddress;
            this.hashCode = (int)(baseAddress >> 30);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof BufferKey) {
                BufferKey that = (BufferKey)o;
                return this.baseAddress == that.baseAddress;
            }
            return false;
        }
    }
}

