/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.core.structures.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.structures.NativeAscb;
import com.ibm.ws.zos.core.structures.NativePsa;
import com.ibm.ws.zos.core.utils.DirectBufferHelper;
import java.nio.ByteBuffer;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NativeAscbImpl
implements NativeAscb {
    private NativePsa nativePsa = null;
    private DirectBufferHelper directBufferHelper = null;
    protected static final int ASCB_LENGTH = 384;
    protected static final int ASCB_ASCBASSB_OFFSET = 336;
    protected static final int ASCB_ASCBJBNS_OFFSET = 176;
    protected static final int ASCB_ASCBJBNI_OFFSET = 172;
    protected static final int ASCB_ASCBASID_OFFSET = 36;
    static final long serialVersionUID = -5917840413320644681L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(Map<String, Object> properties) throws Exception {
    }

    protected void deactivate() {
    }

    protected void setNativePsa(NativePsa nativePsa) {
        this.nativePsa = nativePsa;
    }

    protected void unsetNativePsa(NativePsa nativePsa) {
        if (this.nativePsa == nativePsa) {
            this.nativePsa = null;
        }
    }

    protected void setDirectBufferHelper(DirectBufferHelper directBufferHelper) {
        this.directBufferHelper = directBufferHelper;
    }

    protected void unsetDirectBufferHelper(DirectBufferHelper directBufferHelper) {
        if (this.directBufferHelper == directBufferHelper) {
            this.directBufferHelper = null;
        }
    }

    @Override
    public ByteBuffer mapMyAscb() {
        return this.directBufferHelper.getSlice(this.nativePsa.getPSAAOLD(), 384);
    }

    @Override
    public long getASCBASSB() {
        return this.directBufferHelper.getInt(this.nativePsa.getPSAAOLD() + 336L);
    }

    @Override
    public byte[] getASCBJBNS() {
        long ascbjbns = this.directBufferHelper.getInt(this.nativePsa.getPSAAOLD() + 176L);
        byte[] jobname = new byte[8];
        this.directBufferHelper.get(ascbjbns, jobname);
        return jobname;
    }

    @Override
    public byte[] getASCBJBNI() {
        long ascbjbni = this.directBufferHelper.getInt(this.nativePsa.getPSAAOLD() + 172L);
        byte[] jobname = new byte[8];
        this.directBufferHelper.get(ascbjbni, jobname);
        return jobname;
    }

    @Override
    public short getASCBASID() {
        return this.directBufferHelper.getShort(this.nativePsa.getPSAAOLD() + 36L);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(NativeAscbImpl.class);
    }
}

